/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Minotaur
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SWING = BUILDER.add("swing", AnimationsBuilder.definition((double)1.08).marker("attack", new double[]{0.72}));
    public static final String INTERACT = BUILDER.add("interact", SWING);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)1.48).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{1.28}).marker("reset", new double[]{0.84}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)2.64).marker("attack_start", new double[]{0.64}).marker("attack_end", new double[]{2.2}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Minotaur> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private class_243 spinDirection;
    private float spinAngle;

    public Minotaur(class_1299<? extends Minotaur> type, class_1937 level) {
        super((class_1299<? extends ChargingMonster>)type, level);
    }

    @Override
    protected Consumer<AnimationDefinition> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimationDefinition)anim);
            if (!this.method_37908().field_9236 && (anim == null || anim.is(new String[]{SPIN}))) {
                this.hitEntity = null;
                this.spinDirection = null;
            }
        };
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SWING}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(7).start(new String[]{SPIN}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{CHARGE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(3).start(new String[]{CHARGE}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(5.0)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(8).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim.is(new String[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        if (anim.is(new String[]{SPIN})) {
            double attackSize = (double)this.method_17681() * 1.4;
            return new class_238(-attackSize, -0.2, -attackSize, attackSize, (double)this.method_17682() + 0.2, attackSize);
        }
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            source.knock(DynamicDamage.KnockBackType.BACK, 2.0f);
        } else if (this.getAnimationHandler().isCurrent(new String[]{SWING})) {
            source.withChangedAttribute((class_6880<class_1320>)RuneCraftoryAttributes.STUN.asHolder(), 30.0);
        }
        return source;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{SPIN})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList();
            }
            if (this.spinDirection == null) {
                this.spinDirection = EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(0.1);
                this.spinAngle = this.method_36454() + 90.0f;
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                this.method_18800(this.spinDirection.method_10216(), this.method_18798().field_1351, this.spinDirection.method_10215());
                float start = (float)(anim.getMarker("attack_start", 0) * 20.0);
                float end = (float)(anim.getMarker("attack_end", 0) * 20.0);
                float f = (float)anim.progress((double)start, (double)end, 1.0f, 0);
                float fNext = (float)anim.progress((double)start, (double)end, 1.0f, 1);
                float angleInc = -490.0f;
                if (anim.isAt("reset")) {
                    this.hitEntity.clear();
                }
                this.hitEntity.addAll(CombatUtils.EntityAttack.create((class_1309)this, CombatUtils.EntityAttack.circleTargetsFixedRange(this.spinAngle + f * angleInc, this.spinAngle + fNext * angleInc, 4.5f)).withTargetPredicate(e -> this.hitPred.test(e) && !this.hitEntity.contains(e)).executeAttack());
            }
        } else {
            if (anim.is(new String[]{SWING}) && anim.isAt("attack")) {
                S2CScreenShake.sendAround((class_1297)this, 16.0, 5, 3.0f);
                this.method_37908().method_8396(null, this.method_24515(), (class_3414)class_3417.field_15152.comp_349(), this.method_5634(), 1.0f, 0.9f);
            }
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<? extends Minotaur> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(CHARGE);
    }

    @Override
    public double chargingSpeed() {
        return 0.5;
    }

    @Override
    public boolean handleChargeMovement(AnimationState anim) {
        boolean res = super.handleChargeMovement(anim);
        if (res && this.field_6012 % 7 == 0) {
            this.method_5783((class_3414)RuneCraftorySounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
        return res;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

