/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.MobArrowEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.Orc;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class OrcArcher
extends Orc {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder(Orc.BUILDER, new String[]{SLEEP});
    public static final String MELEE = BUILDER.add("kick", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.58}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String RANGED = BUILDER.add("bow", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.6}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<OrcArcher> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public OrcArcher(class_1299<? extends OrcArcher> type, class_1937 level) {
        super((class_1299<? extends Orc>)type, level);
    }

    @Override
    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(MELEE)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{RANGED}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(e -> e.method_6047().method_7909() instanceof class_1753).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(1, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifFurtherThan(7.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.2;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        if (anim.is(new String[]{RANGED})) {
            this.method_6019(class_1268.field_5808);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{RANGED})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968())) {
                    this.shootArrow(this.method_5968());
                } else if (this.method_31483() instanceof class_1657) {
                    this.shootArrowFromRotation((class_1309)this);
                }
                this.method_6021();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<OrcArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(RANGED);
            }
        }
    }

    private void shootArrow(class_1309 target) {
        MobArrowEntity arrow = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
        arrow.shootAtEntity((class_1297)target, 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
    }

    private void shootArrowFromRotation(class_1309 shooter) {
        MobArrowEntity arrow = new MobArrowEntity(this.method_37908(), (class_1309)this, 0.8f);
        arrow.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, 1.3f, 7 - this.method_37908().method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }
}

