/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetWaterPrioritizingWalkTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.control.SwimWalkMoveController;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.AmphibiousNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Tortas
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String BITE = BUILDER.add("bite", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.32}));
    public static final String INTERACT = BUILDER.add("interact", BITE);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)2.5).marker("attack_start", new double[]{0.0}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    protected final class_1408 waterNavigator;
    protected final class_1408 groundNavigator;
    private final AnimationHandler<Tortas> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Tortas(class_1299<? extends Tortas> type, class_1937 level) {
        super((class_1299<? extends ChargingMonster>)type, level);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new SwimWalkMoveController((class_1308)this, 1.2);
        this.waterNavigator = new AmphibiousNavigator((class_1308)this, level);
        this.groundNavigator = this.field_6189;
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.18);
        this.method_5996(class_5134.field_47761).method_6192(((class_1320)class_5134.field_47761.comp_349()).method_6169() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{BITE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{BITE}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{SPIN}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(1, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(4, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetWaterPrioritizingWalkTarget();
    }

    @Override
    protected int wanderChance() {
        return this.method_5681() ? 5 : 100;
    }

    @Override
    protected boolean canFloatInWater() {
        return false;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.2;
        double length = (double)this.method_17681() * 1.4;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        if (anim != null && anim.equals(SPIN)) {
            int diffAdd = this.difficultyCooldown();
            return this.method_59922().method_43048(50) + 30 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, class_243 target, double grow) {
        if (anim != null && anim.is(new String[]{SPIN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    public AnimationHandler<Tortas> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(SPIN);
    }

    @Override
    public double chargingSpeed() {
        return 0.3f;
    }

    @Override
    public boolean handleChargeMovement(AnimationState anim) {
        class_243 prevMotion = this.method_18798();
        if (this.method_5968() != null) {
            class_243 pos = this.method_19538();
            class_243 target = this.method_5968().method_19538();
            class_243 mot = target.method_1023(pos.field_1352, this.method_5799() ? pos.field_1351 : target.field_1351, pos.field_1350).method_1029().method_1021(0.27);
            this.method_18800(mot.field_1352, mot.field_1351, mot.field_1350);
            if (!this.method_24828() && !this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, prevMotion.field_1351, 0.0));
            }
        } else {
            class_243 look = this.method_5631(this.method_5799() ? this.method_36455() : 0.0f, this.method_36454()).method_1021(0.27);
            this.method_18800(look.field_1352, look.field_1351, look.field_1350);
            if (!this.method_24828() && !this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, prevMotion.field_1351, 0.0));
            }
        }
        return true;
    }

    @Override
    public void doWhileCharge() {
        if (this.field_6012 % 4 == 0) {
            this.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.2f + 1.0f);
        }
        if (this.field_6012 % 8 == 0) {
            this.hitEntity.clear();
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(BITE);
            }
        }
    }

    @Override
    public void setDoJumping(boolean jump) {
        if (this.method_5799()) {
            super.setDoJumping(jump);
        }
    }

    @Override
    public void method_6091(class_243 vec) {
        if (this.method_6034() && this.method_5799()) {
            this.handleFreeTravel(vec);
        } else {
            super.method_6091(vec);
        }
    }

    @Override
    public double ridingSpeedModifier() {
        return 0.8;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{SPIN})) {
            return this.method_18798();
        }
        return super.directionToLookAt();
    }

    @Override
    public boolean adjustRotFromRider(class_1309 rider) {
        return true;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_15183;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14856;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.75f;
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public void method_5790() {
        if (!this.method_37908().field_9236) {
            if (this.method_5799()) {
                this.field_6189 = this.waterNavigator;
                this.method_5796(true);
            } else {
                this.field_6189 = this.groundNavigator;
                this.method_5796(false);
            }
        }
    }

    public boolean method_5675() {
        return false;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

