/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class NPCFriendPoints {
    private int lastUpdateTalk = -1;
    private int lastUpdateGift = -1;
    private final Set<String> answeredConversations = new HashSet<String>();
    public final XpLevelHolder points = new XpLevelHolder();
    private int talkCount;

    public boolean talked() {
        return this.lastUpdateTalk != -1;
    }

    public boolean talkTo(class_1937 level, int xp) {
        int day = WorldUtils.day(level);
        if (day != this.lastUpdateTalk) {
            this.points.addXP(xp, 10, LevelCalc::friendPointsForNext, () -> {});
            this.lastUpdateTalk = day;
            this.answeredConversations.clear();
            ++this.talkCount;
            return true;
        }
        return false;
    }

    public boolean giftXP(class_1937 level, int xp) {
        int day = WorldUtils.day(level);
        if (day != this.lastUpdateGift) {
            this.points.addXP(xp, 20, LevelCalc::friendPointsForNext, () -> {});
            this.lastUpdateGift = day;
            return true;
        }
        return false;
    }

    public boolean answer(String conversation, int xp) {
        if (!this.answeredConversations.contains(conversation)) {
            this.points.addXP(xp, 20, LevelCalc::friendPointsForNext, () -> {});
            this.answeredConversations.add(conversation);
            return true;
        }
        return false;
    }

    public int getTalkCount() {
        return this.talkCount;
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10566("FriendPoints", (class_2520)this.points.save());
        tag.method_10569("LastTalk", this.lastUpdateTalk);
        tag.method_10569("LastGift", this.lastUpdateGift);
        tag.method_10569("TalkCount", this.talkCount);
        class_2499 answers = new class_2499();
        this.answeredConversations.forEach(s -> answers.add((Object)class_2519.method_23256((String)s)));
        tag.method_10566("Answered", (class_2520)answers);
        return tag;
    }

    public void load(class_2487 tag) {
        this.points.read((class_2520)tag.method_10562("FriendPoints"));
        this.lastUpdateTalk = tag.method_10550("LastTalk");
        this.lastUpdateGift = tag.method_10550("LastGift");
        this.talkCount = tag.method_10550("TalkCount");
        class_2499 answers = tag.method_10554("Answered", 8);
        answers.forEach(t -> this.answeredConversations.add(t.method_10714()));
    }
}

