/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCFriendPoints;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class NPCRelationManager {
    public static final int QUEST_COMPLETED = -2;
    public static final int QUEST_NOT_STARTED = -1;
    private final Map<UUID, NPCFriendPoints> playerHearts = new HashMap<UUID, NPCFriendPoints>();
    private final Map<UUID, Set<class_2960>> completedQuests = new HashMap<UUID, Set<class_2960>>();
    private final Map<UUID, Map<class_2960, Integer>> questTracker = new HashMap<UUID, Map<class_2960, Integer>>();

    public boolean talkedTo(UUID uuid) {
        return this.playerHearts.containsKey(uuid);
    }

    public NPCFriendPoints getFriendPointData(UUID uuid) {
        return this.playerHearts.computeIfAbsent(uuid, key -> new NPCFriendPoints());
    }

    public void completeQuest(UUID uuid, class_2960 questID) {
        this.completedQuests.computeIfAbsent(uuid, key -> new HashSet()).add(questID);
    }

    public Set<class_2960> getCompletedQuests(UUID uuid) {
        return ImmutableSet.copyOf((Collection)this.completedQuests.computeIfAbsent(uuid, key -> new HashSet()));
    }

    public int questStateFor(UUID uuid, class_2960 questID) {
        return this.questTracker.computeIfAbsent(uuid, key -> new HashMap()).getOrDefault(questID, -1);
    }

    public int advanceQuest(UUID uuid, class_2960 questID) {
        int newState = this.questStateFor(uuid, questID) + 1;
        Map map = this.questTracker.computeIfAbsent(uuid, key -> new HashMap());
        map.put(questID, newState);
        return newState;
    }

    public void endQuest(UUID uuid, class_2960 questID) {
        Map map = this.questTracker.computeIfAbsent(uuid, key -> new HashMap());
        map.put(questID, -2);
    }

    public void resetQuest(UUID uuid, class_2960 questID) {
        Map<class_2960, Integer> map = this.questTracker.get(uuid);
        if (map != null) {
            map.remove(questID);
            if (map.isEmpty()) {
                this.questTracker.remove(uuid);
            }
        }
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        class_2487 heartsTag = new class_2487();
        this.playerHearts.forEach((uuid, hearts) -> heartsTag.method_10566(uuid.toString(), (class_2520)hearts.save()));
        compound.method_10566("PlayerHearts", (class_2520)heartsTag);
        class_2487 quests = new class_2487();
        this.completedQuests.forEach((uuid, hearts) -> {
            class_2499 list = new class_2499();
            hearts.forEach(res -> list.add((Object)class_2519.method_23256((String)res.toString())));
            quests.method_10566(uuid.toString(), (class_2520)list);
        });
        compound.method_10566("CompletedQuests", (class_2520)quests);
        class_2487 questsTracker = new class_2487();
        this.questTracker.forEach((uuid, tracker) -> {
            class_2487 states = new class_2487();
            tracker.forEach((id, state) -> states.method_10569(id.toString(), state.intValue()));
            questsTracker.method_10566(uuid.toString(), (class_2520)states);
        });
        compound.method_10566("QuestStates", (class_2520)questsTracker);
        return compound;
    }

    public void load(class_2487 compound) {
        class_2487 heartsTag = compound.method_10562("PlayerHearts");
        heartsTag.method_10541().forEach(key -> {
            NPCFriendPoints points = new NPCFriendPoints();
            points.load(heartsTag.method_10562(key));
            this.playerHearts.put(UUID.fromString(key), points);
        });
        class_2487 quests = compound.method_10562("CompletedQuests");
        quests.method_10541().forEach(key -> {
            class_2499 listTag = quests.method_10554(key, 8);
            HashSet set = new HashSet();
            listTag.forEach(t -> set.add(class_2960.method_60654((String)t.method_10714())));
            this.completedQuests.put(UUID.fromString(key), set);
        });
        class_2487 questsTracker = compound.method_10562("QuestStates");
        questsTracker.method_10541().forEach(key -> {
            class_2487 states = questsTracker.method_10562(key);
            HashMap map = new HashMap();
            states.method_10541().forEach(id -> map.put(class_2960.method_60654((String)id), states.method_10550(id)));
            this.questTracker.put(UUID.fromString(key), map);
        });
    }
}

