/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.apache.logging.log4j.Logger;

public class NPCFeatureContainer {
    private final Map<NPCFeatureType<?>, NPCFeature> map = new HashMap();
    public final Map<NPCFeatureType<?>, NPCFeature> view = Collections.unmodifiableMap(this.map);

    public <T extends NPCFeature> T getFeature(NPCFeatureType<T> type) {
        return (T)this.map.get(type);
    }

    public void buildFromLooks(NPCEntity npc, Collection<NPCFeature.NPCFeatureHolder<?>> features) {
        this.map.clear();
        features.forEach(feat -> this.map.put(feat.getType(), (NPCFeature)feat.create(npc)));
    }

    public class_2520 save(class_7225.class_7874 provider) {
        return (class_2520)NPCFeature.FEATURE_CODEC.listOf().encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), List.copyOf(this.map.values())).getOrThrow();
    }

    public NPCFeatureContainer read(class_2520 tag, class_7225.class_7874 provider) {
        this.map.clear();
        ((List)NPCFeature.FEATURE_CODEC.listOf().parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).promotePartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).getOrThrow()).forEach(feature -> this.map.put(feature.type(), (NPCFeature)feature));
        return this;
    }

    public void toBuffer(class_9129 buf) {
        buf.method_53002(this.map.size());
        this.map.forEach((type, feat) -> NPCFeature.STREAM_CODEC.encode((Object)buf, feat));
    }

    public NPCFeatureContainer fromBuffer(class_9129 buf) {
        this.map.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NPCFeature feat = (NPCFeature)NPCFeature.STREAM_CODEC.decode((Object)buf);
            this.map.put(feat.type(), feat);
        }
        return this;
    }

    public void with(NPCFeatureContainer other) {
        this.map.clear();
        this.map.putAll(other.map);
    }
}

