/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.profession;

import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BathhouseAttendant
extends NPCProfession {
    public static final String BATH_ACTION = "runecraftory.npc.action.bath";
    public static final String BATH_ACTION_SUCCESS = "runecraftory.npc.action.bath.success";
    public static final String BATH_ACTION_FAIL = "runecraftory.npc.action.bath.fail";
    public static final String BATH_COST = "runecraftory.npc.shop.bath.cost";

    public BathhouseAttendant(NPCProfession.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(NPCEntity npc, class_1657 player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BATH_ACTION)) {
            int baths;
            int amount;
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            if (data.useMoney(amount = 300 * (baths = data.getDailyUpdater().getBathCounter() + 1) + Math.max(0, baths - 1) * 100)) {
                player.method_7353((class_2561)class_2561.method_43469((String)BATH_ACTION_SUCCESS, (Object[])new Object[]{player.method_5477()}), false);
                player.method_6092(new class_1293(RuneCraftoryEffects.BATH.asHolder(), 1700, 0, false, true, false));
                data.getDailyUpdater().increaseBathCounter();
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)BATH_ACTION_FAIL, (Object[])new Object[]{player.method_5477(), amount}), false);
            }
        }
    }

    @Override
    public Map<String, List<class_2561>> actions(NPCEntity entity, class_3222 player) {
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
        int baths = data.getDailyUpdater().getBathCounter() + 1;
        int cost = 300 * baths + Math.max(0, baths - 1) * 100;
        return Map.of(BATH_ACTION, List.of(class_2561.method_43469((String)BATH_COST, (Object[])new Object[]{cost})));
    }
}

