/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.utils;

import io.github.flemmli97.runecraftory.common.network.S2CBoundEntityPacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public class BoundEntityListHandler<T extends class_1297>
implements Iterable<class_1309> {
    private final T entity;
    private final Predicate<class_1309> syncTest;
    private final List<class_1309> entities = new ArrayList<class_1309>();

    public BoundEntityListHandler(T entity) {
        this(entity, living -> living instanceof class_1657);
    }

    public BoundEntityListHandler(T entity, Predicate<class_1309> syncTest) {
        this.entity = entity;
        this.syncTest = syncTest;
    }

    public void add(class_1309 entity) {
        this.entities.add(entity);
        if (!this.entity.method_37908().field_9236 && this.syncTest.test(entity)) {
            S2CBoundEntityPacket.add(this.entity, entity);
        }
    }

    public void remove(class_1309 entity) {
        if (this.entities.remove(entity) && !this.entity.method_37908().field_9236 && this.syncTest.test(entity)) {
            S2CBoundEntityPacket.remove(this.entity, entity);
        }
    }

    public void clear() {
        this.entities.clear();
        if (!this.entity.method_37908().field_9236) {
            S2CBoundEntityPacket.clear(this.entity);
        }
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public boolean has(class_1309 entity) {
        return this.entities.contains(entity);
    }

    @Override
    public Iterator<class_1309> iterator() {
        return this.entities.iterator();
    }
}

