/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.utils;

import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_2940;
import net.minecraft.class_3532;

public class MoveStateTracker {
    private final class_1309 entity;
    private final int transitionTime;
    private final class_2940<Byte> moveFlagData;
    private final Supplier<MoveType> calculateState;
    private final int[] states = new int[MoveType.values().length];
    private int genericMoveTick;

    public MoveStateTracker(class_1309 entity, int transitionTime, class_2940<Byte> moveFlagData, Supplier<MoveType> calculateState) {
        this.entity = entity;
        this.transitionTime = transitionTime;
        this.moveFlagData = moveFlagData;
        this.calculateState = calculateState;
    }

    private MoveType getCurrent() {
        return MoveType.values()[(Byte)this.entity.method_5841().method_12789(this.moveFlagData)];
    }

    public void tick() {
        if (!this.entity.method_37908().field_9236) {
            MoveType moveType = this.calculateState.get();
            switch (moveType) {
                case NONE: {
                    this.entity.method_5660(false);
                    this.entity.method_5728(false);
                    break;
                }
                case SNEAK: {
                    this.entity.method_5660(false);
                    break;
                }
                case RUN: {
                    this.entity.method_5728(false);
                }
            }
            this.entity.method_5841().method_12778(this.moveFlagData, (Object)((byte)moveType.ordinal()));
        }
        MoveType current = this.getCurrent();
        for (int i = 0; i < this.states.length; ++i) {
            if (i == current.ordinal()) {
                int n = i;
                int n2 = this.states[n] + 1;
                this.states[n] = n2;
                this.states[i] = Math.min(this.transitionTime, n2);
                continue;
            }
            int n = i;
            int n3 = this.states[n] - 1;
            this.states[n] = n3;
            this.states[i] = Math.max(-1, n3);
        }
        this.genericMoveTick = current != MoveType.NONE ? Math.min(this.transitionTime, ++this.genericMoveTick) : Math.max(-1, --this.genericMoveTick);
    }

    public float interpolatedMoveTick(float partialTicks) {
        if (this.genericMoveTick == -1) {
            return 0.0f;
        }
        float speedMod = class_3532.method_15363((float)(this.entity.field_42108.method_48570(partialTicks) / 0.25f), (float)0.0f, (float)1.0f);
        MoveType current = this.getCurrent();
        return class_3532.method_15363((float)(((float)this.genericMoveTick + (current != MoveType.NONE ? partialTicks : -partialTicks)) / (float)this.transitionTime), (float)0.0f, (float)1.0f) * speedMod;
    }

    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        int tick = this.states[moveType.ordinal()];
        if (tick == -1) {
            return 0.0f;
        }
        float speedMod = moveType.speedDependent ? class_3532.method_15363((float)(this.entity.field_42108.method_48570(partialTicks) / 0.25f), (float)0.0f, (float)1.0f) : 1.0f;
        MoveType current = this.getCurrent();
        return class_3532.method_15363((float)(((float)tick + (current == moveType ? partialTicks : -partialTicks)) / (float)this.transitionTime), (float)0.0f, (float)1.0f) * speedMod;
    }
}

