/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.common.advancements.CropHarvestTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attackactions.NaiveBladeAttack;
import io.github.flemmli97.runecraftory.common.blocks.MineralBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.misc.HoeTillableItemEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolSickle;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.network.S2CSyncConfig;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.common.world.data.family.FamilyHandler;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.mixin.LivingEntityAccessor;
import io.github.flemmli97.runecraftory.mixinhelper.AttributeInstanceExtension;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_3738;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class EntityCalls {
    public static void joinPlayer(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CCalendar(RunecraftorySavedData.get(serverPlayer.method_5682()).getCalendar()), serverPlayer);
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            data.onJoin();
            QuestHandler.removeNPCQuestsFor(serverPlayer);
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CSyncConfig(), serverPlayer);
            FamilyHandler.get(serverPlayer.method_5682()).getOrCreateEntry((class_1657)serverPlayer).updateName((class_1297)player);
        }
    }

    public static void onPlayerLoad(class_3222 serverPlayer) {
        serverPlayer.method_5682().method_18858((Runnable)new class_3738(2, () -> {
            Set<RunecraftorySavedData.UnloadedPartyMember> party = RunecraftorySavedData.get(serverPlayer.method_5682()).getUnloadedPartyMembersFor((class_1657)serverPlayer);
            party.forEach(p -> {
                class_4208 pos = p.pos();
                class_3218 level = serverPlayer.method_51469();
                if (level.method_27983() != p.pos().comp_2207()) {
                    level = serverPlayer.method_5682().method_3847(pos.comp_2207());
                }
                if (level != null) {
                    level.method_14178().method_17297(class_3230.field_19280, new class_1923(pos.comp_2208()), 3, (Object)pos.comp_2208());
                }
            });
            party.clear();
        }));
        Set<UUID> toRemove = RunecraftorySavedData.get(serverPlayer.method_5682()).removedPartyMembersFor((class_1657)serverPlayer);
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)serverPlayer);
        toRemove.forEach(data.party::removePartyMember);
        toRemove.clear();
    }

    public static boolean handleItemJoinLevel(class_1542 entity) {
        if (DataPackHandler.INSTANCE.fertilizerManager().get(entity.method_6983().method_7909()) != null) {
            entity.method_31472();
            entity.method_37908().method_8649((class_1297)new HoeTillableItemEntity(entity.method_37908(), entity));
            return true;
        }
        return false;
    }

    public static void onLoadEntity(class_1309 living) {
        if (living instanceof class_3222) {
            class_3222 player = (class_3222)living;
            EntityCalls.onPlayerLoad(player);
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CCapSync(Platform.INSTANCE.getPlayerData((class_1657)player)), player);
            EntityCalls.updateWeaponState(living);
        }
    }

    public static void updateEquipment(class_1309 entity, Map<class_1304, class_1799> changed, class_1799 lastMainhandItem, Function<class_1304, class_1799> lastArmor) {
        for (Map.Entry<class_1304, class_1799> entry : changed.entrySet()) {
            if (entry.getKey().method_5925() != class_1304.class_1305.field_6178) continue;
            class_1799 now = entry.getValue();
            class_1799 last = lastArmor.apply(entry.getKey());
            ArmorEffect.runArmorEffectFor(last, effect -> effect.onRemove(entity, last));
            ArmorEffect.runArmorEffectFor(now, effect -> effect.onEquip(entity, now));
        }
        if (changed.containsKey(class_1304.field_6173) || changed.containsKey(class_1304.field_6171)) {
            float shieldEfficiency = ItemComponentUtils.getShieldEfficiency(entity);
            EntityCalls.recalcOffhandBonus(entity, shieldEfficiency);
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            EntityUtils.sendAttributesTo((class_1309)serverPlayer, serverPlayer);
            EntityCalls.updateWeaponState(entity);
        }
    }

    private static void updateWeaponState(class_1309 entity) {
        boolean weapon = ItemComponentUtils.isWeapon(entity.method_6047());
        class_1324 inst = entity.method_5996(class_5134.field_23721);
        if (inst != null) {
            ((AttributeInstanceExtension)inst).runecraftory$setAttributeModifierFilter(weapon ? null : mod -> !mod.comp_2447().method_12836().equals("runecraftory"));
        }
    }

    private static void recalcOffhandBonus(class_1309 entity, float efficiency) {
        if (efficiency == 1.0f) {
            ((AttributeMapAccessor)entity.method_6127()).getAttributes().forEach((att, inst) -> inst.method_6200(LibConstants.SHIELD_PENALTY));
            return;
        }
        float reduction = 1.0f - efficiency;
        HashMap<class_6880, class_1322> offhandMods = new HashMap<class_6880, class_1322>();
        ((AttributeMapAccessor)entity.method_6127()).getAttributes().forEach((att, inst) -> {
            class_1322 mod = inst.method_6199(LibConstants.EQUIPMENT_MODIFIERS.get(class_1304.field_6171));
            if (mod != null) {
                offhandMods.put((class_6880)att, mod);
            }
        });
        offhandMods.forEach((att, mod) -> entity.method_6127().method_45329(att).method_26835(new class_1322(LibConstants.SHIELD_PENALTY, -mod.comp_2449() * (double)reduction, class_1322.class_1323.field_6328)));
    }

    public static boolean playerAttack(class_1657 player, class_1297 target) {
        if (!player.method_37908().field_9236 && ItemComponentUtils.isWeapon(player.method_6047())) {
            CombatUtils.attackWithItem(player, target, true, true);
            return true;
        }
        return false;
    }

    public static boolean cancelLivingAttack(class_1282 source, class_1297 target, float amount) {
        class_1309 living;
        class_1297 attacker = source.method_5529();
        if (!source.method_48789(class_8103.field_42242) && target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            if (data.getWeaponHandler().isInvulnerable((class_1309)player)) {
                return true;
            }
            if (source.method_5526() != null && amount > 0.0f && NaiveBladeAttack.canCounter(data.getWeaponHandler())) {
                data.getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.NAIVE_BLADE.get(), player.method_6047(), null);
                return true;
            }
        }
        if (source instanceof DynamicDamage || attacker instanceof class_1657) {
            return false;
        }
        if (attacker instanceof class_1309 && (living = (class_1309)attacker).method_6047().method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD) && !living.method_5864().method_20210(RunecraftoryTags.EntityTypes.HELD_WEAPON_EXEMPT)) {
            CombatUtils.mobAttack(living, target);
            return true;
        }
        return false;
    }

    public static float damageCalculation(class_1309 entity, class_1282 source, float dmg) {
        float damage = CombatUtils.reduceDamageFromStats(entity, source, dmg);
        if (damage < 0.0f) {
            entity.method_6025(-damage);
        } else if (damage > 1.0f && !source.method_48789(class_8103.field_42242) && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((class_1657)player), Skills.DEFENCE, Math.min(7.0f, (float)(0.5 + Math.log((double)damage * 0.25))) * 1.5f);
        }
        return damage;
    }

    public static void postDamage(class_1309 entity, class_1282 src, float amount) {
        class_1309 living;
        float drainPercent;
        class_1297 attacker = src.method_5529();
        if (attacker instanceof class_1309) {
            entity.method_6016(RuneCraftoryEffects.SLEEP.asHolder());
        }
        if (amount > 0.0f && attacker instanceof class_1309 && (drainPercent = (float)CombatUtils.statusEffectValue(living = (class_1309)attacker, (class_6880<class_1320>)RuneCraftoryAttributes.DRAIN.asHolder(), (class_1297)entity)) > 0.0f) {
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                player.method_6025(drainPercent * amount);
            } else {
                living.method_6025(drainPercent * amount);
            }
        }
    }

    public static boolean playerDeath(class_1309 entity, class_1282 source) {
        if (!entity.method_37908().field_9236) {
            Object object;
            if (!source.method_48789(class_8103.field_42242)) {
                class_1657 player;
                class_1799 deathProt = class_1799.field_8037;
                for (class_1799 stack : entity.method_56675()) {
                    if (stack.method_7909() != RuneCraftoryItems.LAWN.get()) continue;
                    deathProt = stack;
                }
                if (deathProt.method_7960() && entity instanceof class_1657) {
                    player = (class_1657)entity;
                    object = player.method_31548().field_7547.iterator();
                    while (object.hasNext()) {
                        class_1799 stack = (class_1799)object.next();
                        if (stack.method_7909() != RuneCraftoryItems.LAWN.get()) continue;
                        deathProt = stack;
                    }
                }
                if (!deathProt.method_7960()) {
                    if (entity instanceof class_3222) {
                        player = (class_3222)entity;
                        player.method_7259(class_3468.field_15372.method_14956((Object)deathProt.method_7909()));
                        class_174.field_1198.method_8821((class_3222)player, deathProt);
                    }
                    entity.method_6033(entity.method_6063() * 0.33f);
                    entity.method_6012();
                    entity.method_6092(new class_1293(class_1294.field_5907, 5, 100));
                    entity.method_37908().method_8421((class_1297)entity, (byte)35);
                    deathProt.method_7934(1);
                    return true;
                }
            }
            if (MobConfig.vanillaGiveXp && entity instanceof class_1308) {
                class_1308 m = (class_1308)entity;
                if (!(entity instanceof IBaseMob) && (object = source.method_5529()) instanceof class_1309) {
                    class_1309 attacker = (class_1309)object;
                    LevelCalc.addXP(attacker, (int)Math.log(m.method_6063() + 1.0f) * 10, 0, 0, false);
                }
            }
        }
        return false;
    }

    public static void dropInventoryDeath(class_1309 entity) {
        class_3222 player;
        if (entity instanceof class_3222 && !(player = (class_3222)entity).method_37908().method_8450().method_8355(class_1928.field_19389)) {
            Platform.INSTANCE.getPlayerData((class_1657)player).getInv().dropItemsAt((class_1309)player);
        }
    }

    public static void clone(class_1657 origin, class_1657 player, boolean death) {
        if (player instanceof class_3222) {
            PlayerData data = Platform.INSTANCE.getPlayerData(origin);
            if (death) {
                data.useMoney((int)((double)data.getMoney() * 0.2));
            }
            Platform.INSTANCE.getPlayerData(player).readFromNBT(data.writeToNBT(new class_2487(), death));
        }
    }

    public static void cropRightClickHarvest(class_1657 player, class_2680 state, class_2338 pos, class_1268 hand) {
        class_2248 class_22482;
        if (!player.method_37908().field_9236 && (class_22482 = state.method_26204()) instanceof class_2302) {
            class_2302 crop = (class_2302)class_22482;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31573(RunecraftoryTags.Items.QUICKHARVEST_BYPASS)) {
                return;
            }
            if (crop.method_9825(state)) {
                CropProperties props = CropUtils.getPropertiesFor(crop);
                CropUtils.harvestCropRightClick(state, player.method_37908(), pos, (class_1297)player, player.method_6047(), props, hand, null);
            }
        }
    }

    public static boolean onTryBonemeal(class_1937 level, class_1799 stack, class_2680 state, class_2338 pos, @Nullable class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2338 targetPos = null;
            boolean swing = false;
            if (state.method_26204() instanceof Growable) {
                class_2338 below;
                CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.method_26204().method_9574((class_4538)level, pos, state).method_7909());
                if (props != null && FarmlandHandler.isFarmBlock(level.method_8320(below = pos.method_10074()))) {
                    targetPos = below;
                }
                swing = !(state.method_26204() instanceof class_2256);
            } else if (FarmlandHandler.isFarmBlock(state)) {
                targetPos = pos;
                swing = true;
            }
            if (targetPos != null) {
                class_2338 target = targetPos;
                if (player != null && swing) {
                    player.method_23667(player.method_6079().equals(stack) ? class_1268.field_5810 : class_1268.field_5808, true);
                }
                FarmlandHandler.get(serverLevel.method_8503()).getData(serverLevel, target).ifPresent(d -> {
                    if (d.canUseBonemeal()) {
                        d.applyBonemeal(serverLevel);
                        stack.method_7934(1);
                        LoaderNetwork.INSTANCE.sendToAll((class_8710)new S2CTriggers(S2CTriggers.TriggerType.FERTILIZER, target), level.method_8503());
                    }
                });
                return true;
            }
        }
        return player == null && FarmlandHandler.isFarmBlock(state);
    }

    public static void updateLivingTick(class_1309 entity) {
        class_1308 mob;
        boolean disabled;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Platform.INSTANCE.getPlayerData(player).tick();
            if (GeneralConfig.disableHunger) {
                int food = player.method_6059(RuneCraftoryEffects.PARALYSIS.asHolder()) ? 6 : 14;
                player.method_7344().method_7580(food);
                player.method_7344().method_7581(0.0f);
            }
        }
        for (class_1657 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178) continue;
            class_1799 stack = entity.method_6118((class_1304)slot);
            ArmorEffect.runArmorEffectFor(stack, effect -> effect.onTick(entity, stack));
        }
        if (entity instanceof class_1308 && (disabled = EntityUtils.isDisabled((class_1309)(mob = (class_1308)entity))) && !mob.method_5942().method_6357()) {
            mob.method_5942().method_6340();
        }
        Platform.INSTANCE.getEntityData(entity).tick();
    }

    public static boolean rootTick(class_1309 entity) {
        if (entity instanceof class_1657) {
            return false;
        }
        if (entity.method_6059(RuneCraftoryEffects.STUNNED.asHolder())) {
            ((LivingEntityAccessor)entity).tickEffectsManually();
            --entity.field_6008;
            return true;
        }
        return false;
    }

    public static void foodHandling(class_1309 entity, class_1799 stack) {
        if (!entity.method_37908().field_9236) {
            if (entity instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)entity;
                mob.applyFoodEffect(stack);
                return;
            }
            FoodProperties prop = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
            if (prop == null) {
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    if (stack.method_57826(class_9334.field_50075)) {
                        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                        if (data.foodBuff().duration() <= 0) {
                            LevelCalc.levelSkill(data, Skills.EATING, 5.0f);
                        }
                        data.regenRunePoints(EntityUtils.getRPFromVanillaFood(stack));
                    }
                }
                return;
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                if (data.foodBuff().duration() <= 0) {
                    data.getDailyUpdater().onFoodEaten();
                }
                data.applyFoodEffect(stack);
                data.regenRunePoints(prop.getRPRegen() + (int)((double)(data.getMaxRunePoints() * prop.getRpPercentRegen()) * 0.01));
            }
            int healthGain = prop.getHPGain();
            EntityUtils.foodHealing(entity, healthGain);
            int healthPercent = prop.getHpPercentGain();
            EntityUtils.foodHealing(entity, entity.method_6063() * (float)healthPercent * 0.01f);
            if (prop.potionHeals() != null) {
                for (class_6880 class_68802 : prop.potionHeals()) {
                    entity.method_6016(class_68802);
                }
            }
            if (prop.potionApply() != null) {
                for (SimpleEffect simpleEffect : prop.potionApply()) {
                    entity.method_6092(simpleEffect.create());
                }
            }
        }
    }

    public static void wakeUp(class_1657 player) {
        if (GeneralConfig.healOnWakeUp && player instanceof class_3222) {
            player.method_6025(player.method_6063());
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            data.regenRunePoints(data.getMaxRunePoints());
            LevelCalc.levelSkill(data, Skills.SLEEPING, 75.0f);
            player.method_6016(RuneCraftoryEffects.FATIGUE.asHolder());
        }
    }

    public static boolean disableNatural(class_3730 spawnType, class_1299<?> entity) {
        if (MobConfig.disableNaturalSpawn) {
            return (spawnType == class_3730.field_16472 || spawnType == class_3730.field_16459) && entity != RuneCraftoryEntities.GATE.get();
        }
        return false;
    }

    public static void onBlockBreak(class_3222 player, class_2680 state, class_2338 pos) {
        if (state.method_26204() instanceof class_2302) {
            ((CropHarvestTrigger)((Object)RuneCraftoryCriteria.HARVEST_CROP.get())).trigger(player, state);
        }
        if (!player.method_7305(state)) {
            return;
        }
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
        if (state.method_26164(RunecraftoryTags.Blocks.HAMMER_BREAKABLE)) {
            ItemToolHammer.onHammering(player, true);
        } else if (state.method_26164(class_3481.field_33715)) {
            LevelCalc.levelSkill(data, Skills.MINING, state.method_26204() instanceof MineralBlock ? 10.0f : 1.0f);
        }
        if (state.method_26164(class_3481.field_33713)) {
            LevelCalc.levelSkill(data, Skills.LOGGING, 1.0f);
        }
        if (state.method_26164(class_3481.field_33714) && !(player.method_6047().method_7909() instanceof ItemToolSickle)) {
            LevelCalc.levelSkill(data, Skills.FARMING, 1.0f);
        }
        if (state.method_26204() instanceof class_2261) {
            LevelCalc.levelSkill(data, Skills.FARMING, 0.5f);
        }
    }

    public static void onLootTableBlockGen(class_1657 player) {
        if (player instanceof class_3222) {
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            LevelCalc.levelSkill(data, Skills.SEARCHING, 7.0f);
        }
    }

    public static boolean shouldPreventFarmlandTrample(class_1297 entity, class_1936 world) {
        return GeneralConfig.disableFarmlandTrample;
    }

    public static boolean onPlayerUseItem(class_1657 player, class_1268 hand) {
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        return data.getWeaponHandler().getCurrentAction() == RuneCraftoryAttackActions.NONE.get() || class_1799.method_31577((class_1799)player.method_5998(hand), (class_1799)data.getWeaponHandler().get(DataKey.USED_WEAPON));
    }
}

