/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.MineralBlock;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFeatures;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryStructures;
import io.github.flemmli97.runecraftory.common.world.features.BiomeFilteredRandomFeature;
import io.github.flemmli97.runecraftory.common.world.features.MineralFeature;
import io.github.flemmli97.runecraftory.common.world.features.config.BiomeFilteredConfig;
import io.github.flemmli97.runecraftory.common.world.features.config.ChancedBlockClusterConfig;
import io.github.flemmli97.runecraftory.mixinhelper.StructureTemplateModifier;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3085;
import net.minecraft.class_3175;
import net.minecraft.class_3481;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_4638;
import net.minecraft.class_4651;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5452;
import net.minecraft.class_5483;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6646;
import net.minecraft.class_6658;
import net.minecraft.class_6796;
import net.minecraft.class_6799;
import net.minecraft.class_6817;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WorldRegistrationCalls {
    public static final String[] VANILLA_VILLAGES = new String[]{"plains", "desert", "savanna", "snowy", "taiga"};

    public static List<HerbFeatureEntry> defaultHerbEntries() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.WEEDS, 100));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.MUSHROOM, 40));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.MONARCH_MUSHROOM, 10));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.WITHERED_GRASS, 50));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.WHITE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.INDIGO_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.PURPLE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.GREEN_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.BLUE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.YELLOW_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.RED_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.ORANGE_GRASS, 30));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.BLACK_GRASS, 75));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.ELLI_LEAVES, 10));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.ANTIDOTE_GRASS, 75));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.MEDICINAL_HERB, 75));
        builder.add((Object)new HerbFeatureEntry(RuneCraftoryBlocks.BAMBOO_SPROUT, 66));
        return builder.build();
    }

    public static void createFeatures(@Nullable FeatureRegister register, Consumer<FeatureBiomeModifier> placedFeatureHandler) {
        if (register != null) {
            List<HerbFeatureEntry> herbEntries = WorldRegistrationCalls.defaultHerbEntries();
            herbEntries.forEach(entry -> register.registerConfigured(entry.configuredId(), provider -> new class_2975(class_3031.field_21220, (class_3037)new class_4638(64, 8, 8, class_6880.method_40223((Object)new class_6796(class_6880.method_40223((Object)new class_2975(class_3031.field_13518, (class_3037)new class_3175((class_4651)class_4651.method_38432((class_2248)((class_2248)entry.block().get()))))), List.of(class_6658.method_39618((class_6646)class_6646.method_39907((class_6862)class_3481.field_51989)))))))));
            register.registerConfigured(RuneCraftoryFeatures.CONFIGRED_HERB_FEATURE, provider -> {
                List<BiomeFilteredConfig.BiomeFilteredEntry> filtered = herbEntries.stream().map(entry -> new BiomeFilteredConfig.BiomeFilteredEntry((class_6880<class_6796>)class_6880.method_40223((Object)new class_6796(provider.get(entry.configuredId()), List.of())), RunecraftoryTags.Biomes.getBlockBasedGenerationTag(entry.block(), true), RunecraftoryTags.Biomes.getBlockBasedGenerationTag(entry.block(), false), entry.weight())).toList();
                return new class_2975((class_3031)((BiomeFilteredRandomFeature)((Object)((Object)RuneCraftoryFeatures.BIOME_FILTERED_RANDOM_FEATURES.get()))), (class_3037)new BiomeFilteredConfig(filtered));
            });
            register.registerPlaced(RuneCraftoryFeatures.HERB_FEATURE, provider -> new class_6796(provider.get(RuneCraftoryFeatures.CONFIGRED_HERB_FEATURE), List.of(class_6799.method_39659((int)4), class_5450.method_39639(), class_6817.field_36078)));
        }
        placedFeatureHandler.accept(FeatureBiomeModifier.of(RuneCraftoryFeatures.HERB_FEATURE));
        ArrayList<FeatureBiomeModifier> placedFeatures = new ArrayList<FeatureBiomeModifier>();
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_IRON, 15, 2, 5));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_TIN, 20, 2, 4));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_SILVER, 40, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_GOLD, 60, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_PLATINUM, 100, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_ORICHALCUM, 175, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_DIAMOND, 133, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_DRAGONIC, 25, 1, 2));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_AQUAMARINE, 25, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_AMETHYST, 66, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_RUBY, 50, 2, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_EMERALD, 66, 1, 3));
        placedFeatures.addAll(WorldRegistrationCalls.registerMineralFeatures(register, RuneCraftoryBlocks.MINERAL_SAPPHIRE, 66, 2, 3));
        placedFeatures.forEach(placedFeatureHandler);
        if (register != null) {
            register.registerConfigured(RuneCraftoryFeatures.HOT_SPRING_LAKE, p -> new class_2975(class_3031.field_13573, (class_3037)new class_3085.class_6788((class_4651)class_4651.method_38432((class_2248)((class_2248)RuneCraftoryBlocks.HOT_SPRING_WATER.get())), (class_4651)class_4651.method_38432((class_2248)class_2246.field_10340))));
            register.registerPlaced(RuneCraftoryFeatures.PLACED_HOT_SPRING_LAKE, provider -> new class_6796(provider.get(RuneCraftoryFeatures.HOT_SPRING_LAKE), List.of(class_6799.method_39659((int)4), class_5450.method_39639(), class_6817.field_36080)));
        }
        placedFeatureHandler.accept(new FeatureBiomeModifier(RunecraftoryTags.Biomes.HAS_HOT_SPRINGS, class_2893.class_2895.field_25186, RuneCraftoryFeatures.PLACED_HOT_SPRING_LAKE));
    }

    private static List<FeatureBiomeModifier> registerMineralFeatures(@Nullable FeatureRegister register, RegistryEntrySupplier<class_2248, ? extends MineralBlock> block, int chance, int min, int max) {
        class_5321 id = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)RuneCraftory.modRes("mineral_" + block.getID().method_12832().replace("ore_", "")));
        class_5321 idPlaced = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)id.method_29177());
        class_5321 netherIDPlaced = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)id.method_29177().method_12836(), (String)(id.method_29177().method_12832() + "_nether")));
        if (register != null) {
            register.registerConfigured(id, provider -> {
                MineralBlock mineral = (MineralBlock)block.get();
                return new class_2975((class_3031)((MineralFeature)((Object)((Object)RuneCraftoryFeatures.MINERAL_FEATURE.get()))), (class_3037)new ChancedBlockClusterConfig(mineral, RunecraftoryTags.Biomes.getMineralGenTag(mineral.tier, true), RunecraftoryTags.Biomes.getMineralGenTag(mineral.tier, false), (class_6017)class_6019.method_35017((int)min, (int)max), 4, 32));
            });
            register.registerPlaced((class_5321<class_6796>)idPlaced, provider -> new class_6796(provider.get(id), List.of(class_6799.method_39659((int)chance), class_5450.method_39639(), class_6817.field_36085)));
            register.registerPlaced((class_5321<class_6796>)netherIDPlaced, provider -> new class_6796(provider.get(id), List.of(class_5452.method_39620((int)5), class_6799.method_39659((int)chance), class_5450.method_39639())));
        }
        return List.of(FeatureBiomeModifier.of((class_5321<class_6796>)idPlaced), new FeatureBiomeModifier((class_6862<class_1959>)class_6908.field_36518, class_2893.class_2895.field_13178, (class_5321<class_6796>)netherIDPlaced));
    }

    public static class_5483.class_1964 gateSetting() {
        return new class_5483.class_1964((class_1299)RuneCraftoryEntities.GATE.get(), 100, 1, 1);
    }

    public static void addVillageStructures(MinecraftServer server) {
        class_2378 pools = (class_2378)server.method_30611().method_33310(class_7924.field_41249).orElseThrow();
        for (String s : VANILLA_VILLAGES) {
            if (!s.equals("savanna") && !s.equals("desert")) {
                class_3785 streetsPool = (class_3785)pools.method_10223(class_2960.method_60656((String)("village/" + s + "/streets")));
                class_3785 bigStreet = (class_3785)pools.method_10223(RuneCraftory.modRes("npc/streets/big_street_" + s));
                if (bigStreet != null) {
                    WorldRegistrationCalls.addToPool(streetsPool, ((StructureTemplateModifier)bigStreet).runecraftory$getRawTemplates());
                }
            }
            class_3785 housePool = (class_3785)pools.method_10223(class_2960.method_60656((String)("village/" + s + "/houses")));
            class_3785 npcHouses = (class_3785)pools.method_29107(RuneCraftoryStructures.NPC_HOUSES);
            if (npcHouses == null) continue;
            WorldRegistrationCalls.addToPool(housePool, ((StructureTemplateModifier)npcHouses).runecraftory$getRawTemplates());
        }
    }

    private static void addToPool(class_3785 pool, List<Pair<class_3784, Integer>> houses) {
        if (pool == null) {
            return;
        }
        for (Pair<class_3784, Integer> pair : houses) {
            ((StructureTemplateModifier)pool).runecraftory$addPoolElement(pair);
        }
    }

    public record HerbFeatureEntry(RegistryEntrySupplier<class_2248, ?> block, int weight) {
        public class_5321<class_2975<?, ?>> configuredId() {
            return class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)RuneCraftory.modRes(this.block.getID().method_12832()));
        }

        public class_5321<class_6796> placedId() {
            return class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)RuneCraftory.modRes(this.block.getID().method_12832()));
        }
    }

    public static interface FeatureRegister {
        public void registerConfigured(class_5321<class_2975<?, ?>> var1, Function<HolderGetterLookup, class_2975<?, ?>> var2);

        public void registerPlaced(class_5321<class_6796> var1, Function<HolderGetterLookup, class_6796> var2);
    }

    public record FeatureBiomeModifier(class_6862<class_1959> tag, class_2893.class_2895 decoration, class_5321<class_6796> placedFeature) {
        public static FeatureBiomeModifier of(class_5321<class_6796> id) {
            return new FeatureBiomeModifier(RunecraftoryTags.Biomes.VANILLA_DIMENSIONS, class_2893.class_2895.field_13178, id);
        }
    }

    public static interface HolderGetterLookup {
        default public <S> class_6880<S> get(class_5321<S> key) {
            return this.lookup(key.method_58273()).method_46747(key);
        }

        public <S> class_7871<S> lookup(class_5321<? extends class_2378<? extends S>> var1);
    }
}

