/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.blocks.entity.CraftingBlockEntity;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.inventory.WrappedContainer;
import io.github.flemmli97.runecraftory.common.inventory.container.CraftingOutputSlot;
import io.github.flemmli97.runecraftory.common.inventory.container.IngredientsCache;
import io.github.flemmli97.runecraftory.common.network.S2CCraftingRecipes;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.recipes.SpecialSextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMenuTypes;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5916;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class ContainerCrafting
extends class_1703 {
    private final PlayerBoundCraftingContainer craftingInv;
    private final CraftingType type;
    private final WrappedContainer output;
    private final CraftingBlockEntity blockEntity;
    private final class_3915 runePointCost;
    private final CraftingOutputSlot outputSlot;
    private final IngredientsCache cache;
    private List<class_8786<? extends SextupleRecipe>> matchingRecipes;
    private ClientRecipeResult matchingRecipesClient = new ClientRecipeResult(0L, List.of());
    private class_8786<? extends SextupleRecipe> selected;

    public ContainerCrafting(int windowId, class_1661 inv, class_2338 pos) {
        this(windowId, inv, ContainerCrafting.getTile(inv.field_7546.method_37908(), pos));
    }

    public ContainerCrafting(int windowID, class_1661 playerInv, CraftingBlockEntity blockEntity) {
        super((class_3917)RuneCraftoryMenuTypes.CRAFTING_CONTAINER.get(), windowID);
        this.output = new WrappedContainer((class_1263)new class_1277(2));
        this.craftingInv = PlayerBoundCraftingContainer.create(this, blockEntity.getContainer(), playerInv.field_7546);
        this.cache = new IngredientsCache(this.craftingInv);
        this.blockEntity = blockEntity;
        this.type = blockEntity.craftingType();
        this.outputSlot = new CraftingOutputSlot(this.output, this, this.craftingInv, 0, 116, 35);
        this.method_7621(this.outputSlot);
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.method_7621(new class_1735((class_1263)playerInv, hotbar, 8 + hotbar * 18, 142));
        }
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.method_7621(new class_1735((class_1263)playerInv, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.method_7621(new class_1735((class_1263)this.craftingInv, i, 20 + i * 18, 26));
            this.method_7621(new class_1735((class_1263)this.craftingInv, i + 3, 20 + i * 18, 44));
        }
        this.runePointCost = class_3915.method_17403();
        this.method_17362(this.runePointCost);
    }

    public static CraftingBlockEntity getTile(class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CraftingBlockEntity) {
            return (CraftingBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Expected tile entity of type TileCrafting but got " + String.valueOf(blockEntity));
    }

    public void method_34248(class_5916 synchronizer) {
        this.updateCraftingOutput(true);
        super.method_34248(synchronizer);
    }

    public static List<class_8786<SextupleRecipe>> getRecipes(PlayerBoundCraftingContainer inv, CraftingType type) {
        class_1657 class_16572 = inv.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            return serverPlayer.method_5682().method_3772().method_17877(CraftingUtils.getType(type), (class_9695)inv, (class_1937)serverPlayer.method_51469()).stream().filter(h -> SextupleRecipe.getCraftingOutput(inv, (class_8786<? extends SextupleRecipe>)h) != null).sorted(Comparator.comparingInt(r -> ((SextupleRecipe)r.comp_1933()).getCraftingLevel())).toList();
        }
        return new ArrayList<class_8786<SextupleRecipe>>();
    }

    public CraftingType craftingType() {
        return this.type;
    }

    public void updateCraftingOutput(boolean init) {
        if (this.craftingInv.getPlayer().method_37908().field_9236) {
            return;
        }
        if (this.cache.changedAndUpdate()) {
            this.matchingRecipes = new ArrayList<class_8786<? extends SextupleRecipe>>();
            this.matchingRecipes.addAll(ContainerCrafting.getRecipes(this.craftingInv, this.type));
            if (this.matchingRecipes.isEmpty()) {
                class_8786<SpecialSextupleRecipe> recipe;
                switch (this.type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ACCESSORY_WORKBENCH: 
                    case FORGE: {
                        class_8786<SpecialSextupleRecipe> class_87862 = SpecialSextupleRecipe.SCRAP.get();
                        break;
                    }
                    case CHEMISTRY_SET: {
                        class_8786<SpecialSextupleRecipe> class_87862 = SpecialSextupleRecipe.OBJECT_X.get();
                        break;
                    }
                    case COOKING_TABLE: {
                        class_8786<SpecialSextupleRecipe> class_87862 = recipe = SpecialSextupleRecipe.FAILED_DISH.get();
                    }
                }
                if (((SpecialSextupleRecipe)recipe.comp_1933()).matches(this.craftingInv, this.craftingInv.getPlayer().method_37908())) {
                    this.matchingRecipes.add(recipe);
                }
            }
            if (!init) {
                this.blockEntity.resetIndex();
            }
        }
        this.updateCraftingSlot(init, true);
    }

    private void updateCraftingSlot(boolean init, boolean recipeChanged) {
        class_1799 clientOutput;
        class_1799 trueOutput;
        if (this.matchingRecipes != null && !this.matchingRecipes.isEmpty()) {
            if (recipeChanged) {
                if (this.selected != null) {
                    int i;
                    for (i = this.matchingRecipes.size() - 1; i > 0 && !this.selected.equals(this.matchingRecipes.get(i)); --i) {
                    }
                    this.blockEntity.setIndex(i);
                } else if (!init || this.blockEntity.craftingIndex() >= this.matchingRecipes.size()) {
                    this.blockEntity.resetIndex();
                }
            }
            this.selected = this.matchingRecipes.get(this.blockEntity.craftingIndex());
            SextupleRecipe.RecipeOutput output = SextupleRecipe.getCraftingOutput(this.craftingInv, this.selected);
            if (output == null) {
                trueOutput = class_1799.field_8037;
                clientOutput = class_1799.field_8037;
                this.runePointCost.method_17404(-1);
                this.selected = null;
            } else {
                this.runePointCost.method_17404(CraftingUtils.craftingCost(this.type, Platform.INSTANCE.getPlayerData(this.craftingInv.getPlayer()), (SextupleRecipe)this.selected.comp_1933(), output.bonusItems(), output.clientResult().method_7909() != RuneCraftoryItems.UNKNOWN.get()));
                trueOutput = output.serverResult();
                clientOutput = output.clientResult();
            }
        } else {
            trueOutput = class_1799.field_8037;
            clientOutput = class_1799.field_8037;
            this.runePointCost.method_17404(-1);
            this.selected = null;
        }
        this.output.method_5447(0, trueOutput);
        this.output.method_5447(1, clientOutput);
        class_1657 class_16572 = this.craftingInv.getPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            if (recipeChanged) {
                this.sendCraftingRecipesToClient(player, Platform.INSTANCE.getPlayerData((class_1657)player));
            }
            player.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), 0, clientOutput));
        }
    }

    public void sendCraftingRecipesToClient(class_3222 player, PlayerData data) {
        List<class_1799> clientData = this.matchingRecipes.stream().map(recipe -> recipe.comp_1933() instanceof SpecialSextupleRecipe || data.getRecipeKeeper().isUnlocked((class_8786<?>)recipe) ? ((SextupleRecipe)recipe.comp_1933()).method_8110((class_7225.class_7874)player.method_56673()) : new class_1799((class_1935)RuneCraftoryItems.UNKNOWN.get())).toList();
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CCraftingRecipes(new ClientRecipeResult(player.method_37908().method_8510(), clientData), this.selected == null ? 0 : this.matchingRecipes.indexOf(this.selected)), player);
    }

    public void updateCurrentRecipeIndex(int id) {
        id = class_3532.method_15340((int)id, (int)0, (int)(this.matchingRecipes != null ? this.matchingRecipes.size() - 1 : 0));
        this.blockEntity.setIndex(id);
        this.updateCraftingSlot(false, false);
    }

    public class_8786<? extends SextupleRecipe> getSelected() {
        return this.selected;
    }

    public int runepointCost() {
        return this.runePointCost.method_17407();
    }

    public void method_7623() {
        this.outputSlot.setSyncState(true);
        super.method_7623();
        this.outputSlot.setSyncState(false);
    }

    public void method_34252() {
        this.outputSlot.setSyncState(true);
        super.method_34252();
        this.outputSlot.setSyncState(false);
    }

    public class_1799 method_7601(class_1657 player, int slotID) {
        if (!player.method_5805()) {
            return class_1799.field_8037;
        }
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotID);
        if (slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (slotID == 0) {
                itemstack1.method_7982(player.method_37908(), player, itemstack1.method_7947());
                Platform.INSTANCE.getPlayerData(player).onCrafted(player);
                if (!this.method_7616(itemstack1, 1, 37, false)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (slotID < 37 ? !this.method_7616(itemstack1, 37, this.field_7761.size(), false) : !this.method_7616(itemstack1, 1, 37, false)) {
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
            if (slotID == 0) {
                player.method_7328(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7609(class_1263 container) {
        this.updateCraftingOutput(false);
        super.method_7609(container);
    }

    public ClientRecipeResult getMatchingRecipesClient() {
        return this.matchingRecipesClient;
    }

    public void setMatchingRecipesClient(ClientRecipeResult matchingRecipesClient) {
        this.matchingRecipesClient = matchingRecipesClient;
    }

    public record ClientRecipeResult(long lastChange, List<class_1799> result) {
    }
}

