/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.recipes.SpecialSextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2135;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_8786;

public class CraftingOutputSlot
extends class_1735 {
    private final PlayerBoundCraftingContainer ingredientInv;
    private final ContainerCrafting craftingContainer;
    private final int id;
    private int amountCrafted;
    private boolean prepareForSync;

    public CraftingOutputSlot(class_1263 output, ContainerCrafting container, PlayerBoundCraftingContainer ingredientInv, int id, int x, int y) {
        super(output, id, x, y);
        this.ingredientInv = ingredientInv;
        this.craftingContainer = container;
        this.id = id;
    }

    public void setSyncState(boolean syncing) {
        this.prepareForSync = syncing;
    }

    public class_1799 method_7677() {
        return this.prepareForSync ? this.field_7871.method_5438(this.id + 1) : super.method_7677();
    }

    protected void method_7678(class_1799 stack, int amount) {
        this.amountCrafted += amount;
        this.method_7669(stack);
    }

    protected void method_7672(int amount) {
        super.method_7672(amount);
        this.amountCrafted += amount;
    }

    protected void method_7669(class_1799 stack) {
        class_1657 player = this.ingredientInv.getPlayer();
        if (this.amountCrafted > 0) {
            stack.method_7982(player.method_37908(), player, this.amountCrafted);
            Platform.INSTANCE.craftingEvent(player, stack, this.ingredientInv);
            Platform.INSTANCE.getPlayerData(player).onCrafted(player);
        }
        this.amountCrafted = 0;
    }

    public void method_7667(class_1657 player, class_1799 stack) {
        class_2371 remaining;
        this.method_7669(stack);
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_2371 class_23712 = remaining = this.craftingContainer.getSelected() != null ? ((SextupleRecipe)this.craftingContainer.getSelected().comp_1933()).method_8111(this.ingredientInv) : class_2371.method_10213((int)0, (Object)class_1799.field_8037);
        if (this.craftingContainer.runepointCost() >= 0) {
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            data.useRunePoints(this.craftingContainer.runepointCost(), true);
            class_8786<? extends SextupleRecipe> recipe = this.craftingContainer.getSelected();
            if (recipe != null && !(recipe.comp_1933() instanceof SpecialSextupleRecipe) && !data.getRecipeKeeper().isUnlocked(recipe)) {
                data.getRecipeKeeper().unlockRecipe(player, recipe);
                this.craftingContainer.sendCraftingRecipesToClient(serverPlayer, data);
            }
            switch (this.craftingContainer.craftingType()) {
                case FORGE: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.FORGING, (SextupleRecipe)this.craftingContainer.getSelected().comp_1933());
                    break;
                }
                case ACCESSORY_WORKBENCH: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.CRAFTING, (SextupleRecipe)this.craftingContainer.getSelected().comp_1933());
                    break;
                }
                case CHEMISTRY_SET: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.CHEMISTRY, (SextupleRecipe)this.craftingContainer.getSelected().comp_1933());
                    break;
                }
                case COOKING_TABLE: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.COOKING, (SextupleRecipe)this.craftingContainer.getSelected().comp_1933());
                }
            }
        }
        if (ItemComponentUtils.usedLightOre(stack)) {
            ((class_2135)RuneCraftoryCriteria.LIGHT_ORE.get()).method_9141(serverPlayer);
        }
        switch (this.craftingContainer.craftingType()) {
            case FORGE: {
                ((class_2135)RuneCraftoryCriteria.FORGING.get()).method_9141(serverPlayer);
                break;
            }
            case ACCESSORY_WORKBENCH: {
                ((class_2135)RuneCraftoryCriteria.CRAFTING.get()).method_9141(serverPlayer);
                break;
            }
            case CHEMISTRY_SET: {
                ((class_2135)RuneCraftoryCriteria.MEDICINE.get()).method_9141(serverPlayer);
                break;
            }
            case COOKING_TABLE: {
                ((class_2135)RuneCraftoryCriteria.COOKING.get()).method_9141(serverPlayer);
            }
        }
        boolean refreshRecipe = false;
        for (int i = 0; i < remaining.size(); ++i) {
            class_1799 itemstack = this.ingredientInv.method_5438(i);
            class_1799 remainingStack = (class_1799)remaining.get(i);
            if (!itemstack.method_7960()) {
                this.ingredientInv.method_5434(i, 1);
                itemstack = this.ingredientInv.method_5438(i);
                if (itemstack.method_7960()) {
                    refreshRecipe = true;
                }
            }
            if (remainingStack.method_7960()) continue;
            if (itemstack.method_7960()) {
                this.ingredientInv.method_5447(i, remainingStack);
                continue;
            }
            if (class_1799.method_31577((class_1799)itemstack, (class_1799)remainingStack)) {
                remainingStack.method_7933(itemstack.method_7947());
                this.ingredientInv.method_5447(i, remainingStack);
                continue;
            }
            if (player.method_31548().method_7394(remainingStack)) continue;
            player.method_7328(remainingStack, false);
        }
        if (refreshRecipe) {
            this.craftingContainer.method_7609(this.ingredientInv);
        }
        super.method_7667(player, stack);
    }

    public boolean method_7680(class_1799 stack) {
        return false;
    }

    public class_1799 method_7671(int amount) {
        if (this.method_7681()) {
            this.amountCrafted += Math.min(amount, this.method_7677().method_7947());
        }
        return super.method_7671(amount);
    }

    public boolean method_7674(class_1657 player) {
        if (!GeneralConfig.useRp) {
            return true;
        }
        return player.method_7337() || Platform.INSTANCE.getPlayerData(player).getMaxRunePoints() >= this.craftingContainer.runepointCost();
    }
}

