/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.network.S2CSimpleToast;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.quests.tasks.NPCTalkTask;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.simplequests_api.datapack.QuestsManager;
import io.github.flemmli97.simplequests_api.impls.progression.EntityTracker;
import io.github.flemmli97.simplequests_api.impls.quests.Quest;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.ProgressionTrackerKey;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.QuestState;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestData
implements PlayerQuestData {
    public static final DateTimeFormatter TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final class_3222 player;
    private final List<QuestProgress> currentQuests = new ArrayList<QuestProgress>();
    private final List<QuestProgress> tickables = new ArrayList<QuestProgress>();
    private Map<class_2960, QuestBase> questBoardContent;
    private final Set<class_2960> unlockTracker = new HashSet<class_2960>();
    private LocalDateTime questTrackerTime = LocalDateTime.now();
    private long dailySeed;
    private final Random questRandom = new Random();
    private int finishedQuestDay;
    private final Map<class_2960, Integer> finishedQuestsTracker = new HashMap<class_2960, Integer>();
    private int interactionCooldown;

    public QuestData(class_3222 player) {
        this.player = player;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public List<QuestProgress> getCurrentQuest() {
        return this.currentQuests;
    }

    public long getRandomSeed(@Nullable class_2960 quest) {
        return this.dailySeed;
    }

    public boolean acceptQuest(class_2960 id) {
        QuestBase quest = this.questBoardContent == null ? null : this.questBoardContent.get(id);
        return this.acceptQuest(quest);
    }

    public boolean acceptQuest(QuestBase quest) {
        AcceptType type = this.canAcceptQuest(quest, false);
        if (type != AcceptType.ACCEPT) {
            this.player.method_7353((class_2561)class_2561.method_43471((String)type.langKey()).method_27692(class_124.field_1079), false);
            return false;
        }
        this.currentQuests.add(new QuestProgress(quest, (PlayerQuestData)this, 0));
        EntityUtils.playSoundForPlayer(this.player, (class_3414)RuneCraftorySounds.GENERIC_SUCCESS.get(), 1.0f, 1.2f);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public AcceptType canAcceptQuest(QuestBase quest, boolean ignoreMiss) {
        if (!(ignoreMiss || this.questBoardContent != null && this.questBoardContent.containsKey(quest.id))) {
            return AcceptType.MISSING;
        }
        if (quest instanceof NPCQuest && !RunecraftorySavedData.get((MinecraftServer)this.player.method_5682()).npcHandler.doesNPCExist((npcQuest = (NPCQuest)quest).getNpcUuid())) {
            return AcceptType.NONPC;
        }
        if (!quest.isUnlocked(this.player) || !quest.neededParentQuests.isEmpty() && !this.unlockTracker.containsAll(quest.neededParentQuests)) {
            return AcceptType.REQUIREMENTS;
        }
        if (!(quest instanceof NPCQuest)) ** GOTO lbl-1000
        npcQuest = (NPCQuest)quest;
        if (npcQuest.global) {
            v0 = npcQuest.getOriginID();
        } else lbl-1000:
        // 2 sources

        {
            v0 = id = quest.id;
        }
        if (this.finishedQuestDay > 3 || quest.repeatDelay < 0 && this.getTimesCompleted(id) > 0) {
            return AcceptType.LIMIT;
        }
        return AcceptType.ACCEPT;
    }

    public Map<class_2960, QuestState> submit(@Nullable NPCEntity npc) {
        if (this.currentQuests.isEmpty()) {
            return Map.of();
        }
        HashMap<class_2960, QuestState> completion = new HashMap<class_2960, QuestState>();
        ArrayList<QuestProgress> completed = new ArrayList<QuestProgress>();
        for (QuestProgress prog : this.currentQuests) {
            ArrayList tasks = new ArrayList();
            switch (prog.submit((PlayerQuestData)this, npc == null ? "runecraftory_quest_board_trigger" : npc.method_5667().toString(), tasks::add)) {
                case COMPLETE: {
                    this.completeQuest(prog);
                    completed.add(prog);
                    completion.put(prog.getQuest().id, QuestState.COMPLETE);
                    break;
                }
                case PARTIAL_COMPLETE: {
                    completion.put(prog.getQuest().id, QuestState.PARTIAL_COMPLETE);
                    break;
                }
                case PARTIAL: {
                    EntityUtils.playSoundForPlayer(this.player, (class_3414)RuneCraftorySounds.GENERIC_SUCCESS.get(), this.player.method_5634(), 1.5f, 1.0f);
                    tasks.forEach(t -> LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CSimpleToast((class_2561)prog.getName(this.player).method_27692(class_124.field_1064), (class_2561)t.translation(this.player).method_27692(class_124.field_1065)), this.player));
                    break;
                }
                case NOTHING: {
                    EntityUtils.playSoundForPlayer(this.player, (class_3414)RuneCraftorySounds.GENERIC_DENY.get(), this.player.method_5634(), 1.5f, 1.0f);
                }
            }
        }
        this.currentQuests.removeAll(completed);
        return completion;
    }

    public void addTickableProgress(QuestProgress progress) {
        if (!this.tickables.contains(progress)) {
            this.tickables.add(progress);
        }
    }

    public void removeTickableQuestProgress(QuestProgress progress) {
        this.tickables.remove(progress);
    }

    public int getTimesCompleted(class_2960 quest) {
        return this.finishedQuestsTracker.getOrDefault(quest, 0);
    }

    public <V, T extends ResolvedQuestTask> Map<class_2960, QuestState> trigger(ProgressionTrackerKey<V, T> key, V with) {
        return this.trigger(key, with, "");
    }

    public <V, T extends ResolvedQuestTask> Map<class_2960, QuestState> trigger(ProgressionTrackerKey<V, T> key, V with, @NotNull String trigger) {
        if (key.equals((Object)EntityTracker.KEY)) {
            if (this.interactionCooldown > 0) {
                return Map.of();
            }
            this.interactionCooldown = 2;
        }
        ArrayList completed = new ArrayList();
        HashMap<class_2960, QuestState> completion = new HashMap<class_2960, QuestState>();
        this.currentQuests.forEach(prog -> {
            Set fulfilled = prog.tryFullFill(this.player, key, with);
            QuestState state = prog.tryComplete((PlayerQuestData)this, "");
            if (state == QuestState.NO && !fulfilled.isEmpty()) {
                fulfilled.forEach(p -> {
                    if (!(p.getSecond() instanceof NPCTalkTask.NPCTalkResolved)) {
                        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CSimpleToast((class_2561)prog.getName(this.player).method_27692(class_124.field_1064), (class_2561)((ResolvedQuestTask)p.getSecond()).translation(this.player).method_27692(class_124.field_1065)), this.player);
                    }
                });
            }
            if (state == QuestState.COMPLETE) {
                this.completeQuest((QuestProgress)prog);
                completed.add(prog);
                completion.put(prog.getQuest().id, QuestState.COMPLETE);
            } else if (state == QuestState.PARTIAL_COMPLETE) {
                completion.put(prog.getQuest().id, QuestState.PARTIAL_COMPLETE);
            }
        });
        this.currentQuests.removeAll(completed);
        return completion;
    }

    private void completeQuest(QuestProgress prog) {
        prog.getQuest().onComplete(this.player);
        prog.getCompletionID().forEach(id -> {
            this.unlockTracker.add((class_2960)id);
            this.finishedQuestsTracker.compute((class_2960)id, (key, i) -> {
                int n;
                if (i == null) {
                    n = 1;
                } else {
                    i = i + 1;
                    n = i;
                }
                return n;
            });
        });
        QuestBase questBase = prog.getQuest();
        if (questBase instanceof NPCQuest) {
            NPCQuest npcQuest = (NPCQuest)questBase;
            if (npcQuest.global) {
                this.unlockTracker.add(npcQuest.getOriginID());
                this.finishedQuestsTracker.compute(npcQuest.getOriginID(), (key, i) -> {
                    int n;
                    if (i == null) {
                        n = 1;
                    } else {
                        i = i + 1;
                        n = i;
                    }
                    return n;
                });
            }
        }
        ++this.finishedQuestDay;
        this.player.method_37908().method_43128(null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), class_3417.field_14709, this.player.method_5634(), 1.5f, 1.0f);
        if (!prog.getQuest().neededParentQuests.isEmpty() && prog.getQuest().redoParent) {
            prog.getQuest().neededParentQuests.forEach(res -> {
                Quest quest = QuestsManager.instance().getActualQuest(res, null);
                if (quest != null) {
                    this.unlockTracker.remove(quest.id);
                }
            });
        }
    }

    public void tickTickableQuests() {
        this.tickables.removeIf(prog -> {
            Pair fulfilled = prog.tickProgress((PlayerQuestData)this);
            if (!((Set)fulfilled.getSecond()).isEmpty()) {
                ((Set)fulfilled.getSecond()).forEach(p -> LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CSimpleToast((class_2561)prog.getName(this.player).method_27692(class_124.field_1064), (class_2561)p.translation(this.player).method_27692(class_124.field_1065)), this.player));
            }
            return (Boolean)fulfilled.getFirst();
        });
    }

    public void tick() {
        --this.interactionCooldown;
        this.tickTickableQuests();
        LocalDateTime now = LocalDateTime.now();
        if (this.questTrackerTime == null || this.questTrackerTime.getDayOfYear() != now.getDayOfYear()) {
            this.dailySeed = this.player.method_59922().method_43055();
            this.questTrackerTime = now;
            this.finishedQuestDay = 0;
        }
    }

    public void reset(class_2960 res) {
        if (this.currentQuests.isEmpty()) {
            return;
        }
        QuestProgress prog = null;
        for (QuestProgress p : this.currentQuests) {
            if (!p.getQuest().id.equals((Object)res)) continue;
            prog = p;
            break;
        }
        if (prog == null) {
            return;
        }
        this.currentQuests.remove(prog);
        this.removeTickableQuestProgress(prog);
        prog.getQuest().onReset(this.player);
    }

    public void clone(QuestData other) {
        this.currentQuests.clear();
        this.currentQuests.addAll(other.currentQuests);
        this.tickables.clear();
        this.tickables.addAll(other.tickables);
        this.unlockTracker.clear();
        this.unlockTracker.addAll(other.unlockTracker);
        this.questTrackerTime = other.questTrackerTime;
        this.dailySeed = other.dailySeed;
        this.finishedQuestDay = other.finishedQuestDay;
        this.finishedQuestsTracker.clear();
        this.finishedQuestsTracker.putAll(other.finishedQuestsTracker);
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        class_2499 quests = new class_2499();
        this.currentQuests.forEach(prog -> quests.add((Object)prog.save((class_7225.class_7874)this.player.method_56673())));
        tag.method_10566("ActiveQuests", (class_2520)quests);
        class_2499 unlocked = new class_2499();
        this.unlockTracker.forEach(res -> unlocked.add((Object)class_2519.method_23256((String)res.toString())));
        tag.method_10566("UnlockedQuests", (class_2520)unlocked);
        if (this.questTrackerTime != null) {
            tag.method_10582("TimeTracker", this.questTrackerTime.format(TIME));
        }
        tag.method_10544("DailySeed", this.dailySeed);
        tag.method_10569("DailyDone", this.finishedQuestDay);
        class_2487 total = new class_2487();
        this.finishedQuestsTracker.forEach((res, amount) -> total.method_10569(res.toString(), amount.intValue()));
        tag.method_10566("FinishedQuestTracker", (class_2520)total);
        return tag;
    }

    public void load(class_2487 tag) {
        if (tag.method_10545("ActiveQuests")) {
            class_2499 quests = tag.method_10554("ActiveQuests", 10);
            quests.forEach(q -> {
                try {
                    QuestProgress prog = new QuestProgress((class_2487)q, (PlayerQuestData)this);
                    if (prog.getQuest() != null) {
                        this.currentQuests.add(prog);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        class_2499 unlocked = tag.method_10554("UnlockedQuests", 8);
        unlocked.forEach(t -> this.unlockTracker.add(class_2960.method_60654((String)t.method_10714())));
        if (tag.method_10545("TimeTracker")) {
            this.questTrackerTime = LocalDateTime.parse(tag.method_10558("TimeTracker"), TIME);
        }
        this.dailySeed = tag.method_10537("DailySeed");
        this.finishedQuestDay = tag.method_10550("DailyDone");
        class_2487 total = tag.method_10562("FinishedQuestTracker");
        total.method_10541().forEach(key -> this.finishedQuestsTracker.put(class_2960.method_60654((String)key), total.method_10550(key)));
    }

    public void setQuestboardQuests(Map<class_2960, QuestBase> quest) {
        this.questBoardContent = quest;
    }

    public boolean isActive(class_2960 key) {
        return this.currentQuests.stream().anyMatch(p -> p.getQuest().id.equals((Object)key));
    }

    public void resetAll() {
        this.currentQuests.forEach(p -> p.getQuest().onReset(this.player));
        this.currentQuests.clear();
        this.tickables.clear();
        this.questBoardContent = null;
        this.unlockTracker.clear();
        this.finishedQuestsTracker.clear();
        this.finishedQuestDay = 0;
    }

    public static enum AcceptType {
        MISSING("runecraftory.quests.accept_type.missing"),
        REQUIREMENTS("runecraftory.quests.accept_type.requirements"),
        ACCEPT("runecraftory.quests.accept_type.accept"),
        LIMIT("runecraftory.quests.accept_type.limit"),
        NONPC("runecraftory.quest.npc.none");

        final String lang;

        private AcceptType(String id) {
            this.lang = id;
        }

        public String langKey() {
            return this.lang;
        }
    }
}

