/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_5699;

public class SkillLevelTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<SkillLevelTask> ID = new QuestEntryKey(RuneCraftory.modRes("skill_level"));
    public static final MapCodec<SkillLevelTask> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)class_5699.method_36973((Codec)CodecUtils.stringEnumCodec(Skills.class, null).listOf()).fieldOf("skill").forGetter(d -> d.skills), (App)class_5659.field_45888.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, SkillLevelTask::new));
    private final String description;
    private final List<Skills> skills;
    private final class_5658 range;

    public SkillLevelTask(String description, List<Skills> skills, class_5658 range) {
        this.description = description;
        this.skills = skills;
        this.range = range;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.skills.size() == 1 && this.range instanceof class_44;
    }

    public class_5250 translation(class_3222 player) {
        if (this.description.isEmpty() && this.simple()) {
            Skills skill = this.skills.getFirst();
            return class_2561.method_43469((String)this.getId().toString(), (Object[])new Object[]{skill, this.range.method_366(null)});
        }
        return class_2561.method_43471((String)this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        class_47 ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (class_2960)base.id);
        Skills skills = this.skills.get(ctx.method_294().method_43048(this.skills.size()));
        return new SkillLevelTaskResolved(skills, this.range.method_366(ctx));
    }

    public record SkillLevelTaskResolved(Skills skill, int level) implements ResolvedQuestTask
    {
        public static final MapCodec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtils.stringEnumCodec(Skills.class, null).fieldOf("skill").forGetter(d -> d.skill), (App)class_5699.field_33442.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(class_3222 player) {
            return Platform.INSTANCE.getPlayerData((class_1657)player).getPlayerLevel().getLevel() >= this.level;
        }

        public QuestEntryKey<SkillLevelTask> getId() {
            return ID;
        }

        public class_5250 translation(class_3222 player) {
            return class_2561.method_43469((String)this.getId().toString(), (Object[])new Object[]{this.skill, this.level});
        }
    }
}

