/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public abstract class SextupleRecipe
implements class_1860<PlayerBoundCraftingContainer> {
    private final String group;
    private final class_1799 recipeOutput;
    private final class_2371<class_1856> recipeItems;
    private final int craftingLevel;
    private final int baseCost;

    public SextupleRecipe(String group, int level, int baseCost, class_1799 result, class_2371<class_1856> ingredients) {
        this.group = group;
        this.recipeOutput = result;
        this.recipeItems = ingredients;
        this.craftingLevel = level;
        this.baseCost = baseCost;
    }

    @Nullable
    public static MatchResult calculateMatches(SextupleRecipe recipe, class_2371<class_1799> inv) {
        if (inv.size() > 6) {
            return null;
        }
        for (class_1799 s : inv) {
            if (recipe.areItemsFitting(s)) continue;
            return null;
        }
        class_2371 list = class_2371.method_10211();
        class_2371 bonus = class_2371.method_10211();
        block1: for (class_1856 ingredient : recipe.method_8117()) {
            for (class_1799 stack : inv) {
                if (!ingredient.method_8093(stack) || list.contains((Object)stack)) continue;
                list.add((Object)stack);
                continue block1;
            }
        }
        if (list.size() != recipe.method_8117().size()) {
            return null;
        }
        for (class_1799 stack : inv) {
            if (list.contains((Object)stack)) continue;
            bonus.add((Object)stack);
        }
        if (!recipe.requireExactMatch() && !bonus.isEmpty()) {
            return null;
        }
        return new MatchResult((class_2371<class_1799>)list, (class_2371<class_1799>)bonus);
    }

    @Nullable
    public static RecipeOutput getCraftingOutput(PlayerBoundCraftingContainer inv, class_8786<? extends SextupleRecipe> holder) {
        SextupleRecipe recipe = (SextupleRecipe)holder.comp_1933();
        if (!recipe.matches(inv, inv.getPlayer().method_37908())) {
            return null;
        }
        boolean unlocked = Platform.INSTANCE.getPlayerData(inv.getPlayer()).getRecipeKeeper().isUnlocked(holder);
        if (!unlocked && !GeneralConfig.recipeSystem.allowLocked) {
            return null;
        }
        return recipe.createOutput(inv, unlocked);
    }

    public boolean matches(PlayerBoundCraftingContainer input, class_1937 level) {
        if (input.method_5439() < 6) {
            return false;
        }
        class_2371 stacks = class_2371.method_10211();
        for (int j = 0; j < 6; ++j) {
            class_1799 itemStack = input.method_5438(j);
            if (itemStack.method_7960()) continue;
            stacks.add((Object)itemStack);
        }
        MatchResult result = SextupleRecipe.calculateMatches(this, (class_2371<class_1799>)stacks);
        return result != null;
    }

    public class_1799 assemble(PlayerBoundCraftingContainer input, class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return this.getRecipeOutput();
    }

    public class_2371<class_1856> method_8117() {
        return this.recipeItems;
    }

    public String method_8112() {
        return this.group;
    }

    public boolean method_8118() {
        return true;
    }

    public RecipeOutput createOutput(PlayerBoundCraftingContainer inv, boolean unlocked) {
        class_2371 stacks = class_2371.method_10211();
        for (int j = 0; j < 6; ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (itemStack.method_7960()) continue;
            stacks.add((Object)itemStack);
        }
        MatchResult matches = SextupleRecipe.calculateMatches(this, (class_2371<class_1799>)stacks);
        if (matches == null) {
            return null;
        }
        CraftingType type = CraftingType.FORGE;
        if (this.method_17716() == RuneCraftoryCrafting.ARMOR.get()) {
            type = CraftingType.ACCESSORY_WORKBENCH;
        }
        if (this.method_17716() == RuneCraftoryCrafting.CHEMISTRY.get()) {
            type = CraftingType.CHEMISTRY_SET;
        }
        if (this.method_17716() == RuneCraftoryCrafting.COOKING.get()) {
            type = CraftingType.COOKING_TABLE;
        }
        class_1799 trueOutput = CraftingUtils.getCraftingOutput(this.method_8110((class_7225.class_7874)inv.getPlayer().method_56673()), inv, matches, type);
        return new RecipeOutput(trueOutput, unlocked ? trueOutput : new class_1799((class_1935)RuneCraftoryItems.UNKNOWN.get()), matches.bonusItems());
    }

    protected class_1799 getRecipeOutput() {
        return this.recipeOutput.method_7972();
    }

    public boolean areItemsFitting(class_1799 stack) {
        return true;
    }

    public boolean requireExactMatch() {
        return false;
    }

    public int getCraftingLevel() {
        return this.craftingLevel;
    }

    public int getAdditionalCost() {
        return this.baseCost;
    }

    public String toString() {
        return String.format("Result: %s; Required Level: %d", this.recipeOutput, this.craftingLevel);
    }

    public record MatchResult(class_2371<class_1799> recipeMatches, class_2371<class_1799> bonusItems) {
    }

    public record RecipeOutput(class_1799 serverResult, class_1799 clientResult, class_2371<class_1799> bonusItems) {
    }

    public static class Serializer<T extends SextupleRecipe>
    implements class_1865<T> {
        private final MapCodec<T> codec;
        private final class_9139<class_9129, T> streamCodec;

        public Serializer(Factory<T> factory) {
            this.codec = Serializer.mapCodec(factory);
            this.streamCodec = Serializer.streamCodec(factory);
        }

        protected static <T extends SextupleRecipe> MapCodec<T> mapCodec(Factory<T> factory) {
            return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SextupleRecipe::method_8112), (App)class_5699.field_33442.fieldOf("required_level").forGetter(SextupleRecipe::getCraftingLevel), (App)class_5699.field_33441.fieldOf("crafting_cost").forGetter(SextupleRecipe::getAdditionalCost), (App)class_1799.field_51397.fieldOf("result").forGetter(SextupleRecipe::getRecipeOutput), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(list -> {
                Object[] ingredients = (class_1856[])list.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
                if (ingredients.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
            }, DataResult::success).forGetter(SextupleRecipe::method_8117)).apply((Applicative)instance, factory::get));
        }

        protected static <T extends SextupleRecipe> class_9139<class_9129, T> streamCodec(final Factory<T> factory) {
            return new class_9139<class_9129, T>(){

                public T decode(class_9129 buf) {
                    return factory.get(buf.method_19772(), buf.readInt(), buf.readInt(), (class_1799)class_1799.field_48349.decode((Object)buf), this.fromBuffer(buf));
                }

                private class_2371<class_1856> fromBuffer(class_9129 buf) {
                    List read = buf.method_34066(b -> (class_1856)class_1856.field_48355.decode((Object)buf));
                    class_2371 ingredients = class_2371.method_10213((int)read.size(), (Object)class_1856.field_9017);
                    for (int i = 0; i < read.size(); ++i) {
                        ingredients.set(i, (Object)((class_1856)read.get(i)));
                    }
                    return ingredients;
                }

                public void encode(class_9129 buf, T recipe) {
                    buf.method_10814(((SextupleRecipe)recipe).method_8112());
                    buf.method_53002(((SextupleRecipe)recipe).getCraftingLevel());
                    buf.method_53002(((SextupleRecipe)recipe).getAdditionalCost());
                    class_1799.field_48349.encode((Object)buf, (Object)((SextupleRecipe)recipe).getRecipeOutput());
                    buf.method_34062(((SextupleRecipe)recipe).method_8117(), (b, i) -> class_1856.field_48355.encode((Object)buf, i));
                }
            };
        }

        public MapCodec<T> method_53736() {
            return this.codec;
        }

        public class_9139<class_9129, T> method_56104() {
            return this.streamCodec;
        }

        public static interface Factory<T extends SextupleRecipe> {
            public T get(String var1, int var2, int var3, class_1799 var4, class_2371<class_1856> var5);
        }
    }
}

