/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.entities.misc.FireballEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;

public class FireballSpell
extends Spell {
    public final boolean big;

    public FireballSpell(boolean big) {
        this.big = big;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        FireballEntity ball = new FireballEntity((class_1937)level, entity, this.big);
        ProjectileUtils.shoot(entity, ball, 1.0f, 0.0f);
        ball.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        level.method_8649((class_1297)ball);
        FireballSpell.playSound(entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !Platform.INSTANCE.getPlayerData(player).getWeaponHandler().canExecuteAction(this.useAction());
        }
        return true;
    }

    @Override
    public AttackAction useAction() {
        return this.big ? (AttackAction)RuneCraftoryAttackActions.FIREBALL_BIG_USE.get() : (AttackAction)RuneCraftoryAttackActions.FIREBALL_USE.get();
    }
}

