/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4208;
import org.apache.logging.log4j.Logger;

public class BarnData {
    public final class_4208 pos;
    private int size = 0;
    private int roofHeight;
    private int changeCooldown;
    private final Map<UUID, Integer> monsters = new HashMap<UUID, Integer>();
    private final Set<BaseMonster> listeners = new HashSet<BaseMonster>();
    private boolean removed;

    public BarnData(class_4208 pos) {
        this.pos = pos;
    }

    public static BarnData fromTag(class_2487 tag) {
        DataResult dataResult = class_4208.field_25066.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Pos")));
        BarnData data = new BarnData((class_4208)dataResult.getOrThrow());
        data.load(tag);
        return data;
    }

    public void update(int size, int roofHeight) {
        if (this.size != size || this.roofHeight != roofHeight) {
            this.changeCooldown = 150;
        }
        this.size = size;
        this.roofHeight = roofHeight;
        --this.changeCooldown;
        this.listeners.removeIf(m -> {
            if (m.behaviourState() == BaseMonster.Behaviour.WANDER_HOME && m.method_37908().method_27983() == this.pos.comp_2207()) {
                m.method_18408(this.pos.comp_2208(), this.getSize() + 1);
            }
            return m.method_31481();
        });
    }

    public void addMonster(BaseMonster monster, int size) {
        this.monsters.put(monster.method_5667(), size);
        this.listeners.add(monster);
    }

    public void removeMonster(BaseMonster monster) {
        this.monsters.remove(monster.method_5667());
        this.listeners.remove(monster);
    }

    public boolean hasCapacityFor(BaseMonster monster) {
        int size = monster.getProp().size;
        boolean needsRoof = monster.getProp().needsRoof;
        if (needsRoof && this.roofHeight <= 0) {
            return false;
        }
        if ((float)this.roofHeight <= monster.method_17682() + 1.0f) {
            return false;
        }
        return this.usedCapacity() + size <= this.getCapacity();
    }

    public int getCapacity() {
        if (this.getSize() < 2) {
            return 0;
        }
        if (this.getSize() < 4) {
            return (this.getSize() - 1) * 2;
        }
        return (this.getSize() - 3) * 4 + 2;
    }

    public int usedCapacity() {
        return this.monsters.values().stream().mapToInt(i -> i).sum();
    }

    public boolean hasRoof() {
        return this.roofHeight > 0;
    }

    public int roofHeight() {
        return this.roofHeight;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isInvalid() {
        return this.removed || this.size < 2;
    }

    public boolean isInvalidFor(BaseMonster monster) {
        if (this.isInvalid()) {
            return true;
        }
        if (this.monsters.containsKey(monster.method_5667()) && this.changeCooldown > 0) {
            return false;
        }
        if (this.roofHeight > 0) {
            return (float)this.roofHeight < monster.method_17682() + 1.0f;
        }
        return !monster.getProp().needsRoof;
    }

    public void remove() {
        this.removed = true;
    }

    public void load(class_2487 tag) {
        this.size = tag.method_10550("Size");
        this.roofHeight = tag.method_10550("RoofHeight");
        this.changeCooldown = tag.method_10550("ChangeCooldown");
        class_2487 monsters = tag.method_10562("Monsters");
        monsters.method_10541().forEach(key -> this.monsters.put(UUID.fromString(key), monsters.method_10550(key)));
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.pos).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> tag.method_10566("Pos", t));
        tag.method_10569("Size", this.size);
        tag.method_10569("RoofHeight", this.roofHeight);
        tag.method_10569("ChangeCooldown", this.changeCooldown);
        class_2487 monsters = new class_2487();
        this.monsters.forEach((uuid, integer) -> monsters.method_10569(uuid.toString(), integer.intValue()));
        tag.method_10566("Monsters", (class_2520)monsters);
        return tag;
    }

    public String toString() {
        return String.format("Barn[%s]; Size: %d, With Roof: %s, Capacity: %d, FreeCapacity: %d", this.pos, this.size, this.roofHeight, this.getCapacity(), this.getCapacity() - this.monsters.values().stream().mapToInt(i -> i).sum());
    }
}

