/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

public final class CraftingIdentifier
extends Record {
    private final RecipeType<class_8786<SextupleRecipe>> identifier;
    private final CraftingType craftingType;
    private final Supplier<class_3956<SextupleRecipe>> recipeType;
    private static final Map<CraftingType, CraftingIdentifier> IDENTIFIERS = new HashMap<CraftingType, CraftingIdentifier>();
    public static final CraftingIdentifier FORGING = new CraftingIdentifier(CraftingType.FORGE);
    public static final CraftingIdentifier CHEMISTRY = new CraftingIdentifier(CraftingType.CHEMISTRY_SET);
    public static final CraftingIdentifier COOKING = new CraftingIdentifier(CraftingType.COOKING_TABLE);
    public static final CraftingIdentifier ARMOR = new CraftingIdentifier(CraftingType.ACCESSORY_WORKBENCH);

    private CraftingIdentifier(CraftingType craftingType) {
        RecipeType recipeType = CraftingIdentifier.createHolder("runecraftory", craftingType.getId() + "_category");
        this((RecipeType<class_8786<SextupleRecipe>>)recipeType, craftingType, (Supplier<class_3956<SextupleRecipe>>)(switch (craftingType) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> RuneCraftoryCrafting.FORGE;
            case CraftingType.ACCESSORY_WORKBENCH -> RuneCraftoryCrafting.ARMOR;
            case CraftingType.CHEMISTRY_SET -> RuneCraftoryCrafting.CHEMISTRY;
            case CraftingType.COOKING_TABLE -> RuneCraftoryCrafting.COOKING;
        }));
        IDENTIFIERS.put(craftingType, this);
    }

    public CraftingIdentifier(RecipeType<class_8786<SextupleRecipe>> identifier, CraftingType craftingType, Supplier<class_3956<SextupleRecipe>> recipeType) {
        this.identifier = identifier;
        this.craftingType = craftingType;
        this.recipeType = recipeType;
    }

    public static CraftingIdentifier get(CraftingType craftingType) {
        return IDENTIFIERS.get((Object)craftingType);
    }

    public static boolean has(RecipeType<?> recipeType) {
        return IDENTIFIERS.values().stream().anyMatch(id -> id.identifier().equals((Object)recipeType));
    }

    private static <R extends class_1860<?>> RecipeType<class_8786<R>> createHolder(String nameSpace, String path) {
        class_2960 id = class_2960.method_60655((String)nameSpace, (String)path);
        Class<class_8786> holderClass = class_8786.class;
        return new RecipeType(id, holderClass);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this, o);
    }

    public RecipeType<class_8786<SextupleRecipe>> identifier() {
        return this.identifier;
    }

    public CraftingType craftingType() {
        return this.craftingType;
    }

    public Supplier<class_3956<SextupleRecipe>> recipeType() {
        return this.recipeType;
    }
}

