/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.integration.rei.SextupleDisplay;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public final class CraftingIdentifier
extends Record {
    private final CategoryIdentifier<SextupleDisplay> identifier;
    private final CraftingType craftingType;
    private final Supplier<class_3956<SextupleRecipe>> recipeType;
    private static final Map<CraftingType, CraftingIdentifier> IDENTIFIERS = new HashMap<CraftingType, CraftingIdentifier>();
    public static final CraftingIdentifier FORGING = new CraftingIdentifier(CraftingType.FORGE);
    public static final CraftingIdentifier CHEMISTRY = new CraftingIdentifier(CraftingType.CHEMISTRY_SET);
    public static final CraftingIdentifier COOKING = new CraftingIdentifier(CraftingType.COOKING_TABLE);
    public static final CraftingIdentifier ARMOR = new CraftingIdentifier(CraftingType.ACCESSORY_WORKBENCH);

    private CraftingIdentifier(CraftingType craftingType) {
        CategoryIdentifier categoryIdentifier = CategoryIdentifier.of((class_2960)RuneCraftory.modRes(craftingType.getId() + "_category"));
        this((CategoryIdentifier<SextupleDisplay>)categoryIdentifier, craftingType, (Supplier<class_3956<SextupleRecipe>>)(switch (craftingType) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> RuneCraftoryCrafting.FORGE;
            case CraftingType.ACCESSORY_WORKBENCH -> RuneCraftoryCrafting.ARMOR;
            case CraftingType.CHEMISTRY_SET -> RuneCraftoryCrafting.CHEMISTRY;
            case CraftingType.COOKING_TABLE -> RuneCraftoryCrafting.COOKING;
        }));
        IDENTIFIERS.put(craftingType, this);
    }

    public CraftingIdentifier(CategoryIdentifier<SextupleDisplay> identifier, CraftingType craftingType, Supplier<class_3956<SextupleRecipe>> recipeType) {
        this.identifier = identifier;
        this.craftingType = craftingType;
        this.recipeType = recipeType;
    }

    public static CraftingIdentifier get(CraftingType craftingType) {
        return IDENTIFIERS.get((Object)craftingType);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CraftingIdentifier.class, "identifier;craftingType;recipeType", "identifier", "craftingType", "recipeType"}, this, o);
    }

    public CategoryIdentifier<SextupleDisplay> identifier() {
        return this.identifier;
    }

    public CraftingType craftingType() {
        return this.craftingType;
    }

    public Supplier<class_3956<SextupleRecipe>> recipeType() {
        return this.recipeType;
    }
}

