/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class LevelSetBlockSnapshot {
    private final Map<class_2338, BlockSnapshot> snapshots = new HashMap<class_2338, BlockSnapshot>();
    private final Map<class_2338, class_2586> blockEntities = new HashMap<class_2338, class_2586>();
    private final class_1937 level;
    private boolean takeSnapshot = false;
    private Predicate<class_2680> condition;

    public LevelSetBlockSnapshot(class_1937 level) {
        this.level = level;
    }

    public void takeSnapshot(@Nullable Predicate<class_2680> condition) {
        this.takeSnapshot = true;
        this.condition = condition;
    }

    public boolean isTakingSnapshot() {
        return this.takeSnapshot;
    }

    public void appendBlockSnapshot(BlockSnapshot blockSnapshot) {
        class_2343 entityBlock;
        class_2586 entity;
        class_2248 class_22482;
        BlockSnapshot current;
        if (this.condition == null || this.condition.test((current = this.snapshots.get(blockSnapshot.pos())) != null ? current.state : this.level.method_8320(blockSnapshot.pos))) {
            this.snapshots.put(blockSnapshot.pos(), blockSnapshot);
        }
        if ((class_22482 = blockSnapshot.state().method_26204()) instanceof class_2343 && (entity = (entityBlock = (class_2343)class_22482).method_10123(blockSnapshot.pos(), blockSnapshot.state())) != null) {
            class_2586 currentEntity = this.blockEntities.get(blockSnapshot.pos());
            if (currentEntity != null) {
                currentEntity.method_11012();
            }
            entity.method_31662(this.level);
            this.blockEntities.put(blockSnapshot.pos(), entity);
        }
    }

    @Nullable
    public class_2680 getBlockState(class_2338 pos) {
        BlockSnapshot snapshot = this.snapshots.get(pos);
        if (snapshot != null) {
            return snapshot.state();
        }
        return null;
    }

    @Nullable
    public class_2586 getBlockEntity(class_2338 pos) {
        return this.blockEntities.get(pos);
    }

    public void popSnapshots(boolean place) {
        this.takeSnapshot = false;
        if (place) {
            this.snapshots.forEach((pos, snapshot) -> this.level.method_8652(snapshot.pos, snapshot.state, snapshot.updateFlag));
            this.blockEntities.forEach((pos, entity) -> {
                class_2487 tag = entity.method_38244((class_7225.class_7874)this.level.method_30349());
                this.level.method_8321(pos).method_58690(tag, (class_7225.class_7874)this.level.method_30349());
            });
        }
        this.snapshots.clear();
        this.blockEntities.clear();
    }

    public record BlockSnapshot(class_2680 state, class_2338 pos, int updateFlag) {
    }
}

