/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.calendar;

public enum DayOfWeek {
    MONDAY("runecraftory.day.monday"),
    TUESDAY("runecraftory.day.tuesday"),
    WEDNESDAY("runecraftory.day.wednesday"),
    THURSDAY("runecraftory.day.thursday"),
    FRIDAY("runecraftory.day.friday"),
    SATURDAY("runecraftory.day.saturday"),
    SUNDAY("runecraftory.day.sunday");

    private final String translation;
    private final String translationFull;

    private DayOfWeek(String id) {
        this.translation = id;
        this.translationFull = id + ".full";
    }

    public static DayOfWeek nextDay(DayOfWeek day) {
        return switch (day.ordinal()) {
            case 4 -> SATURDAY;
            case 0 -> TUESDAY;
            case 5 -> SUNDAY;
            case 3 -> FRIDAY;
            case 1 -> WEDNESDAY;
            case 2 -> THURSDAY;
            default -> MONDAY;
        };
    }

    public String translation() {
        return this.translation;
    }

    public String translationFull() {
        return this.translationFull;
    }
}

