/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.client.gui.widgets.DialogueOptionButton;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.PlaceHolderComponent;
import io.github.flemmli97.runecraftory.common.network.C2SDialogueAction;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class NPCDialogueGui<T extends NPCEntity>
extends Screen {
    private static final ResourceLocation TEXTURE = RuneCraftory.modRes("hud/npc_dialogue");
    public static final int MAX_WIDTH = 200;
    public static final int MAX_HEIGHT = 73;
    public static final int BORDER_SIZE = 7;
    public static final int LINE_WIDTH = 186;
    public static final int LINES_PER_PAGE = 5;
    protected int leftPos;
    protected int topPos;
    private int pageIndex;
    private int lineProgress;
    private int textProgress;
    protected final T entity;
    private ConversationContext convCtx;
    private String conversationID;
    private List<ConversationLine> conversation;
    private Map<String, Component> replacements = Map.of();
    private List<Component> actions;
    private final List<DialogueOptionButton> buttons = new ArrayList<DialogueOptionButton>();
    private boolean reset;
    private boolean calculateButtonVisiblity;
    private boolean removed;

    public NPCDialogueGui(T entity) {
        super(entity.getDisplayName());
        this.entity = entity;
    }

    protected void init() {
        super.init();
        this.leftPos = this.width / 2 - 100;
        this.topPos = this.height / 2 + 30;
        this.buttons();
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        if (this.removed) {
            this.onClose();
            return;
        }
        if (this.reset) {
            this.buttons();
            this.reset = false;
        }
        if (this.calculateButtonVisiblity) {
            if (this.buttonsVisible()) {
                this.showAllButtons();
            }
            this.calculateButtonVisiblity = false;
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 0.85f);
        graphics.blitSprite(TEXTURE, this.leftPos, this.topPos, 200, 73);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int lines = Math.min(this.conversation.size(), (this.pageIndex + 1) * 5);
        for (int i = this.pageIndex * 5; i < lines; ++i) {
            if (i > this.lineProgress) continue;
            ConversationLine txt = this.conversation.get(i);
            FormattedCharSequence txtRender = this.lineProgress == i ? Language.getInstance().getVisualOrder(this.font.substrByWidth(txt.raw(), this.textProgress)) : txt.txt();
            graphics.drawString(this.font, txtRender, this.leftPos + 7, this.topPos + 7 + 13 * (i % 5), 0xFFFFFF, false);
        }
    }

    protected void buttons() {
        this.buttons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.buttons.clear();
        boolean visible = this.buttonsVisible();
        int y = 0;
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            int actionIdx = i;
            DialogueOptionButton btn = new DialogueOptionButton(this.width / 2, this.topPos - 20 + y, this.font, PlaceHolderComponent.parseDialogueComponent(this.actions.get(i), this.replacements), b -> {
                if (this.convCtx != null && this.conversationID != null) {
                    LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SDialogueAction(this.entity.getId(), this.convCtx, this.conversationID, actionIdx));
                }
            });
            btn.visible = visible;
            this.buttons.add(btn);
            this.addRenderableWidget((GuiEventListener)btn);
            y -= btn.getHeight() + 8;
        }
    }

    public void tick() {
        super.tick();
        int max = this.maxCurrentLineIndex();
        if (this.lineProgress <= max) {
            this.textProgress += 4;
            ConversationLine txt = this.conversation.get(this.lineProgress);
            if (this.textProgress > txt.width()) {
                ++this.lineProgress;
                if (this.lineProgress > this.conversation.size() - 1) {
                    this.showAllButtons();
                }
                this.textProgress = 0;
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int id = this.maxCurrentLineIndex();
        if (this.lineProgress < id || this.lineProgress / 5 == this.pageIndex && this.lineProgress < this.conversation.size() && this.textProgress < this.conversation.get(this.lineProgress).width()) {
            this.lineProgress = id + 1;
            this.calculateButtonVisiblity = true;
        } else if (this.pageIndex + 1 <= (this.conversation.size() - 1) / 5) {
            ++this.pageIndex;
            this.textProgress = 0;
            this.calculateButtonVisiblity = true;
        } else if (this.buttons.isEmpty()) {
            this.removed = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void showAllButtons() {
        this.buttons.forEach(b -> {
            b.visible = true;
        });
    }

    private int maxCurrentLineIndex() {
        return Math.min(4 + this.pageIndex * 5, this.conversation.size() - 1);
    }

    private boolean buttonsVisible() {
        return this.lineProgress >= this.conversation.size() - 1;
    }

    public void removed() {
        super.removed();
        Minecraft.getInstance().options.keyUse.consumeClick();
        Minecraft.getInstance().options.keyUse.setDown(false);
        LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), this.convCtx == null ? C2SNPCInteraction.Action.CLOSE_QUEST : C2SNPCInteraction.Action.CLOSE, this.conversationID));
        if (this.convCtx == ConversationContext.GREETING) {
            LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SNPCInteraction(this.entity.getId(), C2SNPCInteraction.Action.TALK));
        }
    }

    public void updateConversation(Minecraft mc, ConversationContext convCtx, String conversationID, Component conversation, Map<String, Component> data, List<Component> actions) {
        conversation = PlaceHolderComponent.parseDialogueComponent(conversation, data);
        this.conversation = mc.font.getSplitter().splitLines((FormattedText)conversation, 186, conversation.getStyle()).stream().map(txt -> new ConversationLine(mc.font.width(txt), (FormattedText)txt, Language.getInstance().getVisualOrder(txt))).toList();
        this.actions = actions;
        this.convCtx = convCtx;
        this.conversationID = conversationID;
        this.replacements = data;
        this.lineProgress = 0;
        this.textProgress = 0;
        this.pageIndex = 0;
        this.reset = true;
    }

    record ConversationLine(int width, FormattedText raw, FormattedCharSequence txt) {
    }
}

