/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.Beetle;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BeetleModel<T extends Beetle>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ResourceLocation LOCATION = RuneCraftory.modRes("entity/beetle");
    private final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.head = model.getPart("head");
        this.ridingPosition = model.getPart("ridingPos");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended ridingPosition;

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.getModel().resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.5f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.5f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((Beetle)entity).deathTime <= 0 && !((BaseMonster)entity).playDeath()) {
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "idle", ((Beetle)entity).tickCount, partialTicks);
            if (!entity.onGround()) {
                ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "fly", ((Beetle)entity).tickCount, partialTicks);
            } else {
                ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "walk", ((Beetle)entity).tickCount, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            }
        }
        ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, ((Beetle)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        this.ridingPosition.translateAndRotateWithParents(poseStack);
        ClientHandlers.translateRider(poseStack, entity, rider);
        return true;
    }
}

