/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.client.model.monster.SkelefangModel;
import io.github.flemmli97.runecraftory.client.render.monster.SkelefangRender;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Skelefang;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class SkelefangParticle
extends Particle {
    private static final SkelefangModel<Skelefang> MODEL = SkelefangParticle.particleModel();
    private static final RenderType RENDER_TYPE = MODEL.renderType(SkelefangRender.TEXTURE);
    private final SkelefangParticleData.SkelefangBoneType boneType;
    private final float initialRotX;
    private final float initialRotY;
    private final float pitchSpin;
    private final float yawSpin;
    private int groundTick;

    public SkelefangParticle(ClientLevel level, double x, double y, double z, double dirX, double dirY, double dirZ, SkelefangParticleData data) {
        super(level, x, y, z);
        ModelPartsContainer.ModelPartExtended[] parts;
        this.setParticleSpeed(dirX, dirY, dirZ);
        if (data.hasGravity()) {
            this.gravity = 1.0f;
        }
        this.speedUpWhenYMotionIsBlocked = false;
        this.boneType = data.getBoneType();
        this.initialRotX = data.getInitialRotX();
        this.initialRotY = data.getInitialRotY();
        this.pitchSpin = data.getPitchSpin();
        this.yawSpin = data.getYawSpin();
        this.lifetime = data.getMaxTime();
        switch (this.boneType) {
            case TAIL: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[4];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineBack;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.tailBase;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[3] = SkelefangParticle.MODEL.tail;
                break;
            }
            case TAIL_BASE: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineBack;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.tailBase;
                break;
            }
            case LEFT_LEG: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineBack;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.leftLegBase;
                break;
            }
            case RIGHT_LEG: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineBack;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.rightLegBase;
                break;
            }
            case HEAD: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[4];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineFront;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.neck;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[3] = SkelefangParticle.MODEL.head;
                break;
            }
            case NECK: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineFront;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.neck;
                break;
            }
            case BACK: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[2];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineBack;
                break;
            }
            case BACK_RIBS: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineBack;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.ribsSpine;
                break;
            }
            case FRONT: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[2];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineFront;
                break;
            }
            case FRONT_RIBS: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray = new ModelPartsContainer.ModelPartExtended[3];
                modelPartExtendedArray[0] = SkelefangParticle.MODEL.body;
                modelPartExtendedArray[1] = SkelefangParticle.MODEL.spineFront;
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = modelPartExtendedArray;
                modelPartExtendedArray[2] = SkelefangParticle.MODEL.ribsBody;
                break;
            }
            default: {
                ModelPartsContainer.ModelPartExtended[] modelPartExtendedArray2 = parts = null;
            }
        }
        if (parts != null) {
            double mX = 0.0;
            double mY = 0.0;
            double mZ = 0.0;
            for (ModelPartsContainer.ModelPartExtended part : parts) {
                mX += (double)part.x;
                mY += (double)part.y;
                mZ += (double)part.z;
            }
            Vec3 offset = new Vec3(mX, mY - 22.75, mZ).yRot(Mth.wrapDegrees((float)this.initialRotY) * ((float)Math.PI / 180));
            this.setPos(this.x + offset.x() * 1.0 / 16.0, this.y - offset.y() * 1.0 / 16.0, this.z - offset.z() * 1.0 / 16.0);
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
        }
    }

    public static SkelefangModel<Skelefang> particleModel() {
        SkelefangModel<Skelefang> model = new SkelefangModel<Skelefang>(RenderType::entityTranslucentCull);
        model.getModel().getRoot().loadPoseRecursive(PoseExtended.ZERO);
        return model;
    }

    public void tick() {
        super.tick();
        if (this.onGround && this.groundTick == 0) {
            this.groundTick = this.age;
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        int spinAge;
        int next;
        Vec3 vec3 = renderInfo.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        PoseStack stack = new PoseStack();
        stack.translate(x, y, z);
        if (this.groundTick > 0 && this.age > this.groundTick) {
            next = this.groundTick;
            spinAge = this.groundTick;
        } else {
            next = this.age + 1;
            spinAge = this.age;
        }
        float yaw = Mth.lerp((float)partialTicks, (float)(this.initialRotY + this.yawSpin * (float)spinAge), (float)(this.initialRotY + this.yawSpin * (float)next));
        float pitch = Mth.lerp((float)partialTicks, (float)(this.initialRotX + this.pitchSpin * (float)spinAge), (float)(this.initialRotX + this.pitchSpin * (float)next));
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        stack.mulPose(Axis.XP.rotationDegrees(pitch));
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0, -1.5, 0.0);
        float alpha = 0.9f - (float)this.age * 7.0f / (float)this.lifetime;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        int block = this.level.getBrightness(LightLayer.BLOCK, pos);
        int light = this.level.getBrightness(LightLayer.SKY, pos);
        VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RENDER_TYPE);
        MODEL.renderAsParticle(stack, consumer, this.boneType, LightTexture.pack((int)block, (int)light), OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)((int)(alpha * 255.0f)), (int)-1));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public record SkelefangParticleFactoryBase(SpriteSet sprite) implements ParticleProvider<SkelefangParticleData>
    {
        public Particle createParticle(SkelefangParticleData data, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new SkelefangParticle(level, x, y, z, motionX, motionY, motionZ, data);
        }
    }
}

