/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.render.AnimatedTexture;
import io.github.flemmli97.runecraftory.common.entities.misc.ElementalBallEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ElementBallRender
extends EntityRenderer<ElementalBallEntity> {
    private static final ResourceLocation FIRE = RuneCraftory.modRes("textures/entity/projectile/fireball_n.png");
    private static final ResourceLocation WATER = RuneCraftory.modRes("textures/entity/projectile/bubble.png");
    private static final ResourceLocation WATER_2 = RuneCraftory.modRes("textures/entity/projectile/ice_ball.png");
    private static final ResourceLocation EARTH = RuneCraftory.modRes("textures/entity/projectile/earth_ball.png");
    private static final ResourceLocation LOVE = RuneCraftory.modRes("textures/entity/projectile/love_ball.png");
    private static final ResourceLocation WIND = RuneCraftory.modRes("textures/entity/projectile/wind_blade.png");
    private static final ResourceLocation BLOB = RuneCraftory.modRes("textures/particle/light.png");
    public final float xSize = 1.0f;
    public final float ySize = 1.0f;
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();
    protected final AnimatedTexture fireTexAnim = new AnimatedTexture(6, 1);
    protected final AnimatedTexture windTexAnim = new AnimatedTexture(8, 1);

    public ElementBallRender(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(ElementalBallEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        AnimatedTexture text = null;
        switch (entity.getElement()) {
            case FIRE: {
                text = this.fireTexAnim;
                break;
            }
            case WIND: {
                text = this.windTexAnim;
                break;
            }
            case DARK: {
                this.textureBuilder.setColor(-10676317);
                break;
            }
            case LIGHT: {
                this.textureBuilder.setColor(-723064);
            }
        }
        if (text != null) {
            float[] uvOffset = text.uvOffset((int)((double)(entity.tickCount + entity.getId()) * 0.5));
            this.textureBuilder.setUV(uvOffset[0], uvOffset[1]);
            this.textureBuilder.setUVLength(text.uLength, text.vLength);
        } else {
            this.textureBuilder.setUV(0.0f, 0.0f);
            this.textureBuilder.setUVLength(1.0f, 1.0f);
        }
        this.textureBuilder.setLight(packedLight);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.getRenderType(entity, this.getTextureLocation(entity)));
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)vertexConsumer, (float)1.0f, (float)1.0f, (RenderUtils.TextureBuilder)this.textureBuilder);
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ElementalBallEntity entity) {
        return switch (entity.getElement()) {
            case ItemElement.WATER -> {
                if (entity.getVariant() == 1) {
                    yield WATER_2;
                }
                yield WATER;
            }
            case ItemElement.LOVE -> LOVE;
            case ItemElement.EARTH -> EARTH;
            case ItemElement.WIND -> WIND;
            case ItemElement.DARK, ItemElement.LIGHT -> BLOB;
            default -> FIRE;
        };
    }

    protected RenderType getRenderType(ElementalBallEntity entity, ResourceLocation loc) {
        if (entity.getElement() == ItemElement.DARK || entity.getElement() == ItemElement.LIGHT) {
            return RenderType.entityTranslucent((ResourceLocation)loc);
        }
        return RenderType.entityCutoutNoCull((ResourceLocation)loc);
    }
}

