/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.SmallRaccoonLeafEntity;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.client.render.TextureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SmallRaccoonLeafRender
extends TextureRenderer<SmallRaccoonLeafEntity> {
    private static final ResourceLocation TEX = RuneCraftory.modRes("textures/entity/projectile/leaf.png");

    public SmallRaccoonLeafRender(EntityRendererProvider.Context ctx) {
        super(ctx, 0.4f, 0.4f, 1, 1);
    }

    public void render(SmallRaccoonLeafEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.translate(0.0, (double)this.ySize * 0.25, 0.0);
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.popPose();
    }

    public void doRender(SmallRaccoonLeafEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        stack.pushPose();
        stack.mulPose(Axis.XP.rotationDegrees(-20.0f));
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(this.getRenderType((Entity)entity, this.getTextureLocation(entity))), (float)this.xSize, (float)this.ySize, (RenderUtils.TextureBuilder)this.textureBuilder);
        stack.mulPose(Axis.XP.rotationDegrees(40.0f));
        RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(this.getRenderType((Entity)entity, this.getTextureLocation(entity))), (float)this.xSize, (float)this.ySize, (RenderUtils.TextureBuilder)this.textureBuilder);
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(SmallRaccoonLeafEntity entity) {
        return TEX;
    }

    public boolean facePlayer() {
        return false;
    }

    public float yawOffset() {
        return -90.0f;
    }
}

