/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attachment.player;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.api.datapack.SkillProperties;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.advancements.LevelTrigger;
import io.github.flemmli97.runecraftory.common.advancements.MoneyTrigger;
import io.github.flemmli97.runecraftory.common.advancements.SkillLevelTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.DailyPlayerUpdater;
import io.github.flemmli97.runecraftory.common.attachment.player.EntitySelector;
import io.github.flemmli97.runecraftory.common.attachment.player.EntityStatsTracker;
import io.github.flemmli97.runecraftory.common.attachment.player.Party;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.RecipeKeeper;
import io.github.flemmli97.runecraftory.common.attachment.player.WalkingTracker;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShippingBin;
import io.github.flemmli97.runecraftory.common.inventory.InventorySpells;
import io.github.flemmli97.runecraftory.common.items.tools.ItemStatIncrease;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.network.S2CFoodPkt;
import io.github.flemmli97.runecraftory.common.network.S2CLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CMoney;
import io.github.flemmli97.runecraftory.common.network.S2CRunePoints;
import io.github.flemmli97.runecraftory.common.network.S2CSkillLevelPkt;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.utils.DamageSourceUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerData {
    private final Player player;
    private boolean starting;
    private double runePoints;
    private final XpLevelHolder level = new XpLevelHolder();
    private final EnumMap<Skills, XpLevelHolder> skillLevels = new EnumMap(Skills.class);
    private int money = GeneralConfig.startingMoney;
    private final RecipeKeeper keeper = new RecipeKeeper();
    private final InventoryShippingBin shippingBin = new InventoryShippingBin();
    private final Map<Item, ShippedItemData> shippedItems = new HashMap<Item, ShippedItemData>();
    private final Map<NPCProfession, NonNullList<ItemStack>> shopItems = new HashMap<NPCProfession, NonNullList<ItemStack>>();
    private final InventorySpells spells = new InventorySpells();
    private final DailyPlayerUpdater updater = new DailyPlayerUpdater(this);
    private Holder<Item> lastEaten;
    private int foodDuration;
    private final WalkingTracker walkingTracker = new WalkingTracker();
    public final EntityStatsTracker entityStatsTracker = new EntityStatsTracker();
    public final Party party = new Party();
    private int craftingSeed;
    private int boughtBarns;
    private int mobLevelIncrease;
    private final PlayerWeaponHandler weaponHandler;
    public final EntitySelector entitySelector = new EntitySelector();
    private BlockPos blockBreakPosForMsg;
    private int breakTick;
    private int rpStillRegen;

    public PlayerData(Player player) {
        this.player = player;
        for (Skills skill : Skills.values()) {
            this.skillLevels.put(skill, new XpLevelHolder());
        }
        this.weaponHandler = new PlayerWeaponHandler(player);
    }

    public Player player() {
        return this.player;
    }

    public void onJoin() {
        this.recalculateStats(false);
        this.updateConfigAttributes();
        if (!this.starting) {
            this.starting = true;
            this.player.setHealth(this.player.getMaxHealth());
            this.setRunePoints((int)this.player.getAttributeValue(RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder()));
        }
    }

    private void setForVitality(ResourceLocation modifier, double value, AttributeUpdate update) {
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.DEFENCE.asHolder(), modifier, value * 0.5, update);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder(), modifier, value * 0.5, update);
    }

    private void setFoodBonus(Pair<Map<Holder<Attribute>, Double>, Map<Holder<Attribute>, Double>> bonus) {
        ((Map)bonus.getFirst()).forEach((att, val) -> this.setAttributeValue((Holder<Attribute>)att, LibConstants.FOOD_MODIFIER, (double)val, AttributeUpdate.REPLACE));
        ((Map)bonus.getSecond()).forEach((att, val) -> {
            AttributeInstance instance = this.player.getAttribute(att);
            AttributeUpdate.REPLACE.modify(instance, LibConstants.FOOD_MODIFIER_MULTI, (double)val, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        });
    }

    private void setAttributeValue(Holder<Attribute> attribute, ResourceLocation modifier, double value, AttributeUpdate update) {
        AttributeInstance instance = this.player.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        update.modify(instance, modifier, value);
    }

    private void updateConfigAttributes() {
        this.setAttributeValue((Holder<Attribute>)Attributes.MAX_HEALTH, LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingHealth, AttributeUpdate.ABSOLUTE);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingRp, AttributeUpdate.ABSOLUTE);
        this.setAttributeValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE, LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingStr, AttributeUpdate.ABSOLUTE);
        this.setForVitality(LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingVit, AttributeUpdate.ABSOLUTE);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_CONFIG_MODIFIER, GeneralConfig.startingIntel, AttributeUpdate.ABSOLUTE);
    }

    private void updateLevelAttributes() {
        int lvl = this.level.getLevel() - 1;
        this.setAttributeValue((Holder<Attribute>)Attributes.MAX_HEALTH, LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.hpPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.rpPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setAttributeValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE, LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.strPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setForVitality(LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.vitPerLevel * (float)lvl, AttributeUpdate.REPLACE);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_LEVEL_MODIFIER, GeneralConfig.intPerLevel * (float)lvl, AttributeUpdate.REPLACE);
    }

    private void updateSkillLevelAttributes() {
        this.setAttributeValue((Holder<Attribute>)Attributes.MAX_HEALTH, LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::healthIncrease), AttributeUpdate.REPLACE);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder(), LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::rpIncrease), AttributeUpdate.REPLACE);
        this.setAttributeValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE, LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::strIncrease), AttributeUpdate.REPLACE);
        this.setForVitality(LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::vitIncrease), AttributeUpdate.REPLACE);
        this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_SKILL_LEVEL_MODIFIER, this.skillVal(SkillProperties::intelIncrease), AttributeUpdate.REPLACE);
    }

    private void clearAtributeModifier(Holder<Attribute> attribute, ResourceLocation modifier) {
        AttributeInstance instance = this.player.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        instance.removeModifier(modifier);
    }

    private void clearAllAtributeModifier(ResourceLocation modifier) {
        ((AttributeMapAccessor)this.player.getAttributes()).getAttributes().forEach((att, inst) -> inst.removeModifier(modifier));
    }

    public int getRunePoints() {
        return (int)this.runePoints;
    }

    public int getMaxRunePoints() {
        return (int)this.player.getAttributeValue(RuneCraftoryAttributes.MAX_RUNEPOINTS.asHolder());
    }

    public boolean useRunePoints(int amount, boolean damage) {
        if (!GeneralConfig.useRp && !this.player.level().isClientSide) {
            return true;
        }
        if (!this.player.isCreative()) {
            if (this.player.hasEffect(RuneCraftoryEffects.FATIGUE.asHolder())) {
                amount *= 2;
            }
            if (this.runePoints >= (double)amount) {
                this.runePoints -= (double)amount;
            } else if (damage) {
                int diff = amount - this.getRunePoints();
                this.runePoints = 0.0;
                if (!this.player.level().isClientSide) {
                    int invul = this.player.invulnerableTime;
                    this.player.invulnerableTime = 10;
                    boolean res = this.player.hurt(DamageSourceUtils.exhaust(this.player.level()), Math.min(this.player.getMaxHealth() * 0.25f, (float)(diff * 2)));
                    this.player.invulnerableTime = res ? 10 : invul;
                }
            } else {
                return false;
            }
            this.rpStillRegen = 200;
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CRunePoints(this), serverPlayer);
            }
            return true;
        }
        return true;
    }

    public void regenRunePoints(int amount) {
        if (amount <= 0) {
            return;
        }
        this.runePoints = Mth.clamp((double)(this.runePoints + (double)amount), (double)0.0, (double)this.getMaxRunePoints());
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CRunePoints(this), serverPlayer);
        }
    }

    public void setRunePoints(int amount) {
        this.runePoints = amount;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CRunePoints(this), serverPlayer);
        }
    }

    public int getMoney() {
        return this.money;
    }

    public boolean useMoney(int amount) {
        if (this.money >= amount) {
            this.money -= amount;
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CMoney(this), serverPlayer);
            }
            return true;
        }
        return false;
    }

    public void giveMoney(int amount) {
        this.setMoney(this.getMoney() + amount);
    }

    public void setMoney(int amount) {
        this.money = amount;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((MoneyTrigger)((Object)RuneCraftoryCriteria.MONEY_TRIGGER.get())).trigger(serverPlayer);
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CMoney(this), serverPlayer);
        }
    }

    public XpLevelHolder getPlayerLevel() {
        return this.level;
    }

    public void setPlayerLevel(int level, float xpAmount, boolean recalc) {
        this.level.setLevel(Mth.clamp((int)level, (int)1, (int)GeneralConfig.maxLevel), LevelCalc::xpAmountForLevelUp);
        this.level.setXp(Mth.clamp((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForLevelUp(level)));
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (recalc) {
                this.recalculateStats(true);
            } else {
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CLevelPkt(this), serverPlayer);
            }
        }
    }

    public void addXp(float amount) {
        Player player;
        if (this.level.getLevel() >= GeneralConfig.maxLevel) {
            return;
        }
        boolean levelUp = this.level.addXP(amount, GeneralConfig.maxLevel, LevelCalc::xpAmountForLevelUp, this::handleLevelStatUpdate);
        if (levelUp) {
            this.player.level().playSound(null, this.player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (levelUp) {
                ((LevelTrigger)((Object)RuneCraftoryCriteria.LEVEL_TRIGGER.get())).trigger(serverPlayer);
            }
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CLevelPkt(this), serverPlayer);
        }
    }

    private void handleLevelStatUpdate() {
        float health = this.player.getMaxHealth();
        int runePoints = this.getRunePoints();
        this.updateLevelAttributes();
        this.player.heal(this.player.getMaxHealth() - health);
        this.regenRunePoints(this.getMaxRunePoints() - runePoints);
    }

    public void recalculateStats(boolean regen) {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.updateConfigAttributes();
        this.updateLevelAttributes();
        this.updateSkillLevelAttributes();
        if (regen) {
            this.player.setHealth(this.player.getMaxHealth());
            this.runePoints = this.getMaxRunePoints();
        }
        LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CLevelPkt(this), serverPlayer);
    }

    private double skillVal(Function<SkillProperties, Number> func) {
        return this.skillLevels.entrySet().stream().mapToDouble(e -> (double)(((XpLevelHolder)e.getValue()).getLevel() - 1) * ((Number)func.apply(DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor((Skills)((Object)((Object)e.getKey()))))).doubleValue()).sum();
    }

    public XpLevelHolder getSkillLevel(Skills skill) {
        return this.skillLevels.get((Object)skill);
    }

    public void setSkillLevel(Skills skill, int level, float xpAmount, boolean recalc) {
        this.skillLevels.get((Object)skill).setLevel(this.player.level().isClientSide ? level : Mth.clamp((int)level, (int)1, (int)DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()), l -> LevelCalc.xpAmountForSkillLevelUp(skill, l));
        this.skillLevels.get((Object)skill).setXp(this.player.level().isClientSide ? xpAmount : Mth.clamp((float)xpAmount, (float)0.0f, (float)LevelCalc.xpAmountForSkillLevelUp(skill, level)));
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (recalc) {
                this.recalculateStats(true);
                this.player.setHealth(this.player.getMaxHealth());
            }
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    public void increaseSkill(Skills skill, float amount) {
        Player player;
        if (this.skillLevels.get((Object)skill).getLevel() >= DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()) {
            return;
        }
        boolean levelUp = this.skillLevels.get((Object)skill).addXP(amount, DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel(), lvl -> LevelCalc.xpAmountForSkillLevelUp(skill, lvl), this::onSkillLevelUp);
        if (levelUp) {
            this.player.level().playSound(null, this.player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (levelUp) {
                ((SkillLevelTrigger)((Object)RuneCraftoryCriteria.SKILL_LEVEL_TRIGGER.get())).trigger(serverPlayer, skill);
            }
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CSkillLevelPkt(this, skill), serverPlayer);
        }
    }

    private void onSkillLevelUp() {
        float health = this.player.getMaxHealth();
        int runePoints = this.getRunePoints();
        this.updateSkillLevelAttributes();
        this.player.heal(this.player.getMaxHealth() - health);
        this.regenRunePoints(this.getMaxRunePoints() - runePoints);
    }

    public void increaseStatBonus(ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.setAttributeValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 1.0, AttributeUpdate.ADD);
                break;
            }
            case INT: {
                this.setAttributeValue((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 1.0, AttributeUpdate.ADD);
                break;
            }
            case VIT: {
                this.setForVitality(LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 1.0, AttributeUpdate.ADD);
                break;
            }
            case HP: {
                this.setAttributeValue((Holder<Attribute>)Attributes.MAX_HEALTH, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE, 10.0, AttributeUpdate.ADD);
            }
        }
    }

    public void resetAllStatBoost(ItemStatIncrease.Stat type) {
        switch (type) {
            case STR: {
                this.clearAtributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                break;
            }
            case INT: {
                this.clearAtributeModifier((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                break;
            }
            case VIT: {
                this.clearAtributeModifier((Holder<Attribute>)RuneCraftoryAttributes.DEFENCE.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                this.clearAtributeModifier((Holder<Attribute>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder(), LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
                break;
            }
            case HP: {
                this.clearAtributeModifier((Holder<Attribute>)Attributes.MAX_HEALTH, LibConstants.PLAYER_STAT_BOOST_ITEM_INCREASE);
            }
        }
    }

    public InventorySpells getInv() {
        return this.spells;
    }

    public InventoryShippingBin getShippingInv() {
        return this.shippingBin;
    }

    public void refreshShop() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (NPCProfession profession : RuneCraftoryNPCProfessions.PROFESSIONS.registry()) {
                Collection<ShopItemProperties> datapack = DataPackHandler.INSTANCE.shopItemsManager().get(profession);
                ArrayList shopItems = new ArrayList();
                datapack.forEach(shopProps -> {
                    boolean canAdd;
                    block7: {
                        boolean bl;
                        block6: {
                            if (!shopProps.predicate().isEmpty() && !shopProps.predicate().get().matches(serverPlayer, (Entity)serverPlayer)) break block6;
                            switch (shopProps.unlockType()) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case DEFAULT: {
                                    break block6;
                                }
                                case ALWAYS: {
                                    break;
                                }
                                case NEEDS_SHIPPING: {
                                    if (!this.shippedItems.containsKey(shopProps.stack().getItem())) break block6;
                                }
                            }
                            bl = true;
                            break block7;
                        }
                        bl = canAdd = false;
                    }
                    if (canAdd) {
                        shopItems.add(shopProps.stack().copy());
                    }
                });
                NonNullList shop = NonNullList.create();
                if (!shopItems.isEmpty()) {
                    for (float chance = 1.5f + (float)shopItems.size() * 0.002f; this.player.level().random.nextFloat() < chance; chance -= 0.1f) {
                        ItemStack stack = (ItemStack)shopItems.remove(this.player.level().random.nextInt(shopItems.size()));
                        shop.add((Object)stack);
                        if (shopItems.isEmpty() || profession == RuneCraftoryNPCProfessions.TRAVELLING_MERCHANT.get() && shop.size() >= 30) break;
                    }
                }
                DataPackHandler.INSTANCE.shopItemsManager().getDefaultItems(profession).forEach(props -> shop.add((Object)props.stack()));
                this.shopItems.put(profession, (NonNullList<ItemStack>)shop);
            }
        }
    }

    public NonNullList<ItemStack> getShop(NPCProfession shop) {
        NonNullList list = NonNullList.create();
        list.addAll((Collection)this.shopItems.getOrDefault(shop, (NonNullList<ItemStack>)NonNullList.withSize((int)0, (Object)ItemStack.EMPTY)));
        return list;
    }

    public void addShippingItem(ItemStack stack) {
        int level = ItemComponentUtils.itemLevel(stack);
        this.shippedItems.compute(stack.getItem(), (k, v) -> v == null ? new ShippedItemData(stack.getCount(), level) : new ShippedItemData(v.amount + stack.getCount(), Math.max(v.maxLevel, level)));
    }

    public ShippedItemData shippedItemData(ItemStack stack) {
        return this.shippedItems.get(stack.getItem());
    }

    public int getShippedTypesAmount() {
        return this.shippedItems.size();
    }

    public RecipeKeeper getRecipeKeeper() {
        return this.keeper;
    }

    public void applyFoodEffect(ItemStack stack) {
        Player player;
        FoodProperties food = DataPackHandler.INSTANCE.foodManager().get(stack.getItem());
        if (food == null) {
            return;
        }
        Pair<Map<Holder<Attribute>, Double>, Map<Holder<Attribute>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            this.removeFoodEffect(this.player);
            this.setFoodBonus(foodStats);
            this.foodDuration = food.duration();
            this.lastEaten = stack.getItemHolder();
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CFoodPkt(stack), serverPlayer);
        }
    }

    public void removeFoodEffect(Player player) {
        this.foodDuration = -1;
        this.lastEaten = null;
        this.clearAllAtributeModifier(LibConstants.FOOD_MODIFIER);
        this.clearAllAtributeModifier(LibConstants.FOOD_MODIFIER_MULTI);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CFoodPkt(null), serverPlayer);
        }
    }

    public FoodData foodBuff() {
        return new FoodData(Optional.ofNullable(this.lastEaten), this.foodDuration);
    }

    public void updateFoodBuff(FoodData data) {
        this.lastEaten = data.food().orElse(null);
        this.foodDuration = data.duration();
    }

    public PlayerWeaponHandler getWeaponHandler() {
        return this.weaponHandler;
    }

    public void tick() {
        this.weaponHandler.tick();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.updater.tick(serverPlayer);
            if (serverPlayer.tickCount % 10 == 0 && this.walkingTracker.tickWalkingTracker(serverPlayer)) {
                this.rpStillRegen = 200;
            }
            if (--this.rpStillRegen < 0 && serverPlayer.tickCount % 20 == 0) {
                this.regenRunePoints(1);
            }
            if (--this.breakTick <= 0) {
                this.blockBreakPosForMsg = null;
            }
            ItemStack main = this.player.getMainHandItem();
            ItemStack off = this.player.getOffhandItem();
            if (main.is((Item)RuneCraftoryItems.MOB_STAFF.get()) || off.is((Item)RuneCraftoryItems.MOB_STAFF.get())) {
                if (this.entitySelector.poi != null) {
                    serverPlayer.serverLevel().sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FLAME, true, (double)this.entitySelector.poi.getX() + 0.5, (double)this.entitySelector.poi.getY() + 1.5, (double)this.entitySelector.poi.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    serverPlayer.serverLevel().sendParticles(serverPlayer, (ParticleOptions)ParticleTypes.FLAME, true, (double)this.entitySelector.poi.getX() + 0.5, (double)this.entitySelector.poi.getY() + 1.5, (double)this.entitySelector.poi.getZ() + 0.5, 3, 0.0, 0.0, 0.0, 0.01);
                }
            } else {
                this.entitySelector.reset();
            }
        }
        this.foodDuration = Math.max(--this.foodDuration, -1);
        if (this.foodDuration == 0) {
            this.removeFoodEffect(this.player);
        }
    }

    public DailyPlayerUpdater getDailyUpdater() {
        return this.updater;
    }

    public int getCraftingSeed(Player player) {
        if (this.craftingSeed == 0) {
            this.craftingSeed = player.getRandom().nextInt();
        }
        return this.craftingSeed;
    }

    public void onCrafted(Player player) {
        this.craftingSeed = player.getRandom().nextInt();
    }

    public int getBoughtBarns() {
        return this.boughtBarns;
    }

    public void onBuyBarn() {
        ++this.boughtBarns;
    }

    public boolean onBarnFailMine(BlockPos pos) {
        boolean start = !pos.equals((Object)this.blockBreakPosForMsg);
        this.blockBreakPosForMsg = pos;
        this.breakTick = 20;
        return start;
    }

    public void increaseMobFrom(BaseMonster monster) {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.entityStatsTracker.killEntity((Entity)monster);
        this.increaseMobLevel(monster.getProp().levelIncreaseFromKill(this.entityStatsTracker.getKillCount(monster.getType()), serverPlayer));
    }

    public void increaseMobLevel(int increase) {
        this.mobLevelIncrease += increase;
    }

    public int getMobLevelIncrease() {
        return this.mobLevelIncrease;
    }

    public void readFromNBT(CompoundTag nbt) {
        Player player;
        RegistryAccess provider = this.player.registryAccess();
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.starting = nbt.getBoolean("Starting");
        if (nbt.contains("RestoreHP") && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            float f = nbt.getFloat("RestoreHP");
            serverPlayer.getServer().tell((Runnable)new TickTask(1, () -> this.player.setHealth(f)));
        }
        this.runePoints = nbt.getDouble("RunePoints");
        this.level.read(nbt.get("XpLevel"));
        CompoundTag skillCompound = nbt.getCompound("Skills");
        for (Skills skill : Skills.values()) {
            this.skillLevels.get((Object)skill).read(skillCompound.get(skill.toString()));
        }
        this.money = nbt.getInt("Money");
        this.keeper.read(nbt.getCompound("Recipes"));
        this.shippingBin.load(nbt.getCompound("Shippingbin"), (HolderLookup.Provider)provider);
        ListTag ship = nbt.getList("ShippedItems", 10);
        ship.forEach(arg_0 -> this.lambda$readFromNBT$10((DynamicOps)ops, arg_0));
        ListTag shop = nbt.getList("ShopItems", 10);
        shop.forEach(arg_0 -> this.lambda$readFromNBT$12((HolderLookup.Provider)provider, (DynamicOps)ops, arg_0));
        this.spells.load(nbt.getCompound("Inventory"), (HolderLookup.Provider)provider);
        this.updater.read(nbt.getCompound("DailyUpdater"));
        this.lastEaten = nbt.contains("LastFood") ? (Holder)BuiltInRegistries.ITEM.holderByNameCodec().parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("LastFood")).getOrThrow() : null;
        this.foodDuration = nbt.getInt("FoodBuffDuration");
        this.walkingTracker.read(nbt.getCompound("WalkingTracker"));
        this.entityStatsTracker.read(nbt.getCompound("TamedEntityTracker"));
        this.party.load(nbt.getCompound("PartyTag"));
        this.craftingSeed = nbt.getInt("CraftingSeed");
        this.boughtBarns = nbt.getInt("BoughtBarns");
        this.mobLevelIncrease = nbt.getInt("MobLevelIncrease");
    }

    public CompoundTag writeToNBTPlain(CompoundTag nbt) {
        return this.writeToNBT(nbt, false);
    }

    public CompoundTag writeToNBT(CompoundTag tag, boolean wasDead) {
        RegistryAccess provider = this.player.registryAccess();
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        tag.putBoolean("Starting", this.starting);
        if (wasDead) {
            tag.putFloat("RestoreHP", this.player.getMaxHealth() * GeneralConfig.deathHpPercent);
            tag.putDouble("RunePoints", this.runePoints * (double)GeneralConfig.deathRpPercent);
        } else {
            tag.putDouble("RunePoints", this.runePoints);
        }
        tag.put("XpLevel", (Tag)this.level.save());
        CompoundTag skillCompound = new CompoundTag();
        for (Skills skill : Skills.values()) {
            skillCompound.put(skill.toString(), (Tag)this.skillLevels.get((Object)skill).save());
        }
        tag.put("Skills", (Tag)skillCompound);
        tag.putInt("Money", this.money);
        tag.put("Recipes", (Tag)this.keeper.save());
        tag.put("ShippingBin", (Tag)this.shippingBin.save((HolderLookup.Provider)provider));
        ListTag ship = new ListTag();
        this.shippedItems.forEach((arg_0, arg_1) -> PlayerData.lambda$writeToNBT$13((DynamicOps)ops, ship, arg_0, arg_1));
        tag.put("ShippedItems", (Tag)ship);
        ListTag shop = new ListTag();
        for (Map.Entry<NPCProfession, NonNullList<ItemStack>> entry : this.shopItems.entrySet()) {
            CompoundTag data = new CompoundTag();
            data.put("Shop", (Tag)RuneCraftoryNPCProfessions.PROFESSIONS.registry().byNameCodec().encodeStart((DynamicOps)ops, (Object)entry.getKey()).getOrThrow());
            ListTag items = new ListTag();
            for (ItemStack stack : entry.getValue()) {
                items.add((Object)stack.save((HolderLookup.Provider)provider, (Tag)new CompoundTag()));
            }
            data.put("Items", (Tag)items);
        }
        tag.put("ShopItems", (Tag)shop);
        tag.put("Inventory", (Tag)this.spells.save((HolderLookup.Provider)provider));
        tag.put("DailyUpdater", (Tag)this.updater.save());
        if (this.lastEaten != null) {
            tag.put("LastFood", (Tag)BuiltInRegistries.ITEM.holderByNameCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, this.lastEaten).getOrThrow());
        }
        tag.putInt("FoodBuffDuration", this.foodDuration);
        tag.put("WalkingTracker", (Tag)this.walkingTracker.save());
        tag.put("TamedEntityTracker", (Tag)this.entityStatsTracker.save());
        tag.put("PartyTag", (Tag)this.party.save());
        tag.putInt("CraftingSeed", this.craftingSeed);
        tag.putInt("BoughtBarns", this.boughtBarns);
        tag.putInt("MobLevelIncrease", this.mobLevelIncrease);
        return tag;
    }

    public void resetAll() {
        PlayerData newData = new PlayerData(this.player);
        newData.spells.load(this.spells.save((HolderLookup.Provider)this.player.registryAccess()), (HolderLookup.Provider)this.player.registryAccess());
        newData.shippingBin.load(this.shippingBin.save((HolderLookup.Provider)this.player.registryAccess()), (HolderLookup.Provider)this.player.registryAccess());
        this.readFromNBT(newData.writeToNBTPlain(new CompoundTag()));
        this.recalculateStats(false);
        this.refreshShop();
        this.starting = false;
        this.entityStatsTracker.reset();
        this.mobLevelIncrease = 0;
    }

    private static /* synthetic */ void lambda$writeToNBT$13(DynamicOps ops, ListTag ship, Item key, ShippedItemData value) {
        CompoundTag data = new CompoundTag();
        data.putInt("Amount", value.amount);
        data.putInt("Level", value.maxLevel);
        data.put("Item", (Tag)BuiltInRegistries.ITEM.byNameCodec().encodeStart(ops, (Object)key).getOrThrow());
        ship.add((Object)data);
    }

    private /* synthetic */ void lambda$readFromNBT$12(HolderLookup.Provider provider, DynamicOps ops, Tag t) {
        CompoundTag data = (CompoundTag)t;
        NonNullList list = NonNullList.create();
        ListTag items = data.getList("Items", 10);
        items.forEach(lt -> ItemStack.parse((HolderLookup.Provider)provider, (Tag)lt).ifPresent(arg_0 -> list.add(arg_0)));
        this.shopItems.put((NPCProfession)RuneCraftoryNPCProfessions.PROFESSIONS.registry().byNameCodec().parse(ops, (Object)data.get("Shop")).getOrThrow(), (NonNullList<ItemStack>)list);
    }

    private /* synthetic */ void lambda$readFromNBT$10(DynamicOps ops, Tag t) {
        CompoundTag data = (CompoundTag)t;
        this.shippedItems.put((Item)BuiltInRegistries.ITEM.byNameCodec().parse(ops, (Object)data.get("Item")).getOrThrow(), new ShippedItemData(data.getInt("Amount"), data.getInt("Level")));
    }

    public static enum AttributeUpdate {
        ABSOLUTE,
        REPLACE,
        ADD;


        public void modify(AttributeInstance instance, ResourceLocation modifier, double from) {
            this.modify(instance, modifier, from, AttributeModifier.Operation.ADD_VALUE);
        }

        public void modify(AttributeInstance instance, ResourceLocation modifier, double from, AttributeModifier.Operation operation) {
            double value = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> from - instance.getBaseValue();
                case 1 -> from;
                case 2 -> {
                    AttributeModifier mod = instance.getModifier(modifier);
                    if (mod == null) {
                        yield from;
                    }
                    yield mod.amount() + from;
                }
            };
            instance.removeModifier(modifier);
            if (this == REPLACE && value <= 0.0) {
                return;
            }
            instance.addPermanentModifier(new AttributeModifier(modifier, value, operation));
        }
    }

    public record ShippedItemData(int amount, int maxLevel) {
    }

    public record FoodData(Optional<Holder<Item>> food, int duration) {
    }
}

