/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.LazyResolvedRegistryEntry;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GiantCropBlock
extends ExtendedCropBlock {
    public static final MapCodec<ExtendedCropBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)GiantCropBlock.propertiesCodec(), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("crop").forGetter(d -> d.crop), (App)LazyResolvedRegistryEntry.codec(Registries.ITEM).fieldOf("seed").forGetter(d -> d.seed)).apply((Applicative)inst, GiantCropBlock::new));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    private static final List<Direction> DIRECTIONS = Direction.Plane.HORIZONTAL.stream().sorted(Comparator.comparingInt(Direction::get2DDataValue)).toList();
    private static final VoxelShape[] SHAPE = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)13.0)});

    public GiantCropBlock(BlockBehaviour.Properties prop, ResourceKey<Item> giant, ResourceKey<Item> seed) {
        super(prop, giant, seed);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)Direction.NORTH));
    }

    private GiantCropBlock(BlockBehaviour.Properties prop, LazyResolvedRegistryEntry<Item> crop, LazyResolvedRegistryEntry<Item> seed) {
        this(prop, crop.getKey(), seed.getKey());
    }

    @Override
    public MapCodec<ExtendedCropBlock> codec() {
        return CODEC;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE[((Direction)state.getValue(DIRECTION)).get2DDataValue()];
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    public int getMaxAge() {
        return 0;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Direction dir = (Direction)state.getValue(DIRECTION);
        if (!(direction != dir || neighborState.is((Block)this) && ((Direction)neighborState.getValue(DIRECTION)).getClockWise() == dir)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative()) {
            BlockPos.MutableBlockPos mut = pos.mutable();
            Direction dir = (Direction)state.getValue(DIRECTION);
            for (int i = 0; i < 3; ++i) {
                Direction blockDir;
                BlockState blockAt = level.getBlockState((BlockPos)mut.move(dir));
                if (!blockAt.is((Block)this) || (Integer)blockAt.getValue((Property)AGE) != 1 || (blockDir = (Direction)blockAt.getValue(DIRECTION)) != DIRECTIONS.get((i + ((Direction)state.getValue(DIRECTION)).get2DDataValue()) % 4)) continue;
                level.setBlock((BlockPos)mut, Blocks.AIR.defaultBlockState(), 3);
                level.levelEvent(player, 2001, (BlockPos)mut, Block.getId((BlockState)blockAt));
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{ExtendedCropBlock.WILTED}).add(new Property[]{DIRECTION});
    }

    @Override
    public int getGiantAge() {
        return 0;
    }

    @Override
    public void onWither(int amount, Level level, BlockState state, BlockPos pos) {
        super.onWither(amount, level, state, pos);
        BlockPos.MutableBlockPos mut = pos.mutable();
        Direction dir = (Direction)state.getValue(DIRECTION);
        for (int i = 0; i < 3; ++i) {
            Direction blockDir;
            BlockState blockAt = level.getBlockState((BlockPos)mut.move(dir));
            if (!blockAt.is((Block)this) || (Integer)blockAt.getValue((Property)AGE) != 1 || (blockDir = (Direction)blockAt.getValue(DIRECTION)) != DIRECTIONS.get((i + ((Direction)state.getValue(DIRECTION)).get2DDataValue()) % 4)) continue;
            dir = blockDir;
            super.onWither(amount, level, blockAt, (BlockPos)mut);
        }
    }

    @Override
    public void onWater(Level level, BlockPos pos, BlockState state) {
        super.onWater(level, pos, state);
        BlockPos.MutableBlockPos mut = pos.mutable();
        Direction dir = (Direction)state.getValue(DIRECTION);
        for (int i = 0; i < 3; ++i) {
            Direction blockDir;
            BlockState blockAt = level.getBlockState((BlockPos)mut.move(dir));
            if (!blockAt.is((Block)this) || (Integer)blockAt.getValue((Property)AGE) != 1 || (blockDir = (Direction)blockAt.getValue(DIRECTION)) != DIRECTIONS.get((i + ((Direction)state.getValue(DIRECTION)).get2DDataValue()) % 4)) continue;
            dir = blockDir;
            level.setBlock((BlockPos)mut, (BlockState)blockAt.setValue((Property)ExtendedCropBlock.WILTED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

