/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TreeRootBlock
extends FarmBlock {
    public static final MapCodec<FarmBlock> CODEC = TreeRootBlock.simpleCodec(TreeRootBlock::new);

    public TreeRootBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<FarmBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 3);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()).getBlock() instanceof TreeBaseBlock;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }
}

