/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.config;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ServerValue<T> {
    private static final Map<String, ServerValue<?>> SYNCABLES = new HashMap();
    private T configValue;
    private T useValue;

    public static Map<String, ServerValue<?>> getSyncableValues() {
        return ImmutableMap.copyOf(SYNCABLES);
    }

    public ServerValue(T init, String key) {
        this.configValue = init;
        this.useValue = init;
        if (SYNCABLES.containsKey(key)) {
            throw new IllegalStateException("Syncable config value with key " + key + " already registered");
        }
        SYNCABLES.put(key, this);
    }

    public void read(T configValue) {
        this.configValue = configValue;
        this.useValue = this.configValue;
    }

    protected T getConfigValue() {
        return this.configValue;
    }

    public T get() {
        return this.useValue;
    }

    protected void sync(T value) {
        this.useValue = value;
    }

    public abstract void writeToBuffer(FriendlyByteBuf var1);

    public abstract void readFromBuffer(FriendlyByteBuf var1);

    public static class SyncedDouble
    extends ServerValue<Double> {
        public SyncedDouble(double init, String key) {
            super(init, key);
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.writeDouble(((Double)this.getConfigValue()).doubleValue());
        }

        @Override
        public void readFromBuffer(FriendlyByteBuf buf) {
            this.sync(buf.readDouble());
        }
    }

    public static class SyncedBoolean
    extends ServerValue<Boolean> {
        public SyncedBoolean(boolean init, String key) {
            super(init, key);
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.writeBoolean(((Boolean)this.getConfigValue()).booleanValue());
        }

        @Override
        public void readFromBuffer(FriendlyByteBuf buf) {
            this.sync(buf.readBoolean());
        }
    }
}

