/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;

public class MonsterPropertiesManager
extends SimpleJsonResourceReloadListener
implements ListenerExtension {
    public static final ResourceLocation ID = RuneCraftory.modRes("monster_property");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private Map<EntityType<?>, EntityProperties> propertiesMap = new HashMap();
    private HolderLookup.Provider provider;

    public MonsterPropertiesManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public EntityProperties getPropertiesFor(EntityType<?> type) {
        return this.propertiesMap.getOrDefault(type, EntityProperties.DEFAULT_PROP);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder propertiesBuilder = new ImmutableMap.Builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$1((DynamicOps)ops, propertiesBuilder, arg_0, arg_1));
        this.propertiesMap = propertiesBuilder.build();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    private /* synthetic */ void lambda$apply$1(DynamicOps ops, ImmutableMap.Builder propertiesBuilder, ResourceLocation key, JsonElement el) {
        try {
            EntityType type = (EntityType)HolderUtils.get(this.provider, Registries.ENTITY_TYPE, key).orElseThrow(() -> new NoSuchElementException("Entity with id " + String.valueOf(key) + " doesn't exist"));
            EntityProperties props = (EntityProperties)EntityProperties.CODEC.parse(ops, (Object)el).getOrThrow();
            propertiesBuilder.put((Object)type, (Object)props);
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse entity properties json {} {}", (Object)key, (Object)ex);
            ex.fillInStackTrace();
        }
    }
}

