/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class GiftManager
extends SimpleJsonResourceReloadListener
implements ListenerExtension {
    public static final ResourceLocation ID = RuneCraftory.modRes("npc_gift");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private Map<ResourceLocation, ReloadableHolder<GiftData>> gifts;
    private List<ReloadableHolder<GiftData>> giftsList;
    private HolderLookup.Provider provider;

    public GiftManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public ReloadableHolder<GiftData> get(ResourceLocation id) {
        return this.gifts.get(id);
    }

    public ReloadableHolder<GiftData> getRandomGift(Random random, int xp) {
        List<ReloadableHolder> selectables = this.giftsList.stream().filter(g -> ((GiftData)g.value()).matches(xp)).toList();
        if (selectables.isEmpty()) {
            return null;
        }
        return selectables.get(random.nextInt(selectables.size()));
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistryOps ops = this.provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> GiftManager.lambda$apply$1(builder, (DynamicOps)ops, arg_0, arg_1));
        this.gifts = builder.build();
        this.giftsList = this.gifts.keySet().stream().sorted().map(this.gifts::get).toList();
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(HolderLookup.Provider provider) {
        this.provider = provider;
    }

    private static /* synthetic */ void lambda$apply$1(ImmutableMap.Builder builder, DynamicOps ops, ResourceLocation res, JsonElement e) {
        try {
            builder.put((Object)res, new ReloadableHolder<GiftData>(res, (GiftData)GiftData.CODEC.parse(ops, (Object)e).getOrThrow()));
        }
        catch (Exception exception) {
            RuneCraftory.LOGGER.error("Error parsing GiftData: {} - {}", (Object)res, (Object)exception);
        }
    }
}

