/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.common.advancements.TameMonsterTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.FollowEntityEx;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetTargetFromRider;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SinkIfTooHigh;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.TendCrops;
import io.github.flemmli97.runecraftory.common.entities.utils.CommonMonsterHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.DailyMonsterUpdater;
import io.github.flemmli97.runecraftory.common.entities.utils.ExtendedEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateTracker;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2COpenCompanionGui;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.TamingTracker;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryActivities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.mixin.CombatTrackerAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.MoveControllerPlus;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMonster
extends PathfinderMob
implements Enemy,
AnimatedEntity,
CommonMonsterHandler,
ExtendedEntity,
SleepingEntity,
TargetableOpponent,
AOEAttackEntity,
MobAttackExt,
SmartBrainOwner<BaseMonster>,
SyncedMobDataHandler {
    public static final int MOVE_TICK_MAX = 5;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.defineId(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> BEHAVIOUR_DATA = SynchedEntityData.defineId(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> PLAY_DEATH_STATE = SynchedEntityData.defineId(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FRIEND_POINTS_SYNC = SynchedEntityData.defineId(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final TypedResource<TargetPosition> TARGET_POSITION = new TypedResource(RuneCraftory.modRes("target_position"));
    public final Predicate<LivingEntity> targetPred = e -> {
        if (e != this) {
            Mob mob;
            if (this.hasPassenger((Entity)e) || !this.canAttack((LivingEntity)e)) {
                return false;
            }
            if (this.isTamed()) {
                return e instanceof Enemy && EntityUtils.canAttackOwned(e, false, true, this.targetPred);
            }
            if (e instanceof Mob && this == (mob = (Mob)e).getTarget()) {
                return true;
            }
            return EntityUtils.canMonsterTargetNPC((Entity)e) || EntityUtils.canAttackOwned(e, false, e instanceof Player, entity -> entity instanceof Player ? entity.canBeSeenAsEnemy() : this.targetPred.test((LivingEntity)entity));
        }
        return false;
    };
    public final Predicate<LivingEntity> hitPred = e -> {
        if (e != this) {
            if (this.hasPassenger((Entity)e) || !this.canAttack((LivingEntity)e)) {
                return false;
            }
            if (e instanceof Mob && this == ((Mob)e).getTarget()) {
                return true;
            }
            LivingEntity controller = this.getControllingPassenger();
            if (this.isTamed()) {
                UUID owner = EntityUtils.tryGetOwner(e);
                if (owner != null && (!this.attackOtherTamedMobs() || owner.equals(this.getOwnerUUID()))) {
                    return false;
                }
                if (e == this.getTarget()) {
                    return true;
                }
                if (controller instanceof Player) {
                    return true;
                }
                return e instanceof Enemy || e instanceof Mob && ((Mob)e).getTarget() == this;
            }
            boolean riderTarget = false;
            if (controller != null) {
                Mob mob;
                if (controller instanceof BaseMonster) {
                    BaseMonster baseMonster = (BaseMonster)controller;
                    return baseMonster.hitPred.test((LivingEntity)e);
                }
                riderTarget = controller instanceof Mob && e == (mob = (Mob)controller).getTarget();
            }
            return riderTarget || e == this.getTarget() || EntityUtils.canMonsterTargetNPC((Entity)e) || EntityUtils.canAttackOwned(e, false, e instanceof Player, this.targetPred) || e instanceof Player;
        }
        return false;
    };
    public final Predicate<LivingEntity> defendPred = e -> {
        if (e != this) {
            if (this.getControllingPassenger() instanceof Player) {
                return false;
            }
            if (this.isTamed()) {
                return !e.getUUID().equals(this.getOwnerUUID()) && !this.getOwnerUUID().equals(EntityUtils.tryGetOwner(e));
            }
            return true;
        }
        return false;
    };
    private final EntityProperties prop;
    private final float defaultScale;
    private final XpLevelHolder levelPair = new XpLevelHolder();
    private final XpLevelHolder friendlyPoints = new XpLevelHolder();
    private final DailyMonsterUpdater updater = new DailyMonsterUpdater(this);
    private final SyncedDataContainer<BaseMonster> syncedDataContainer;
    protected int tamingTick = -1;
    protected int feedTimeOut;
    private BlockPos seedInventory;
    private BlockPos cropInventory;
    private int playDeathTick;
    private int brushCount;
    private int loveAttCount;
    private Runnable delayedTaming;
    private boolean doJumping = false;
    private int foodBuffTick;
    private Player owner;
    private int tpCooldown;
    private Behaviour behaviour = Behaviour.WANDER;
    private BarnData assignedBarn;
    private Pair<String, Runnable> scheduledAnimationHandling;
    private final MoveStateTracker moveStateTracker = new MoveStateTracker(5, this::getMoveFlag);
    private boolean initAnim;

    public BaseMonster(EntityType<? extends BaseMonster> type, Level level) {
        super(type, level);
        SyncedDataContainer.Builder builder = SyncedDataContainer.builder((Entity)this);
        this.definedAdditinoalSyncedData((SyncedDataContainer.Builder<BaseMonster>)builder);
        this.syncedDataContainer = builder.build();
        this.moveControl = new MoveControllerPlus((Mob)this);
        this.prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(type);
        this.applyAttributes();
        this.defaultScale = (float)(type.getSpawnAABB(0.0, 0.0, 0.0).getYsize() / (double)type.getHeight());
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder map = Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        for (RegistryEntrySupplier<Attribute, ?> att : RuneCraftoryAttributes.ENTITY_ATTRIBUTES) {
            map.add(att.asHolder());
        }
        return map;
    }

    public EntityProperties getProp() {
        return this.prop;
    }

    protected PathNavigation createNavigation(Level level) {
        return new SmoothGroundNavigation((Mob)this, level);
    }

    protected void applyAttributes() {
        for (Map.Entry<Holder<Attribute>, Double> att : this.prop.baseValues().entrySet()) {
            AttributeInstance inst = this.getAttribute(att.getKey());
            if (inst == null) continue;
            inst.setBaseValue(att.getValue().doubleValue());
            if (att.getKey() != Attributes.MAX_HEALTH) continue;
            this.setHealth(this.getMaxHealth());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(MOVE_FLAGS, (Object)0);
        builder.define(BEHAVIOUR_DATA, (Object)0);
        builder.define(PLAY_DEATH_STATE, (Object)false);
        builder.define(FRIEND_POINTS_SYNC, (Object)1);
    }

    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        builder.define(TARGET_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.TARGET_POS.get(), null);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide) {
            if (key.equals(BEHAVIOUR_DATA)) {
                try {
                    this.behaviour = Behaviour.values()[(Integer)this.entityData.get(BEHAVIOUR_DATA)];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (key.equals(PLAY_DEATH_STATE) && ((Boolean)this.entityData.get(PLAY_DEATH_STATE)).booleanValue() && !this.getAnimationHandler().hasAnimation()) {
                this.playDeathAnimation(true);
            }
        }
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public void handleEntityEvent(byte id) {
        if (id == 10) {
            this.playTameEffect(true);
        } else if (id == 11) {
            this.playTameEffect(false);
        } else if (id == 34) {
            for (int i = 0; i < 5; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX() - (double)this.getBbWidth() * 0.25 + (double)(this.random.nextFloat() * this.getBbWidth() * 0.25f), this.getY() + (double)this.getBbHeight() + (double)this.random.nextFloat() * 0.3, this.getZ() - (double)this.getBbWidth() * 0.25 + (double)(this.random.nextFloat() * this.getBbWidth() * 0.25f), 0.0, 0.0, 0.0);
            }
        } else if (id == 64) {
            this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, true, this.getX(), this.getY() + (double)this.getBbHeight() + 0.3, this.getZ(), 0.0, 0.0, 0.0);
        } else if (id == 65) {
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, true, this.getX(), this.getY() + (double)this.getBbHeight() + 0.3, this.getZ(), 0.0, 0.0, 0.0);
        }
        super.handleEntityEvent(id);
    }

    public void tick() {
        AnimationState animation;
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                if (anim != null && !this.level().isClientSide) {
                    this.setupAttack((AnimationDefinition)anim);
                }
                return false;
            });
            this.initAnim = true;
        }
        super.tick();
        Vec3 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            float[] clamp = this.targetLookClamp();
            this.setYRot(MathsHelper.rotlerp(this.getYRot(), yxRot[0], clamp[0]));
            this.setXRot(MathsHelper.rotlerp(this.getXRot(), yxRot[1], clamp[1]));
            this.setYBodyRot(this.getYRot());
            this.setYHeadRot(this.getYRot());
        }
        this.moveStateTracker.tick();
        if (!this.level().isClientSide) {
            this.updater.tick();
            if (this.tamingTick > 0 || this.isNoAi()) {
                if (this.getMoveFlag() != MoveType.NONE) {
                    this.setMovingFlag(MoveType.NONE);
                    this.setDeltaMovement(Vec3.ZERO);
                }
                if (this.tamingTick > 0) {
                    --this.tamingTick;
                }
            }
            if (this.tamingTick == 0) {
                if (this.delayedTaming != null) {
                    this.delayedTaming.run();
                    this.delayedTaming = null;
                }
                this.tamingTick = -1;
            }
            if (this.feedTimeOut > 0) {
                --this.feedTimeOut;
            }
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.assignedBarn != null && this.assignedBarn.isInvalidFor(this)) {
                this.assignedBarn = null;
            }
            if (this.isTamed() && this.assignedBarn == null && MobConfig.monsterNeedBarn && this.behaviourState() != Behaviour.STAY) {
                this.setBehaviour(Behaviour.STAY);
            }
        } else if (!this.playDeath() && TendCrops.cantTendToCropsAnymore(this) && this.behaviour == Behaviour.FARM && this.tickCount % 20 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY() + (double)this.getBbHeight() + 0.3, this.getZ(), 0.0, 0.0, 0.0);
        }
        if ((animation = this.getAnimationHandler().getAnimation()) == null && this.getTargetPosition() != null) {
            this.setTargetPosition((TargetPosition)null);
        }
        if (animation == null || this.scheduledAnimationHandling != null && !((String)this.scheduledAnimationHandling.getFirst()).equals(animation.getID())) {
            this.scheduledAnimationHandling = null;
        }
    }

    public void aiStep() {
        super.aiStep();
        this.getAnimationHandler().tick();
        boolean teleported = false;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Player owner;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (owner = this.getOwner()) != null) {
                serverLevel.getChunkSource().addRegionTicket(WorldUtils.ENTITY_LOADER, this.chunkPosition(), 3, (Object)this.chunkPosition());
                if (owner.level().dimension() != this.level().dimension()) {
                    TeleportUtils.safeDimensionTeleport((Mob)this, (ServerLevel)owner.level(), owner.blockPosition());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (owner.distanceToSqr((Entity)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((Mob)this, (Entity)owner);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
        }
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.level().isClientSide) {
                if (teleported) {
                    this.heal(1.0f);
                }
                if ((double)this.getHealth() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain((LivingEntity)this);
        if (this.tickCount % 10 == 0) {
            if (this.isStaying()) {
                BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.STAYING.get()), (Object)Unit.INSTANCE);
            } else {
                BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.STAYING.get()));
            }
        }
        if (!(this.getControllingPassenger() instanceof Player) && this.getMoveControl().operation != MoveControl.Operation.WAIT && this.getDeltaMovement().lengthSqr() > 5.0E-4) {
            double d0 = this.getMoveControl().getSpeedModifier();
            MoveType move = d0 > this.sprintSpeedThreshold() ? MoveType.RUN : (d0 <= this.crouchSpeedThreshold() ? MoveType.SNEAK : MoveType.WALK);
            if (this.isImmobile()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.setShiftKeyDown(false);
            this.setSprinting(false);
        }
    }

    public double crouchSpeedThreshold() {
        return 0.6;
    }

    public double sprintSpeedThreshold() {
        return 1.0;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("MobLevel", (Tag)this.xpLevel().save());
        if (this.isTamed()) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
        compound.putInt("Behaviour", this.behaviourState().ordinal());
        compound.putInt("FeedTime", this.feedTimeOut);
        if (this.hasRestriction()) {
            compound.putIntArray("Home", new int[]{this.getRestrictCenter().getX(), this.getRestrictCenter().getY(), this.getRestrictCenter().getZ(), (int)this.getRestrictRadius()});
        }
        compound.putInt("FoodBuffTick", this.foodBuffTick);
        compound.put("FriendlyPoints", (Tag)this.friendlyPoints.save());
        compound.put("DailyUpdater", (Tag)this.updater.save());
        compound.putBoolean("PlayDeath", ((Boolean)this.entityData.get(PLAY_DEATH_STATE)).booleanValue());
        if (this.seedInventory != null) {
            compound.putIntArray("SeedInventory", new int[]{this.seedInventory.getX(), this.seedInventory.getY(), this.seedInventory.getZ()});
        }
        if (this.cropInventory != null) {
            compound.putIntArray("CropInventory", new int[]{this.cropInventory.getX(), this.cropInventory.getY(), this.cropInventory.getZ()});
        }
        if (this.assignedBarn != null && !this.assignedBarn.isInvalidFor(this)) {
            GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.assignedBarn.pos).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> compound.put("AssignedBarnLocation", t));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        int[] arr;
        super.readAdditionalSaveData(compound);
        this.levelPair.read((Tag)compound.getCompound("MobLevel"));
        if (compound.contains("Owner")) {
            this.entityData.set(OWNER_UUID, Optional.of(compound.getUUID("Owner")));
        }
        this.feedTimeOut = compound.getInt("FeedTime");
        if (compound.contains("Home")) {
            int[] home = compound.getIntArray("Home");
            this.restrictTo(new BlockPos(home[0], home[1], home[2]), home[3]);
        }
        this.foodBuffTick = compound.getInt("FoodBuffTick");
        this.friendlyPoints.read((Tag)compound.getCompound("FriendlyPoints"));
        this.entityData.set(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel());
        this.updater.read(compound.getCompound("DailyUpdater"));
        this.setPlayDeath(compound.getBoolean("PlayDeath"));
        if (compound.contains("SeedInventory") && (arr = compound.getIntArray("SeedInventory")).length == 3) {
            this.setSeedInventory(new BlockPos(arr[0], arr[1], arr[2]));
        }
        if (compound.contains("CropInventory") && (arr = compound.getIntArray("CropInventory")).length == 3) {
            this.setCropInventory(new BlockPos(arr[0], arr[1], arr[2]));
        }
        if (compound.contains("AssignedBarnLocation") && this.getServer() != null) {
            GlobalPos.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("AssignedBarnLocation"))).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(p -> {
                this.assignedBarn = RunecraftorySavedData.get(this.getServer()).barnAt((GlobalPos)p);
            });
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.getInt("Behaviour")], true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public List<? extends ExtendedSensor<? extends BaseMonster>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.targetPred.test((LivingEntity)target)).setScanRate(e -> 10), new HurtBySensor().setPredicate((source, entity) -> {
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                return entity.defendPred.test(attacker);
            }
            return true;
        }));
    }

    public BrainActivityGroup<? extends BaseMonster> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new FloatToSurfaceOfFluid().startCondition(BaseMonster::canFloatInWater), new SetTargetFromRider(), new SinkIfTooHigh(), new FollowEntityEx<BaseMonster, Player>().startFollowingWhen((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 8.0 : 12.0).ignoreIfTargetingTill(20.0).stopFollowingWithin((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 2.0 : 6.0).teleportToTargetAfter((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 20.0 : 24.0).following(BaseMonster::getOwner).speedMod(1.05f).speedMod(1.1f).startCondition(m -> m.behaviourState() == Behaviour.FOLLOW || m.behaviourState() == Behaviour.FOLLOW_DISTANCE), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.getRandom().nextIntBetweenInclusive(40, 100)).whenStopping(m -> BrainUtils.clearMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.LOOK_TARGET))});
    }

    protected ExtendedBehaviour<? extends BaseMonster> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((FloatProvider)ConstantFloat.of((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.getRandom().nextFloat() < 0.1 && !BrainUtils.hasMemory((LivingEntity)m, (MemoryModuleType)MemoryModuleType.WALK_TARGET))}).startCondition(e -> !BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) && !e.isSleeping() && !e.playDeath() && !e.getAnimationHandler().hasAnimation());
    }

    public BrainActivityGroup<? extends BaseMonster> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetMoveToRestriction(), this.getWanderBehaviour().startCondition(m -> m.getRandom().nextInt(m.wanderChance()) == 0)})});
    }

    public BrainActivityGroup<? extends BaseMonster> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), this.getCooldownAI().startCondition(BaseMonster::runCooldownBehaviour).stopIf(e -> !e.runCooldownBehaviour()), this.getCombatAI().startCondition(BaseMonster::runCombatBehaviour)});
    }

    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return new Idle();
    }

    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return new Idle();
    }

    protected boolean runCooldownBehaviour() {
        return !this.getAnimationHandler().hasAnimation() && (BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN) || !BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.ANIMATION_TO_PLAY.get())));
    }

    protected boolean runCombatBehaviour() {
        return !this.getAnimationHandler().hasAnimation() && !BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN);
    }

    public Map<Activity, BrainActivityGroup<? extends BaseMonster>> getAdditionalTasks() {
        HashMap<Activity, BrainActivityGroup<? extends BaseMonster>> map = new HashMap<Activity, BrainActivityGroup<? extends BaseMonster>>();
        map.put((Activity)RuneCraftoryActivities.STAY.get(), new BrainActivityGroup((Activity)RuneCraftoryActivities.STAY.get()).priority(20).behaviours(new Behavior[]{new Idle()}).onlyStartWithMemoryStatus((MemoryModuleType)RuneCraftoryMemoryTypes.STAYING.get(), MemoryStatus.VALUE_PRESENT));
        map.put(Activity.WORK, new BrainActivityGroup(Activity.WORK).priority(20).behaviours(new Behavior[]{new MoveToWalkTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetMoveToRestriction(), new TendCrops()})}).onlyStartWithMemoryStatus((MemoryModuleType)RuneCraftoryMemoryTypes.FARMING.get(), MemoryStatus.VALUE_PRESENT));
        return map;
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{(Activity)RuneCraftoryActivities.STAY.get(), Activity.WORK, Activity.FIGHT, Activity.IDLE});
    }

    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget();
    }

    protected int wanderChance() {
        return this.behaviourState() == Behaviour.WANDER_HOME ? 40 : 120;
    }

    protected boolean canFloatInWater() {
        return true;
    }

    protected Brain.Provider<?> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public MoveType getMoveFlag() {
        return MoveType.values()[(Byte)this.entityData.get(MOVE_FLAGS)];
    }

    public void setMovingFlag(MoveType type) {
        this.entityData.set(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean isStaying() {
        if (!this.isTamed()) {
            return false;
        }
        if (this.isInWaterOrBubble() && !this.canBreatheUnderwater()) {
            return false;
        }
        if (!this.onGround() && !this.isNoGravity()) {
            return false;
        }
        return this.behaviour == Behaviour.STAY;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.setBehaviour(behaviour, false);
    }

    private void setBehaviour(Behaviour behaviour, boolean load) {
        this.entityData.set(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.level().isClientSide) {
            this.updateAI(false, load);
        }
    }

    private void updateAI(boolean forced, boolean load) {
        if (forced || this.isTamed()) {
            this.getNavigation().stop();
            if (this.behaviourState() != Behaviour.FARM) {
                this.setSeedInventory(null);
                this.setCropInventory(null);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    FarmlandHandler.get(serverLevel.getServer()).removeIrrigationPOI(serverLevel, this.getUUID());
                }
            }
            BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.FARMING.get()));
            switch (this.behaviourState().ordinal()) {
                case 1: {
                    if (this.getOwner() == null) break;
                    if (this.findNearestBarn(load)) {
                        this.restrictToBasedOnBehaviour(null, load);
                        BlockPos pos = this.assignedBarn.pos.pos();
                        if (this.level().dimension() == this.assignedBarn.pos.dimension()) {
                            TeleportSpell.safeTeleportTo((Entity)this, pos.getX(), pos.getY(), pos.getZ());
                        } else {
                            ServerLevel serverLevel = this.getServer().getLevel(this.assignedBarn.pos.dimension());
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((Entity)this, serverLevel, pos.getX(), pos.getY(), pos.getZ());
                            }
                        }
                    } else {
                        if (this.tickCount > 20) {
                            this.getOwner().displayClientMessage((Component)Component.translatable((String)"runecraftory.monster.interact.barn.no.ext", (Object[])new Object[]{this.getDisplayName(), this.blockPosition().toShortString()}), false);
                        }
                        this.setBehaviour(Behaviour.WANDER);
                    }
                    Platform.INSTANCE.getPlayerData((Player)this.getOwner()).party.removePartyMember((Entity)this);
                    break;
                }
                case 2: {
                    boolean party;
                    if (this.getOwner() == null) break;
                    PlayerData data = Platform.INSTANCE.getPlayerData(this.getOwner());
                    boolean bl = party = !data.party.isPartyFull() || data.party.isPartyMember((Entity)this);
                    if (!party) break;
                    this.clearRestriction();
                    data.party.addPartyMember((Entity)this);
                    break;
                }
                case 3: {
                    this.clearRestriction();
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData((Player)this.getOwner()).party.addPartyMember((Entity)this);
                    break;
                }
                case 4: {
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData((Player)this.getOwner()).party.addPartyMember((Entity)this);
                    break;
                }
                case 0: {
                    this.restrictToBasedOnBehaviour(this.blockPosition(), load);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData((Player)this.getOwner()).party.removePartyMember((Entity)this);
                    break;
                }
                case 5: {
                    this.restrictToBasedOnBehaviour(this.blockPosition(), load);
                    BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.FARMING.get()), (Object)Unit.INSTANCE);
                    BlockPos nearestInv = this.nearestBlockEntityWithInv();
                    if (this.getSeedInventory() == null) {
                        this.setSeedInventory(nearestInv);
                    }
                    if (this.getCropInventory() == null) {
                        this.setCropInventory(nearestInv);
                    }
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData((Player)this.getOwner()).party.removePartyMember((Entity)this);
                }
            }
        }
    }

    public void restrictToBasedOnBehaviour(@Nullable BlockPos pos, boolean keepPos) {
        if (this.behaviourState() == Behaviour.WANDER_HOME && this.assignBarn() && this.level().dimension() == this.assignedBarn.pos.dimension()) {
            this.restrictTo(this.assignedBarn.pos.pos(), 1);
        }
        if (pos == null) {
            return;
        }
        if (keepPos) {
            pos = this.getRestrictCenter();
        }
        if (this.behaviourState() == Behaviour.FARM) {
            this.restrictTo(pos, MobConfig.farmRadius + 3);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                FarmlandHandler.get(serverLevel.getServer()).addIrrigationPOI(serverLevel, this.getUUID(), this.blockPosition());
            }
        } else if (this.behaviourState() == Behaviour.WANDER) {
            this.restrictTo(pos, 9);
        }
    }

    public float getRestrictRadius() {
        if (this.behaviourState() == Behaviour.WANDER_HOME && this.assignedBarn != null && this.level().dimension() == this.assignedBarn.pos.dimension()) {
            return (float)this.assignedBarn.getSize() + 1.5f;
        }
        return super.getRestrictRadius();
    }

    protected boolean isImmobile() {
        return super.isImmobile() || this.getControllingPassenger() instanceof Player || this.playDeath() || this.tamingTick > 0;
    }

    protected float getWaterSlowDown() {
        return 0.83f;
    }

    public void travel(Vec3 vec) {
        if (this.shouldFreezeTravel()) {
            this.xxa = 0.0f;
            this.yya = 0.0f;
            this.zza = 0.0f;
            return;
        }
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.handlePlayerInput(player, this.isNoGravity(), this::handleLandTravel);
        } else {
            this.handleLandTravel(vec);
        }
    }

    public void handleFreeTravel(Vec3 vec) {
        if (this.shouldFreezeTravel()) {
            this.xxa = 0.0f;
            this.yya = 0.0f;
            this.zza = 0.0f;
            return;
        }
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.handlePlayerInput(player, true, this::freeTravel);
        } else {
            this.freeTravel(vec);
        }
    }

    private void freeTravel(Vec3 vec) {
        boolean currentNophysics = this.noPhysics;
        if (!this.isAlive() || this.playDeath()) {
            this.noPhysics = false;
            vec = Vec3.ZERO;
        }
        this.moveRelative(this.getSpeed() * 0.2f, vec);
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.91));
        this.noPhysics = currentNophysics;
    }

    public boolean shouldFreezeTravel() {
        return false;
    }

    protected void handlePlayerInput(Player player, boolean hovers, Consumer<Vec3> cons) {
        if (this.getAnimationHandler().hasAnimation()) {
            this.setMovingFlag(MoveType.NONE);
            this.setSprinting(false);
            cons.accept(Vec3.ZERO);
            return;
        }
        if (!this.isControlledByLocalInstance()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setDoJumping(false);
            return;
        }
        if (this.adjustRotFromRider((LivingEntity)player)) {
            this.setYRot(this.rotateClamped(this.getYRot(), player.getYRot(), this.getHeadRotSpeed() * 2));
            this.setXRot(this.rotateClamped(this.getXRot(), player.getXRot(), this.getMaxHeadXRot()));
        }
        this.setYBodyRot(this.getYRot());
        this.setYHeadRot(this.getYRot());
        double attrSpeed = !this.onGround() && this.getAttributes().hasAttribute(Attributes.FLYING_SPEED) ? this.getAttributeValue(Attributes.FLYING_SPEED) : this.getAttributeValue(Attributes.MOVEMENT_SPEED);
        float speed = (float)(attrSpeed / 1.3 * this.ridingSpeedModifier());
        float strafing = player.xxa / 0.98f * speed * 0.8f;
        float forward = player.zza / 0.98f * speed;
        if (player.zza < 0.0f) {
            forward *= 0.5f;
        }
        float vertical = 0.0f;
        if (hovers && forward > 0.0f) {
            vertical = (float)Math.min(0.0, player.getLookAngle().y + 0.45) * speed;
            if (player.getXRot() > 85.0f) {
                forward = 0.0f;
            } else if (vertical < 0.0f) {
                forward = (float)Math.sqrt(forward * forward - vertical * vertical);
            }
        }
        if (this.doJumping()) {
            if (this.onGround() && !this.isFlyingEntity()) {
                this.hasImpulse = true;
                this.jumpFromGround();
                if (forward > 0.0f) {
                    float x = -Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
                    float z = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
                    this.setDeltaMovement(this.getDeltaMovement().add(0.3 * (double)x, 0.0, 0.3 * (double)z));
                }
            } else if (this.isFlyingEntity()) {
                vertical = speed * 0.7f;
                if (this.getDeltaMovement().y() < (double)vertical) {
                    this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.1, this.getDeltaMovement().z));
                }
            }
        }
        this.setSpeed(speed);
        MoveType type = forward > 0.0f ? MoveType.RUN : (forward != 0.0f || strafing != 0.0f ? MoveType.WALK : MoveType.NONE);
        this.setMovingFlag(type);
        this.setSprinting(type == MoveType.RUN);
        this.setDoJumping(false);
        cons.accept(new Vec3((double)strafing, (double)vertical, (double)forward));
    }

    public void handleLandTravel(Vec3 vec) {
        if (!this.isAlive() || this.playDeath()) {
            vec = Vec3.ZERO;
        }
        super.travel(vec);
    }

    public void setDoJumping(boolean jump) {
        this.doJumping = jump;
    }

    public boolean doJumping() {
        return this.doJumping;
    }

    public boolean adjustRotFromRider(LivingEntity rider) {
        return true;
    }

    private float rotateClamped(float current, float target, float maxChange) {
        float f = Mth.degreesDifference((float)current, (float)target);
        float g = Mth.clamp((float)f, (float)(-maxChange), (float)maxChange);
        return current + g;
    }

    public double ridingSpeedModifier() {
        return 1.3;
    }

    protected Vec3 directionToLookAt() {
        return this.getAnimationHandler().hasAnimation() && this.getTargetPosition() != null ? this.getTargetPosition().asVec(this.position()).subtract(this.position()) : null;
    }

    protected float[] targetLookClamp() {
        return new float[]{60.0f, 30.0f};
    }

    protected AABB getAttackBoundingBox() {
        return this.getBoundingBox().inflate(0.5);
    }

    public boolean doHurtTarget(Entity entity) {
        return CombatUtils.mobAttack((LivingEntity)this, entity, this.damageSourceAttack());
    }

    public DynamicDamage.Builder damageSourceAttack() {
        return new DynamicDamage.Builder((Entity)this).hurtResistant(5);
    }

    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.getRandom().nextInt(20) + 30 + diffAdd;
        }
        return this.getRandom().nextInt(20) + 20 + diffAdd;
    }

    public int difficultyCooldown() {
        int diffAdd = 20;
        Difficulty diff = this.level().getDifficulty();
        if (this.level().getDifficulty() == Difficulty.HARD) {
            diffAdd = 0;
        } else if (diff == Difficulty.NORMAL) {
            diffAdd = 10;
        }
        return diffAdd;
    }

    public boolean canAttack(LivingEntity target) {
        return super.canAttack(target) && this.isWithinRestriction(target.blockPosition());
    }

    public LivingEntity getTarget() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this);
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        if (super.getTarget() == null) {
            BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
        } else {
            BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET, (Object)super.getTarget());
        }
    }

    public boolean attackOtherTamedMobs() {
        return false;
    }

    public void setupAttack(AnimationDefinition anim) {
        BrainUtils.clearMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.LOOK_TARGET);
        if (this.getTarget() != null) {
            this.setTargetPosition(this.getTarget());
        }
        this.getNavigation().stop();
    }

    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{this.getInteractAnimation()})) {
            if (this.scheduledAnimationHandling != null && anim.is(new String[]{(String)this.scheduledAnimationHandling.getFirst()}) && anim.isAt("attack")) {
                ((Runnable)this.scheduledAnimationHandling.getSecond()).run();
            }
            return;
        }
        if (anim.is(new String[]{this.getDeathAnimation(), this.getSleepAnimation()})) {
            return;
        }
        this.getNavigation().stop();
        if (anim.isAt("attack")) {
            this.mobAttack(anim, this.getTarget(), this::doHurtTarget);
        }
    }

    @Override
    public TargetPosition getTargetPosition() {
        return (TargetPosition)this.getDataContainer().get(TARGET_POSITION);
    }

    public void setTargetPosition(LivingEntity target) {
        this.setTargetPosition(TargetPosition.of((LivingEntity)target));
    }

    public void setTargetPosition(TargetPosition position) {
        this.getDataContainer().set(TARGET_POSITION, (Object)position);
    }

    @Nullable
    public Vec3 tryGetTargetPosition(LivingEntity target) {
        if (this.getTargetPosition() != null) {
            return this.getTargetPosition().asVec(this.position());
        }
        return target != null ? target.position() : null;
    }

    public void mobAttack(AnimationState anim, LivingEntity target, Consumer<LivingEntity> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.tryGetTargetPosition(target), 0.0);
        this.level().getEntitiesOfClass(LivingEntity.class, obb.getEncompassingBox(), entity -> this.hitPred.test((LivingEntity)entity) && obb.intersects(entity.getBoundingBox())).forEach(cons);
        if (!this.level().isClientSide) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public boolean isInAttackBox(Entity entity, String animation) {
        OrientedBoundingBox aabb = this.prepareAttackBox(animation, entity, -0.15, false);
        return aabb.intersects(entity.getBoundingBox());
    }

    public OrientedBoundingBox prepareAttackBox(String anim, Entity target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(this.getAnimationHandler().createDefaulted(anim), target != null ? target.position() : null, grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
        }
        return obb;
    }

    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, @Nullable Vec3 target, double grow) {
        float yRot = this.getYHeadRot();
        float xRot = this.getXRot();
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            yRot = player.getYHeadRot();
            xRot = player.getXRot();
        } else if (target != null) {
            Vec3 dir = target.subtract(this.position()).normalize();
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            yRot = yXRot[0];
            xRot = -yXRot[1];
        }
        double off = (double)this.getBbHeight() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).inflate(grow, 0.0, grow).move(0.0, -off, grow), yRot, Mth.clamp((float)xRot, (float)-15.0f, (float)15.0f), this.position().add(0.0, off, 0.0));
    }

    public AABB attackBB(AnimationState anim) {
        double range = 1.0;
        return new AABB(-range * 0.5, -0.02, 0.0, range * 0.5, this.vehicleDependentHeight() + 0.02, range);
    }

    public final double vehicleDependentHeight() {
        double height = this.getBbHeight();
        Entity entity = this.getVehicle();
        if (entity != null) {
            height = this.getAttackBoundingBox().maxY - entity.getBoundingBox().minY;
        }
        return height;
    }

    public abstract void handleRidingCommand(int var1);

    public boolean allowAnimation(@Nullable String prev, String other) {
        return true;
    }

    public void setLastHurtByMob(@Nullable LivingEntity livingBase) {
        if (this.isDeadOrDying() && this.deathTime > 0) {
            return;
        }
        super.setLastHurtByMob(livingBase);
    }

    public boolean canBeSeenAsEnemy() {
        return super.canBeSeenAsEnemy() && !this.playDeath();
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        if (this.isFlyingEntity() || this.getMoveControl() instanceof FlyingMoveControl) {
            return false;
        }
        return super.causeFallDamage(fallDistance, multiplier, source);
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getUUID().equals(this.getOwnerUUID()) && !player.isShiftKeyDown()) {
            return false;
        }
        if (this.getSpawnAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSpawnAnimation()})) {
            return false;
        }
        if (this.playDeath() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        return (source.getEntity() == null || this.canAttackFrom(source.getEntity().position())) && super.hurt(source, amount);
    }

    private boolean canAttackFrom(Vec3 pos) {
        boolean result;
        if (this.isTamed()) {
            return true;
        }
        boolean bl = result = this.getRestrictRadius() == -1.0f || this.getRestrictCenter().distToCenterSqr(pos.x(), pos.y(), pos.z()) < (double)(this.getRestrictRadius() * this.getRestrictRadius());
        if (!result) {
            this.level().playSound(null, (Entity)this, (SoundEvent)RuneCraftorySounds.ENTITY_ATTACK_BLOCKED.get(), this.getSoundSource(), 0.7f, 0.9f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 6; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, this.getRandomX(1.2), this.getRandomY(), this.getRandomZ(1.2), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return result;
    }

    protected void actuallyHurt(DamageSource source, float damageAmount) {
        DynamicDamage dmg;
        super.actuallyHurt(source, damageAmount);
        if (!this.isTamed() && source instanceof DynamicDamage && (dmg = (DynamicDamage)source).getEntity() instanceof Player && dmg.getElement() == ItemElement.LOVE) {
            this.loveAttCount = Math.min(100, this.loveAttCount + 1);
        }
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && this.isTamed() && this.getHealth() <= 0.0f) {
            this.setHealth(0.01f);
            this.setPlayDeath(true);
        }
    }

    @Override
    public boolean canBeAttackedBy(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob m = (Mob)entity;
            if (entity.getType().is(RunecraftoryTags.EntityTypes.TAMED_MONSTER_IGNORE) && this.getTarget() != m && m.getLastHurtByMob() != this) {
                return !this.isTamed();
            }
        }
        return true;
    }

    @Override
    public Predicate<LivingEntity> validTargetPredicate() {
        return this.hitPred;
    }

    public void die(DamageSource cause) {
        if (!this.level().isClientSide) {
            if (this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
                this.getOwner().displayClientMessage(this.getCombatTracker().getDeathMessage(), false);
            }
            if (this.getServer() != null && this.getOwnerUUID() != null) {
                RunecraftorySavedData.get(this.getServer()).removeMonsterFromPlayer(this.getOwnerUUID(), this);
                this.assignedBarn = null;
            }
            this.getAnimationHandler().setAnimation(null);
            List<CombatEntry> entries = ((CombatTrackerAccessor)this.getCombatTracker()).getEntries();
            HashMap merged = new HashMap();
            entries.forEach(e -> {
                Entity patt0$temp = e.source().getEntity();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    merged.compute(player.getUUID(), (id, o) -> o == null ? new CombatRecord(player, e.source(), e.damage()) : new CombatRecord(player, e.source(), o.totalDamage() + e.damage()));
                }
            });
            merged.values().forEach(rec -> this.onDeathDamageRecord(rec.player, rec.lastSource, rec.totalDamage));
            this.ejectPassengers();
        }
        super.die(cause);
    }

    protected void tickDeath() {
        if (!this.level().isClientSide && this.deathTime == 0) {
            this.playDeathAnimation(false);
            this.getNavigation().stop();
        }
        ++this.deathTime;
        if (this.deathTime == this.maxDeathTime() - 5 && !this.level().isClientSide && this.getLastHurtByMob() != null) {
            LevelCalc.addXP(this.getLastHurtByMob(), this.baseXP(), this.baseMoney(), this.xpLevel().getLevel());
        }
        if (this.deathTime >= this.maxDeathTime()) {
            for (int i = 0; i < 20; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)ParticleTypes.POOF).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02)).add(this.level(), this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0));
            }
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void onDeathDamageRecord(ServerPlayer player, DamageSource source, float damage) {
        if ((double)damage > (double)this.getMaxHealth() * 0.05) {
            Platform.INSTANCE.getPlayerData((Player)player).increaseMobFrom(this);
        }
    }

    protected void playDeathAnimation(boolean load) {
        if (this.getDeathAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getDeathAnimation());
            if (load && this.level().isClientSide) {
                AnimationState anim = this.getAnimationHandler().getAnimation();
                while (!anim.done(0)) {
                    anim.tick();
                }
            }
        }
    }

    public int maxDeathTime() {
        return 20;
    }

    public String getDeathAnimation() {
        return null;
    }

    public int deathRays() {
        return 0;
    }

    public double deathRayOffset() {
        return (double)this.getBbHeight() * 0.15;
    }

    public boolean playDeath() {
        return (Boolean)this.entityData.get(PLAY_DEATH_STATE);
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public void setPlayDeath(boolean flag) {
        this.entityData.set(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
                this.getOwner().displayClientMessage(this.getKnockoutMessage(), false);
            }
            this.level().getEntities(EntityTypeTest.forClass(Mob.class), this.getBoundingBox().inflate(32.0), e -> this.equals(e.getTarget())).forEach(m -> BrainUtils.setTargetOfEntity((LivingEntity)m, null));
            this.getNavigation().stop();
            this.playDeathAnimation(false);
            this.setMovingFlag(MoveType.NONE);
            this.setShiftKeyDown(false);
            this.setSprinting(false);
            this.unRide();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private Component getKnockoutMessage() {
        DamageSource source = this.getLastDamageSource();
        if (source != null && source.getEntity() != null) {
            return Component.translatable((String)"runecraftory.tamed.monster.knockout.by", (Object[])new Object[]{this.getDisplayName(), this.blockPosition().getX(), this.blockPosition().getY(), this.blockPosition().getZ(), source.getEntity().getDisplayName()});
        }
        return Component.translatable((String)"runecraftory.tamed.monster.knockout", (Object[])new Object[]{this.getDisplayName(), this.blockPosition().getX(), this.blockPosition().getY(), this.blockPosition().getZ()});
    }

    public boolean doStartRide(ServerPlayer player) {
        if (this.rideable()) {
            player.startRiding((Entity)this);
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"runecraftory.monster.interact.ride.no"), false);
        return false;
    }

    protected void addPassenger(Entity passenger) {
        this.getNavigation().stop();
        this.setDeltaMovement(Vec3.ZERO);
        this.setYya(0.0f);
        this.setZza(0.0f);
        this.setXxa(0.0f);
        BrainUtils.setTargetOfEntity((LivingEntity)this, null);
        super.addPassenger(passenger);
    }

    protected void removePassenger(Entity passenger) {
        if (passenger == this.getOwner()) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        super.removePassenger(passenger);
    }

    @Override
    public boolean rideable() {
        return this.prop.rideable;
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isTamed() && this.rideable()) {
                return player;
            }
            return null;
        }
        return super.getControllingPassenger();
    }

    @Override
    public TagKey<Item> tamingItem() {
        return RunecraftoryTags.tamingTag(this.getType());
    }

    @Override
    public float tamingChance() {
        return this.prop.tamingChance;
    }

    @Override
    public boolean isTamed() {
        return this.getOwnerUUID() != null;
    }

    protected void tameEntity(Player owner) {
        if (!this.isAlive()) {
            return;
        }
        this.restrictTo(this.blockPosition(), -1);
        this.setOwner(owner);
        this.navigation.stop();
        BrainUtils.setTargetOfEntity((LivingEntity)this, null);
        this.level().broadcastEntityEvent((Entity)this, (byte)10);
        this.updater.setLastUpdateDay(WorldUtils.day(this.level()));
        if (Platform.INSTANCE.getPlayerData((Player)owner).party.isPartyFull()) {
            this.setBehaviour(Behaviour.WANDER);
        } else {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        this.level().getEntities(EntityTypeTest.forClass(Mob.class), this.getBoundingBox().inflate(32.0), e -> {
            if (e == this) return false;
            if (!(e instanceof OwnableEntity)) return false;
            OwnableEntity ownable = (OwnableEntity)e;
            if (!this.getOwnerUUID().equals(ownable.getOwnerUUID())) return false;
            if (e.getTarget() != this) return false;
            return true;
        }).forEach(e -> {
            BrainUtils.setTargetOfEntity((LivingEntity)e, null);
            if (e.getLastHurtByMob() == this) {
                e.setLastHurtByMob(null);
            }
        });
        this.setLastHurtByMob(null);
        if (owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)serverPlayer);
            data.entityStatsTracker.tameEntity(this);
            ((TameMonsterTrigger)((Object)RuneCraftoryCriteria.TAME_MONSTER_TRIGGER.get())).trigger(serverPlayer, this, data.entityStatsTracker);
            LevelCalc.levelSkill(data, Skills.TAMING, 10.0f);
            QuestHandler.getData(serverPlayer).trigger(TamingTracker.KEY, this);
        }
        if (this.getServer() != null) {
            this.assignBarn();
        }
    }

    protected float tamingMultiplier(ItemStack stack) {
        boolean flag = stack.is(this.tamingItem());
        return flag ? 2.0f : 1.0f;
    }

    protected void untameEntity() {
        this.level().getEntities(EntityTypeTest.forClass(Mob.class), this.getBoundingBox().inflate(32.0), e -> e != this && e.getTarget() == this).forEach(e -> {
            BrainUtils.setTargetOfEntity((LivingEntity)e, null);
            if (e.getLastHurtByMob() == this) {
                e.setLastHurtByMob(null);
            }
        });
        if (this.getServer() != null && this.getOwnerUUID() != null) {
            RunecraftorySavedData.get(this.getServer()).removeMonsterFromPlayer(this.getOwnerUUID(), this);
            if (this.getOwner() != null) {
                Platform.INSTANCE.getPlayerData((Player)this.getOwner()).party.removePartyMember((Entity)this);
            } else {
                RunecraftorySavedData.get(this.getServer()).toRemovePartyMember((LivingEntity)this);
            }
            this.assignedBarn = null;
        }
        this.setOwner(null);
        this.setLastHurtByMob(null);
        if (this.playDeath()) {
            this.heal(this.getMaxHealth());
        }
        this.setBehaviour(Behaviour.WANDER);
        this.updateAI(true, false);
        BrainUtils.setTargetOfEntity((LivingEntity)this, null);
        this.getNavigation().stop();
    }

    private void playTameEffect(boolean play) {
        SimpleParticleType particle = ParticleTypes.HEART;
        int amount = 13;
        if (!play) {
            particle = ParticleTypes.SMOKE;
            amount += 9;
        }
        for (int i = 0; i < amount; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particle, true, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d0, d2, d3);
        }
    }

    private boolean findNearestBarn(boolean load) {
        if (load) {
            return this.assignBarn();
        }
        BarnData nearest = RunecraftorySavedData.get(this.getServer()).findNearestFittingBarn(this, 5);
        if (nearest != null) {
            if (this.assignedBarn != null && this.assignedBarn != nearest) {
                this.assignedBarn.removeMonster(this);
            }
            this.assignedBarn = nearest;
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return this.assignBarn();
    }

    public BarnData getAssignedBarn() {
        this.assignBarn();
        return this.assignedBarn;
    }

    private boolean assignBarn() {
        if (!this.isAlive()) {
            return false;
        }
        if (this.assignedBarn == null || this.assignedBarn.isInvalidFor(this)) {
            this.assignedBarn = RunecraftorySavedData.get(this.getServer()).findFittingBarn(this);
        }
        if (this.assignedBarn != null) {
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return false;
    }

    public BlockPos getSeedInventory() {
        if (this.seedInventory != null && !this.isWithinRestriction(this.seedInventory)) {
            return null;
        }
        return this.seedInventory;
    }

    public void setSeedInventory(BlockPos seedInventory) {
        this.seedInventory = seedInventory;
    }

    public BlockPos getCropInventory() {
        if (this.cropInventory != null && !this.isWithinRestriction(this.cropInventory)) {
            return null;
        }
        return this.cropInventory;
    }

    public void setCropInventory(BlockPos cropInventory) {
        this.cropInventory = cropInventory;
    }

    private BlockPos nearestBlockEntityWithInv() {
        BlockPos blockPos = this.getRestrictCenter();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int radius = (int)this.getRestrictRadius();
        for (int y = -1; y < 2; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutableBlockPos.setWithOffset((Vec3i)blockPos, x, y, z);
                    if (!Platform.INSTANCE.matchingInventory(this.level().getBlockEntity((BlockPos)mutableBlockPos), s -> true)) continue;
                    return mutableBlockPos.immutable();
                }
            }
        }
        return null;
    }

    public String getInteractAnimation() {
        return null;
    }

    public void runInteractHandling(Runnable runnable) {
        if (this.getInteractAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getInteractAnimation());
            this.scheduledAnimationHandling = Pair.of((Object)this.getInteractAnimation(), (Object)runnable);
        } else {
            runnable.run();
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean clientSide = this.level().isClientSide;
        ItemStack stack = player.getItemInHand(hand);
        if (this.isTamed()) {
            if (!player.getUUID().equals(this.getOwnerUUID())) {
                if (!clientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"runecraftory.monster.interact.notowner"), false);
                }
                return InteractionResult.sidedSuccess((boolean)clientSide);
            }
            if (player.isShiftKeyDown() && stack.getItem() == Items.STICK) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EntityUtils.playSoundForPlayer(serverPlayer, (SoundEvent)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
                    this.untameEntity();
                }
                return InteractionResult.sidedSuccess((boolean)clientSide);
            }
            if (!clientSide && MobConfig.monsterNeedBarn && this.assignedBarn == null && !this.assignBarn()) {
                player.displayClientMessage((Component)Component.translatable((String)"runecraftory.monster.interact.barn.no", (Object[])new Object[]{this.getDisplayName()}), false);
                return InteractionResult.CONSUME;
            }
            if (stack.getItem() == RuneCraftoryItems.BRUSH.get()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int day = WorldUtils.day(this.level());
                    if (this.updater.getLastUpdateBrush() == day) {
                        return InteractionResult.PASS;
                    }
                    EntityUtils.playSoundForPlayer(serverPlayer, (SoundEvent)RuneCraftorySounds.PLAYER_BRUSH.get(), SoundSource.NEUTRAL, 0.7f, 1.0f);
                    this.updater.setLastUpdateBrush(day);
                    this.onBrushing();
                    this.increaseFriendPoints(15);
                    this.level().broadcastEntityEvent((Entity)this, (byte)64);
                    player.swing(hand);
                }
                return InteractionResult.sidedSuccess((boolean)clientSide);
            }
            if (hand == InteractionHand.MAIN_HAND && !this.playDeath() && player.isShiftKeyDown()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EntityUtils.sendAttributesTo((LivingEntity)this, serverPlayer);
                    LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2COpenCompanionGui(this, serverPlayer), serverPlayer);
                }
                return InteractionResult.sidedSuccess((boolean)clientSide);
            }
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown() && !stack.isEmpty()) {
            if (stack.getItem() == RuneCraftoryItems.TAME.get()) {
                if (!clientSide) {
                    this.tameEntity(player);
                }
                return InteractionResult.sidedSuccess((boolean)clientSide);
            }
            if (stack.getItem() == RuneCraftoryItems.BRUSH.get() && this.isAlive()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (this.tamingTick == -1) {
                        return InteractionResult.PASS;
                    }
                    EntityUtils.playSoundForPlayer(serverPlayer, (SoundEvent)RuneCraftorySounds.PLAYER_BRUSH.get(), SoundSource.NEUTRAL, 0.7f, 1.0f);
                    this.brushCount = Math.min(10, this.brushCount + 1);
                    this.tamingTick = 40;
                    this.level().broadcastEntityEvent((Entity)this, (byte)64);
                }
                return InteractionResult.sidedSuccess((boolean)clientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public void onBrushing() {
        Holder toIncrease = switch (this.random.nextInt(4)) {
            case 1 -> RuneCraftoryAttributes.DEFENCE.asHolder();
            case 2 -> RuneCraftoryAttributes.MAGIC_ATTACK.asHolder();
            case 3 -> RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder();
            default -> Attributes.ATTACK_DAMAGE;
        };
        AttributeInstance inst = this.getAttribute(toIncrease);
        if (inst != null) {
            AttributeModifier mod = inst.getModifier(LibConstants.MONSTER_BRUSH_MODIFIER);
            double inc = 1.0;
            if (mod != null) {
                inc += mod.amount();
            }
            inst.removeModifier(LibConstants.MONSTER_BRUSH_MODIFIER);
            inst.addPermanentModifier(new AttributeModifier(LibConstants.MONSTER_BRUSH_MODIFIER, inc, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    @Override
    public XpLevelHolder xpLevel() {
        return this.levelPair;
    }

    @Override
    public void setXPLevel(int level) {
        this.levelPair.setLevel(Mth.clamp((int)level, (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void increaseLevel() {
        this.levelPair.setLevel(Mth.clamp((int)(this.xpLevel().getLevel() + 1), (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        XpLevelHolder pair = this.xpLevel();
        boolean res = pair.addXP(amount, 10000, LevelCalc::xpAmountForLevelUp, () -> {});
        LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)S2CEntityLevelPkt.create(this), (Entity)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateStatsToLevel() {
        if (!this.level().isClientSide) {
            LoaderNetwork.INSTANCE.sendToTracking((CustomPacketPayload)S2CEntityLevelPkt.create(this), (Entity)this);
        }
        float preHealthDiff = this.getMaxHealth() - this.getHealth();
        this.prop.levelGains().forEach((att, val) -> {
            AttributeInstance inst = this.getAttribute((Holder)att);
            if (inst != null) {
                val = val * 0.01;
                inst.removeModifier(LibConstants.MONSTER_LEVEL_MODIFIER);
                float multiplier = 1.0f;
                multiplier = att == Attributes.MAX_HEALTH ? (multiplier += LevelCalc.getMultiplierInterval(this.xpLevel().getLevel(), 20, 30.0f, 0.15f) * 0.02f) : (multiplier += LevelCalc.getMultiplierInterval(this.xpLevel().getLevel(), 20, 30.0f, 0.0f) * 0.015f);
                inst.addPermanentModifier(new AttributeModifier(LibConstants.MONSTER_LEVEL_MODIFIER, (double)(this.xpLevel().getLevel() - 1) * val * (double)multiplier, AttributeModifier.Operation.ADD_VALUE));
                if (att == Attributes.MAX_HEALTH) {
                    this.setHealth(this.getMaxHealth() - preHealthDiff);
                }
            }
        });
    }

    @Override
    public int friendPoints(UUID player) {
        if (player.equals(this.getOwnerUUID())) {
            return (Integer)this.entityData.get(FRIEND_POINTS_SYNC);
        }
        return 0;
    }

    public void increaseFriendPoints(int xp) {
        boolean leveledUp = this.friendlyPoints.addXP(xp, 10, LevelCalc::friendPointsForNext, () -> this.entityData.set(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel()));
        if (leveledUp) {
            this.updateFriendPointAttributeBonus();
        }
    }

    private void updateFriendPointAttributeBonus() {
        List<Holder> increasable = List.of(Attributes.MAX_HEALTH, Attributes.ATTACK_DAMAGE, RuneCraftoryAttributes.DEFENCE.asHolder(), RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
        for (Holder att : increasable) {
            AttributeInstance inst = this.getAttribute(att);
            if (inst == null) continue;
            double inc = (double)(this.friendlyPoints.getLevel() - 1) * 0.03;
            inst.removeModifier(LibConstants.FRIENDSHIP_MODIFIER);
            inst.addPermanentModifier(new AttributeModifier(LibConstants.FRIENDSHIP_MODIFIER, inc, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }

    public void recalcStatsFull() {
        this.applyAttributes();
        this.updateStatsToLevel();
        this.updateFriendPointAttributeBonus();
    }

    @Override
    public int baseXP() {
        return this.prop.xp;
    }

    @Override
    public int baseMoney() {
        return this.prop.money;
    }

    @Override
    public boolean isFlyingEntity() {
        return this.prop.flying;
    }

    public void onDailyUpdate() {
        if (this.level() instanceof ServerLevel && this.isTamed() && !this.playDeath() && (!MobConfig.monsterNeedBarn || this.assignBarn())) {
            ResourceKey<LootTable> resourceLocation = this.dailyDropTable();
            this.dropAsDailyDrop(resourceLocation);
        }
    }

    public ResourceKey<LootTable> dailyDropTable() {
        ResourceKey def = this.getDefaultLootTable();
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)def.location().getNamespace(), (String)(def.location().getPath() + "_tamed_drops")));
    }

    protected void dropAsDailyDrop(ResourceKey<LootTable> resourceLocation) {
        LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(resourceLocation);
        lootTable.getRandomItems(this.dailyDropContext().create(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((BaseMonster)this).spawnAtLocation(arg_0));
    }

    protected LootParams.Builder dailyDropContext() {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position());
        if (this.getOwnerUUID() != null) {
            builder.withOptionalParameter(LootCtxParameters.UUID_CONTEXT, (Object)this.getOwnerUUID());
        }
        return builder;
    }

    protected void populateDefaultEquipmentSlots(RandomSource source, DifficultyInstance difficulty) {
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        this.setXPLevel(Mth.clamp((int)this.xpLevel().getLevel(), (int)this.prop.minLevel, (int)10000));
        if (this.getSpawnAnimation() != null && reason != MobSpawnType.COMMAND && reason != MobSpawnType.DISPENSER) {
            this.getAnimationHandler().setAnimation(this.getSpawnAnimation());
        }
        return spawnData;
    }

    public String getSpawnAnimation() {
        return null;
    }

    public float getScale() {
        return super.getScale() * this.defaultScale;
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTamed();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.isTamed();
    }

    public void startSeenByPlayer(ServerPlayer player) {
        LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)S2CEntityLevelPkt.create(this), player);
    }

    public void setLevelCallback(EntityInLevelCallback levelCallback) {
        super.setLevelCallback(WorldUtils.wrappedCallbackFor(this, this::getOwner, levelCallback));
    }

    @Override
    public boolean onGivingItem(Player player, ItemStack stack) {
        if (this.isTamed()) {
            if (!player.getUUID().equals(this.getOwnerUUID())) {
                return false;
            }
            if (this.hasPassenger((Entity)player)) {
                return false;
            }
            if (this.feedTimeOut <= 0) {
                boolean favorite = stack.is(this.tamingItem());
                int count = stack.getCount();
                SoundEvent sound = switch (stack.getUseAnimation()) {
                    case UseAnim.DRINK -> stack.getDrinkingSound();
                    case UseAnim.EAT -> stack.getEatingSound();
                    default -> (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value();
                };
                boolean food = this.applyFoodEffect(stack);
                if (food || !this.playDeath()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        EntityUtils.playSoundForPlayer(serverPlayer, sound, SoundSource.NEUTRAL, 0.7f, 1.0f);
                        Platform.INSTANCE.getPlayerData((Player)serverPlayer).getDailyUpdater().onGiveMonsterItem();
                    }
                    stack.setCount(count);
                    this.feedTimeOut = 7;
                    int day = WorldUtils.day(this.level());
                    if (this.updater.getLastUpdateFood() != day) {
                        this.updater.setLastUpdateFood(day);
                        this.increaseFriendPoints(favorite ? 50 : 30);
                        if (favorite) {
                            this.level().broadcastEntityEvent((Entity)this, (byte)65);
                        } else {
                            this.level().broadcastEntityEvent((Entity)this, (byte)64);
                        }
                        DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).ifPresent(s -> s.getMonsterGiftIncrease().forEach((att, d) -> {
                            AttributeInstance inst = this.getAttribute((Holder)att);
                            if (inst != null) {
                                AttributeModifier mod = inst.getModifier(LibConstants.SHIELD_PENALTY);
                                double val = d;
                                if (mod != null) {
                                    val += mod.amount();
                                    inst.removeModifier(mod);
                                }
                                inst.addPermanentModifier(new AttributeModifier(LibConstants.SHIELD_PENALTY, val, AttributeModifier.Operation.ADD_VALUE));
                            }
                        }));
                    }
                    stack.shrink(1);
                }
                return true;
            }
        } else if (this.tamingTick == -1 && this.isAlive()) {
            SoundEvent sound;
            switch (stack.getUseAnimation()) {
                case DRINK: {
                    SoundEvent soundEvent = stack.getDrinkingSound();
                    break;
                }
                case EAT: {
                    SoundEvent soundEvent = stack.getEatingSound();
                    break;
                }
                default: {
                    SoundEvent soundEvent = sound = (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value();
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EntityUtils.playSoundForPlayer(serverPlayer, sound, SoundSource.NEUTRAL, 0.7f, 1.0f);
            }
            float rightItemMultiplier = this.tamingMultiplier(stack);
            int count = stack.getCount();
            this.applyFoodEffect(stack);
            if (count == stack.getCount() && !player.isCreative()) {
                stack.shrink(1);
            }
            this.tamingTick = 60;
            float chance = EntityUtils.tamingChance(this, player, rightItemMultiplier, this.brushCount, this.loveAttCount);
            if (!(this.getServer() == null || MobConfig.monsterNeedBarn && RunecraftorySavedData.get(this.getServer()).findFittingBarn(this, player.getUUID()) == null)) {
                this.delayedTaming = () -> {
                    if (chance == 0.0f) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)34);
                    } else if (this.random.nextFloat() < chance) {
                        this.tameEntity(player);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)11);
                    }
                };
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyFoodEffect(ItemStack stack) {
        io.github.flemmli97.runecraftory.api.datapack.FoodProperties food;
        if (this.level().isClientSide) {
            return false;
        }
        if (stack.getItem() == RuneCraftoryItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((LivingEntity)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.getItem())) == null) {
            FoodProperties mcFood = (FoodProperties)stack.get(DataComponents.FOOD);
            this.eat(this.level(), stack);
            if (mcFood != null) {
                this.heal((float)mcFood.nutrition() * 0.5f);
                return true;
            }
            return false;
        }
        this.eat(this.level(), stack);
        Pair<Map<Holder<Attribute>, Double>, Map<Holder<Attribute>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            AttributeInstance inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.getAttribute((Holder)entry.getKey());
                if (inst == null) continue;
                inst.removeModifier(LibConstants.FOOD_MODIFIER_MULTI);
                inst.addPermanentModifier(new AttributeModifier(LibConstants.FOOD_MODIFIER_MULTI, ((Double)entry.getValue()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.getAttribute((Holder)entry.getKey());
                if (inst == null) continue;
                inst.removeModifier(LibConstants.FOOD_MODIFIER);
                inst.addPermanentModifier(new AttributeModifier(LibConstants.FOOD_MODIFIER, ((Double)entry.getValue()).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((LivingEntity)this, food.getHPGain());
        EntityUtils.foodHealing((LivingEntity)this, this.getMaxHealth() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (Holder holder : food.potionHeals()) {
                this.removeEffect(holder);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.addEffect(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.getAttributes()).getAttributes().values().forEach(inst -> {
            inst.removeModifier(LibConstants.FOOD_MODIFIER);
            inst.removeModifier(LibConstants.FOOD_MODIFIER_MULTI);
        });
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public Player getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            if (this.owner == null || !this.owner.isAlive()) {
                this.owner = this.level().isClientSide ? this.level().getPlayerByUUID(uuid) : this.level().getServer().getPlayerList().getPlayer(uuid);
            }
        } else {
            this.owner = null;
        }
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        if (player != null) {
            this.entityData.set(OWNER_UUID, Optional.of(player.getUUID()));
        } else {
            this.entityData.set(OWNER_UUID, Optional.empty());
        }
    }

    public void setSleepingPos(BlockPos pos) {
        super.setSleepingPos(pos);
        this.setSleeping(true);
    }

    public void clearSleepingPos() {
        super.clearSleepingPos();
        this.setSleeping(false);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.onSleeping(sleeping);
    }

    @Override
    public boolean hasSleepingAnimation() {
        return this.getSleepAnimation() != null;
    }

    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            if (this.getSleepAnimation() != null) {
                this.getAnimationHandler().setAnimation(this.getSleepAnimation());
                if (this.firstTick && this.level().isClientSide) {
                    AnimationState anim = this.getAnimationHandler().getAnimation();
                    while (!anim.done(0)) {
                        anim.tick();
                    }
                }
            }
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    public String getSleepAnimation() {
        return null;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public static enum Behaviour {
        WANDER("runecraftory.monster.interact.wander", false),
        WANDER_HOME("runecraftory.monster.interact.home", false),
        FOLLOW("runecraftory.monster.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.monster.interact.follow.distance", true),
        STAY("runecraftory.monster.interact.stay", true),
        FARM("runecraftory.monster.interact.farm", false);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }

    public record CombatRecord(ServerPlayer player, DamageSource lastSource, float totalDamage) {
    }
}

