/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class AppleProjectileEntity
extends BaseProjectile {
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(AppleProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private boolean circling;
    private int angleOffset;
    private int circleTime;

    public AppleProjectileEntity(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public AppleProjectileEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.APPLE.get()), level, shooter);
    }

    public void setAngleOffset(int angleOffset) {
        this.angleOffset = angleOffset;
    }

    public void setCircling(boolean circling, int circleTime) {
        this.circling = circling;
        this.circleTime = circleTime;
    }

    public void withSizeInc(float size) {
        this.entityData.set(SCALE, (Object)Float.valueOf(size));
    }

    public int livingTickMax() {
        return 300;
    }

    public float radius() {
        return this.getBbWidth() * this.getScale();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
    }

    public float getScale() {
        return Math.max(0.2f, ((Float)this.entityData.get(SCALE)).floatValue());
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            --this.circleTime;
            if (this.circling && this.getOwner() != null) {
                Entity owner = this.getOwner();
                if (this.circleTime > 0) {
                    Vec3 ownerPos = owner.position();
                    Vec3 pos = new Vec3((double)owner.getBbWidth() + 0.5, 0.0, 0.0).yRot((float)(13 * this.livingTicks + this.angleOffset));
                    this.setDeltaMovement(ownerPos.x + pos.x() - this.getX(), ownerPos.y + (double)this.getOwner().getEyeHeight() - 0.2 - this.getY(), ownerPos.z + pos.z() - this.getZ());
                    this.hasImpulse = true;
                    this.checkedEntities.clear();
                } else if (this.circleTime == 0) {
                    Mob mob;
                    if (owner instanceof Mob && (mob = (Mob)owner).getTarget() != null) {
                        this.shootAtEntity((Entity)mob.getTarget(), 1.0f, 0.0f);
                    } else {
                        this.shoot(owner, owner.getXRot(), owner.getYRot(), -5.0f, 1.0f, 0.0f);
                    }
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return this.circling ? 0.002f : super.getGravityVelocity();
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback().hurtResistant(4).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null)) {
            this.discard();
            return true;
        }
        return false;
    }

    protected void onBlockHit(BlockHitResult result) {
        if (!this.circling || this.circleTime < 0) {
            this.discard();
        }
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.isAlive()) {
            return null;
        }
        if (this.attackedEntities.isEmpty()) {
            OrientedBoundingBox obb = new OrientedBoundingBox(new AABB((double)(-this.radius()), (double)(-this.radius()), (double)(-this.radius()), (double)this.radius(), (double)this.radius(), (double)this.radius()).expandTowards(to.subtract(from)), 0.0f, 0.0f, this.position());
            List list = this.level().getEntities((Entity)this, obb.getEncompassingBox());
            for (Entity e : list) {
                if (!this.canHit(e) || !obb.intersects(e.getBoundingBox())) continue;
                AABB outer = obb.getEncompassingBox();
                Vec3 hit = new Vec3(Mth.clamp((double)e.position().x, (double)outer.minX, (double)outer.maxX), Mth.clamp((double)e.position().y, (double)outer.minY, (double)outer.maxY), Mth.clamp((double)e.position().z, (double)outer.minZ, (double)outer.maxZ));
                return new EntityHitResult(e, hit);
            }
            return null;
        }
        return null;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.circling = compound.getBoolean("Circling");
        this.circleTime = compound.getInt("CirclingTime");
        this.angleOffset = compound.getInt("AngleOffset");
        this.withSizeInc(compound.contains("Scale") ? compound.getFloat("Scale") : 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Circling", this.circling);
        compound.putInt("CirclingTime", this.circleTime);
        compound.putInt("AngleOffset", this.angleOffset);
        compound.putFloat("Scale", ((Float)this.entityData.get(SCALE)).floatValue());
    }
}

