/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class BaseProjectile
extends AdvancedProjectile {
    private Predicate<LivingEntity> pred = e -> !e.getUUID().equals(this.getOwnerUUID());
    protected float damageMultiplier = 1.0f;

    public BaseProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public BaseProjectile(EntityType<? extends BaseProjectile> type, Level level, double x, double y, double z) {
        super(type, level, x, y, z);
    }

    public BaseProjectile(EntityType<? extends BaseProjectile> type, Level level, LivingEntity shooter) {
        super(type, level, shooter);
        if (shooter instanceof TargetableOpponent) {
            TargetableOpponent targetableOpponent = (TargetableOpponent)shooter;
            this.pred = targetableOpponent.validTargetPredicate();
        }
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    protected boolean canHit(Entity entity) {
        return (!(entity instanceof LivingEntity) || this.pred == null || this.pred.test((LivingEntity)entity)) && super.canHit(entity);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damageMultiplier = compound.getFloat("DamageMultiplier");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("DamageMultiplier", this.damageMultiplier);
    }

    public Entity getOwner() {
        Entity owner = super.getOwner();
        if (owner instanceof TargetableOpponent) {
            TargetableOpponent targetableOpponent = (TargetableOpponent)owner;
            this.pred = targetableOpponent.validTargetPredicate();
        }
        return owner;
    }
}

