/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class BulletEntity
extends BaseProjectile {
    private static final float[] SIN_POINTS = BulletEntity.calcSinPoints();
    private static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.defineId(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemElement element = ItemElement.NONE;
    private boolean straight;
    private boolean reverse;
    private Vec3 dir;
    private Vec3 side;

    public BulletEntity(EntityType<? extends BulletEntity> type, Level level) {
        super(type, level);
    }

    public BulletEntity(Level level, LivingEntity thrower) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.CIRCLING_BULLET.get()), level, thrower);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = Mth.cos((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ELEMENT_DATA, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = ItemElement.values()[(Integer)this.entityData.get(ELEMENT_DATA)];
        }
        super.onSyncedDataUpdated(key);
    }

    public void setElement(ItemElement element) {
        this.element = element;
        this.entityData.set(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public ItemElement element() {
        return this.element;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
        Vec3 up = this.calculateUpVector(-this.getViewXRot(1.0f), -this.getViewYRot(1.0f)).normalize();
        this.dir = this.getDeltaMovement();
        Vector3d rot = new Vector3d(this.dir.x(), this.dir.y(), this.dir.z()).rotateAxis(1.5707963705062866, up.x(), up.y(), up.z());
        this.side = new Vec3(rot.x(), rot.y(), rot.z()).normalize();
    }

    public void reverseMovement() {
        this.reverse = !this.reverse;
    }

    public void setStraight() {
        this.straight = true;
    }

    public int livingTickMax() {
        return this.straight ? 20 : 50;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && !this.straight && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = this.reverse ? -SIN_POINTS[t] : SIN_POINTS[t] * 2.0f;
            this.setDeltaMovement(this.dir.x + this.side.x * (double)sT, this.dir.y + this.side.y * (double)sT, this.dir.z + this.side.z * (double)sT);
            this.hasImpulse = true;
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean res = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(4).element(this.element).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
        if (res) {
            this.discard();
        }
        return res;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.discard();
    }
}

