/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class DarkBallEntity
extends BaseDamageCloud {
    private static final float[] SIN_POINTS = DarkBallEntity.calcSinPoints();
    private Type type = Type.BALL;
    private Vec3 dir;
    private Vec3 side;

    public DarkBallEntity(EntityType<? extends DarkBallEntity> type, Level level) {
        super(type, level);
    }

    public DarkBallEntity(Level level, LivingEntity thrower, Type type) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.DARK_BALL.get()), level, thrower);
        this.setPos(this.getX(), this.getY() + (double)thrower.getBbHeight() * 0.5, this.getZ());
        this.type = type;
        this.setRadius(1.5f);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = Mth.cos((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    public void shootAtPos(Vec3 targetPos, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(targetPos.x() - this.getX(), targetPos.y() - this.getY(), targetPos.z() - this.getZ());
        this.shoot(dir.x, dir.y, dir.z, velocity, inaccuracy);
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 throwerMotion = entityThrower.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(throwerMotion.x, entityThrower.onGround() ? 0.0 : throwerMotion.y, throwerMotion.z));
        this.getDeltaMovement().add(throwerMotion.x, 0.0, throwerMotion.z);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((Vec3)vector3d));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        Vec3 up = this.calculateUpVector(-this.getViewXRot(1.0f), -this.getViewYRot(1.0f)).normalize();
        this.dir = this.getDeltaMovement();
        Vector3d rot = new Vector3d(this.dir.x(), this.dir.y(), this.dir.z()).rotateAxis(1.5707963705062866, up.x(), up.y(), up.z());
        this.side = new Vec3(rot.x(), rot.y(), rot.z()).normalize();
    }

    public int livingTickMax() {
        return this.type == Type.BALL ? 100 : 60;
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        double newX = this.getX() + motion.x;
        double newY = this.getY() + motion.y;
        double newZ = this.getZ() + motion.z;
        this.setPos(newX, newY, newZ);
        if (this.level().isClientSide) {
            int i;
            for (i = 0; i < 5; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.25490198f, 0.007843138f, 0.4117647f, 0.2f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.03), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.6f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getRandomX(1.0), this.getY(this.getRandom().nextDouble() * 0.5) + (double)this.getBbHeight() * 0.4, this.getRandomZ(1.0));
            }
            for (i = 0; i < 3; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.6666667f, 0.3647059f, 0.83137256f, 0.2f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.03), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.6f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getRandomX(1.0), this.getY(this.getRandom().nextDouble() * 0.5) + (double)this.getBbHeight() * 0.4, this.getRandomZ(1.0));
            }
        } else if (this.type == Type.SNAKE && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = SIN_POINTS[t];
            this.setDeltaMovement(this.dir.x + this.side.x * (double)sT, this.dir.y + this.side.y * (double)sT, this.dir.z + this.side.z * (double)sT);
            this.hasImpulse = true;
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(10).element(ItemElement.DARK), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        try {
            this.type = Type.valueOf(compound.getString("Type"));
        }
        catch (IllegalArgumentException e) {
            this.type = Type.BALL;
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Type", this.type.toString());
    }

    public static enum Type {
        BALL,
        SNAKE;

    }
}

