/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ElementalBallEntity
extends BaseProjectile {
    protected static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.defineId(ElementalBallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(ElementalBallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemElement element = ItemElement.NONE;
    private int maxLivingTicks = 6;

    public ElementalBallEntity(EntityType<? extends ElementalBallEntity> type, Level level) {
        super(type, level);
    }

    public ElementalBallEntity(Level level, LivingEntity shooter, ItemElement element) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.ELEMENTAL_BALL.get()), level, shooter);
        this.element = element;
        this.entityData.set(ELEMENT_DATA, (Object)this.element.ordinal());
        this.damageMultiplier = 0.8f;
    }

    public ItemElement getElement() {
        return this.element;
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void withMaxLivingTicks(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public float radius() {
        return 0.5f;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        int i;
        super.onSyncedDataUpdated(key);
        if (key == ELEMENT_DATA && (i = ((Integer)this.entityData.get(ELEMENT_DATA)).intValue()) < ItemElement.values().length) {
            this.element = ItemElement.values()[i];
        }
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ELEMENT_DATA, (Object)0);
        builder.define(VARIANT, (Object)0);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().element(this.element).hurtResistant(5), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.discard();
        this.playHitSound();
        return att;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.discard();
        this.playHitSound();
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(ELEMENT_DATA, (Object)compound.getInt("Element"));
        this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
        this.maxLivingTicks = compound.getInt("MaxLivingTicks");
        int i = (Integer)this.entityData.get(ELEMENT_DATA);
        if (i < ItemElement.values().length) {
            this.element = ItemElement.values()[i];
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Element", this.element.ordinal());
        compound.putInt("Variant", ((Integer)this.entityData.get(VARIANT)).intValue());
        compound.putInt("MaxLivingTicks", this.maxLivingTicks);
    }

    protected void playHitSound() {
        if (this.element == ItemElement.WATER) {
            SoundEvent event = this.getVariant() == 1 ? (SoundEvent)SoundEvents.GENERIC_EXPLODE.value() : (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_WATER.get();
            this.playSound(event, this.getVariant() == 1 ? 0.9f : 0.35f, 1.0f);
        }
    }
}

