/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElementalTrailEntity
extends BaseDamageCloud {
    private static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.defineId(ElementalTrailEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> STATIONARY = SynchedEntityData.defineId(ElementalTrailEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemElement element = ItemElement.NONE;
    private boolean piercing = true;
    private boolean hasKnockback;
    private boolean homing;
    private LivingEntity targetMob;
    private int livingTicksMax = 100;

    public ElementalTrailEntity(EntityType<? extends ElementalTrailEntity> type, Level level) {
        super(type, level);
    }

    public ElementalTrailEntity(Level level, LivingEntity thrower, ItemElement element) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.ELEMENTAL_TRAIL.get()), level, thrower);
        this.setPos(this.getX(), this.getY() + (double)thrower.getBbHeight() * 0.5, this.getZ());
        this.setElement(element);
        this.setRadius(0.5f);
    }

    public void shootAtEntity(Vec3 targetPos, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(targetPos.x() - this.getX(), targetPos.y() - this.getY(), targetPos.z() - this.getZ());
        this.shoot(dir.x, dir.y, dir.z, velocity, inaccuracy);
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 throwerMotion = entityThrower.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(throwerMotion.x, entityThrower.onGround() ? 0.0 : throwerMotion.y, throwerMotion.z));
        this.getDeltaMovement().add(throwerMotion.x, 0.0, throwerMotion.z);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((Vec3)vector3d));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void setElement(ItemElement element) {
        this.element = element;
        this.entityData.set(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public ItemElement element() {
        return this.element;
    }

    public void setStationary(boolean stationary) {
        this.entityData.set(STATIONARY, (Object)stationary);
    }

    public void setPiercing(boolean piercing) {
        this.piercing = piercing;
    }

    public void knockback() {
        this.hasKnockback = true;
    }

    public void homing() {
        this.homing = true;
    }

    public void withMaxLiving(int livingTicksMax) {
        this.livingTicksMax = livingTicksMax;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = ItemElement.values()[(Integer)this.entityData.get(ELEMENT_DATA)];
        }
        super.onSyncedDataUpdated(key);
    }

    public int livingTickMax() {
        return this.livingTicksMax;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ELEMENT_DATA, (Object)0);
        builder.define(STATIONARY, (Object)false);
    }

    public void tick() {
        super.tick();
        if (!((Boolean)this.entityData.get(STATIONARY)).booleanValue()) {
            Vec3 motion = this.getDeltaMovement();
            double newX = this.getX() + motion.x;
            double newY = this.getY() + motion.y;
            double newZ = this.getZ() + motion.z;
            this.setPos(newX, newY, newZ);
        }
        if (!this.level().isClientSide) {
            if (this.homing) {
                if (this.targetMob == null || this.targetMob.isDeadOrDying()) {
                    this.targetMob = EntityUtils.ownedProjectileTarget(this.getOwner(), 10);
                } else {
                    Vec3 dir = this.targetMob.position().subtract(this.position());
                    if (dir.lengthSqr() > 0.0484) {
                        dir = dir.normalize().scale(0.22);
                    }
                    this.setDeltaMovement(dir);
                    this.hasImpulse = true;
                }
            }
        } else if (this.livingTicks % 2 == 0) {
            if (this.element == ItemElement.WATER) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)RuneCraftorySounds.ENTITY_ELEMENTAL_TRAIL_WATER.get(), this.getSoundSource(), 0.7f, 0.8f, false);
            }
            if (this.element == ItemElement.EARTH) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)RuneCraftorySounds.ENTITY_ELEMENTAL_TRAIL_EARTH.get(), this.getSoundSource(), 1.0f, 0.8f, false);
            }
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(10).element(this.element), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            if (this.hasKnockback) {
                target.knockback(0.5, this.getX() - target.getX(), this.getZ() - target.getZ());
            }
            if (!this.piercing) {
                this.discard();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        try {
            this.setElement(ItemElement.values()[compound.getInt("Element")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.entityData.set(STATIONARY, (Object)compound.getBoolean("Stationary"));
        this.piercing = compound.getBoolean("Piercing");
        this.hasKnockback = compound.getBoolean("Knockback");
        this.homing = compound.getBoolean("Homing");
        this.livingTicksMax = compound.getInt("LivingTicksMax");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Element", this.element.ordinal());
        compound.putBoolean("Stationary", ((Boolean)this.entityData.get(STATIONARY)).booleanValue());
        compound.putBoolean("Piercing", this.piercing);
        compound.putBoolean("Knockback", this.hasKnockback);
        compound.putBoolean("Homing", this.homing);
        compound.putInt("LivingTicksMax", this.livingTicksMax);
    }
}

