/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class FireballEntity
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> BIG = SynchedEntityData.defineId(FireballEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public FireballEntity(EntityType<? extends FireballEntity> type, Level level) {
        super(type, level);
    }

    public FireballEntity(Level level, LivingEntity shooter, boolean big) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.FIRE_BALL.get()), level, shooter);
        this.entityData.set(BIG, (Object)big);
    }

    public boolean big() {
        return (Boolean)this.entityData.get(BIG);
    }

    public int livingTickMax() {
        return 30;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BIG, (Object)false);
    }

    protected float getGravityVelocity() {
        return 0.0025f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().element(ItemElement.FIRE).hurtResistant(4), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.level().playSound(null, result.getEntity().blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 1.0f, 1.0f);
        this.discard();
        return att;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.level().playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, (Holder)SoundEvents.GENERIC_EXPLODE, this.getSoundSource(), 1.0f, 1.0f);
        this.discard();
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(BIG, (Object)compound.getBoolean("Big"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Big", this.big());
    }
}

