/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MissileEntity
extends BaseProjectile {
    private Entity target;

    public MissileEntity(EntityType<? extends MissileEntity> type, Level level) {
        super(type, level);
    }

    public MissileEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.MISSILE.get()), level, shooter);
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public int livingTickMax() {
        return 120;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.target == null || !this.target.isAlive()) {
                List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0).expandTowards(this.getDeltaMovement()), e -> {
                    OwnableEntity ownable;
                    if (!e.isPickable() || !e.isAttackable()) {
                        return false;
                    }
                    if (e.equals((Object)this.getOwner()) || e instanceof OwnableEntity && (ownable = (OwnableEntity)e).getOwner() == this.getOwner()) {
                        return false;
                    }
                    return this.canHit((Entity)e);
                });
                double distSq = Double.MAX_VALUE;
                Entity res = null;
                for (Entity e2 : list) {
                    if (!(e2.distanceToSqr((Entity)this) < distSq)) continue;
                    res = e2;
                }
                if (res != null) {
                    this.target = res;
                }
            }
            if (this.target != null) {
                Vec3 dir;
                double angle = Math.acos((dir = this.target.getEyePosition().subtract(this.position()).normalize()).dot(this.getDeltaMovement()) / (dir.length() * this.getDeltaMovement().length()));
                dir = dir.scale(Math.abs(angle) > 0.18 ? 0.03 : 0.06);
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(dir));
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        LivingEntity living;
        Entity e = result.getEntity();
        int invul_time = 10;
        if (e instanceof LivingEntity && (living = (LivingEntity)e).getLastDamageSource() != null && living.getLastDamageSource().getDirectEntity() instanceof MissileEntity) {
            invul_time = 0;
        }
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), e, new DynamicDamage.Builder((Entity)this, this.getOwner()).magic().noKnockback().hurtResistant(invul_time).element(ItemElement.LIGHT).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null)) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            S2CScreenShake.sendAround((Entity)this, 20.0, 4, 2.0f);
            this.discard();
            return true;
        }
        this.discard();
        return false;
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        S2CScreenShake.sendAround((Entity)this, 20.0, 4, 2.0f);
        this.discard();
    }
}

