/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class MobArrowEntity
extends BaseProjectile {
    public MobArrowEntity(EntityType<? extends MobArrowEntity> type, Level level) {
        super(type, level);
    }

    public MobArrowEntity(Level level, LivingEntity shooter, float dmgMulti) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.ARROW.get()), level, shooter);
        this.damageMultiplier = dmgMulti;
    }

    protected boolean entityRayTraceHit(EntityHitResult res) {
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), res.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).projectile(), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null)) {
            Entity entity = res.getEntity();
            if (entity instanceof LivingEntity) {
                Entity entity2;
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                if (livingentity instanceof Player && (entity2 = this.getOwner()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    if (!this.isSilent()) {
                        serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            }
            this.discard();
            return true;
        }
        return false;
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
        this.discard();
    }
}

