/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RuneOrbEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> LEVELSTATS = SynchedEntityData.defineId(RuneOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int ticksExisted;

    public RuneOrbEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        ++this.ticksExisted;
        if (!this.level().isClientSide) {
            if (this.ticksExisted > 6000) {
                this.discard();
            }
        } else {
            AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(0.47058824f, 0.47058824f, 0.6666667f, 0.4f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.02), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.25f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getX(), this.getY() + (double)this.getBbHeight() * 0.2, this.getZ());
        }
    }

    public void playerTouch(Player player) {
        if (this.level().isClientSide) {
            return;
        }
        this.discard();
        Skills randomSkill = Skills.values()[player.getRandom().nextInt(Skills.values().length)];
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        if (((Boolean)this.entityData.get(LEVELSTATS)).booleanValue()) {
            data.increaseSkill(randomSkill, (float)LevelCalc.xpAmountForSkillLevelUp(randomSkill, data.getSkillLevel(randomSkill).getLevel()) - data.getSkillLevel(randomSkill).getXp());
        }
        data.regenRunePoints(150);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LEVELSTATS, (Object)true);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.ticksExisted = compound.getInt("TicksExisted");
        this.entityData.set(LEVELSTATS, (Object)compound.getBoolean("LevelStats"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("TicksExisted", this.ticksExisted);
        compound.putBoolean("LevelStats", ((Boolean)this.entityData.get(LEVELSTATS)).booleanValue());
    }
}

