/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpikeEntity
extends BaseDamageCloud {
    private static final int ATTACK_DURATION = 20;
    private static final int ATTACK_TICK = 10;
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(SpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int targetDuration;
    private int attackDelay;
    private int attackTime;
    private int clientAttackTime;
    private LivingEntity targetMob;
    private boolean attacking;
    public int clientLightLevelHeight;

    public SpikeEntity(EntityType<? extends SpikeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SpikeEntity(Level level, LivingEntity livingEntity, int targetDuration, int attackDelay, SpikeType spikeType) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.HOMING_SPIKES.get()), level, livingEntity);
        this.targetDuration = targetDuration;
        this.attackDelay = attackDelay;
        this.entityData.set(TYPE, (Object)spikeType.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    public void setEntityTarget(LivingEntity target) {
        this.targetMob = target;
    }

    public Vec3 getLightProbePosition(float partialTicks) {
        return this.getPosition(partialTicks).add(0.0, 2.1, 0.0);
    }

    public int livingTickMax() {
        return this.targetDuration + this.attackDelay + 20;
    }

    public int spikeType() {
        return (Integer)this.entityData.get(TYPE);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.attackDelay = compound.getInt("AttackDelay");
        this.targetDuration = compound.getInt("TargetDuration");
        this.attackTime = compound.getInt("AttackTime");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("AttackDelay", this.attackDelay);
        compound.putInt("TargetDuration", this.targetDuration);
        compound.putInt("AttackTime", this.attackTime);
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        double newX = this.getX() + motion.x;
        double newY = this.getY() + motion.y;
        double newZ = this.getZ() + motion.z;
        this.setPos(newX, newY, newZ);
        if (this.level().isClientSide) {
            if (!this.attacking) {
                double y = this.getY();
                BlockState current = this.level().getBlockState(this.blockPosition());
                if (current.isAir()) {
                    current = this.level().getBlockState(this.blockPosition().below());
                    if (current.isAir()) {
                        current = Blocks.DIRT.defaultBlockState();
                    } else {
                        y = Mth.floor((double)y);
                    }
                } else {
                    y = Mth.ceil((double)y);
                }
                for (int i = 0; i < 6; ++i) {
                    double dX = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                    double dY = 0.3 + this.random.nextDouble() * 0.3;
                    double dZ = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                    double pY = y + this.random.nextDouble() * 0.5 - 0.25;
                    this.clientLightLevelHeight = Mth.floor((double)y);
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, current), this.getRandomX(2.0), pY, this.getRandomZ(2.0), dX, dY, dZ);
                }
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), current.getSoundType().getStepSound(), this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.1f + 0.75f, false);
            }
        } else if (this.livingTicks < this.targetDuration) {
            if (this.targetMob == null || this.targetMob.isDeadOrDying()) {
                this.targetMob = EntityUtils.ownedProjectileTarget(this.getOwner(), 12);
            }
            if (this.targetMob != null) {
                Vec3 dir = this.targetMob.position().subtract(this.position()).normalize().scale(0.2);
                if (this.damageBoundingBox().inflate(-0.25).intersects(this.targetMob.getBoundingBox())) {
                    dir = Vec3.ZERO;
                    this.livingTicks = this.targetDuration;
                }
                this.setDeltaMovement(dir);
                this.hasImpulse = true;
            }
        } else if (++this.attackTime > this.attackDelay) {
            this.setDeltaMovement(Vec3.ZERO);
            if (!this.attacking) {
                this.level().broadcastEntityEvent((Entity)this, (byte)4);
                this.attacking = true;
            }
        }
    }

    public boolean canStartDamage() {
        return this.attackTime == 10;
    }

    protected AABB damageBoundingBox() {
        return new AABB(-0.6, -0.2, -0.6, 0.6, 2.2, 0.6).move(this.position());
    }

    protected boolean damageEntity(LivingEntity target) {
        DynamicDamage.Builder builder = new DynamicDamage.Builder((Entity)this, this.getOwner()).element(ItemElement.EARTH).knock(DynamicDamage.KnockBackType.UP, 0.5f).magic().hurtResistant(0);
        return CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, builder, CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 4) {
            this.attacking = true;
            this.clientAttackTime = this.livingTicks;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)RuneCraftorySounds.ENTITY_EARTH_SPIKE_ATTACK.get(), this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.1f + 0.75f, false);
            }
        }
    }

    public float getAnimationProgress(float partialTicks) {
        if (!this.attacking) {
            return 0.0f;
        }
        int i = this.livingTicks - this.clientAttackTime;
        float lerped = Math.min(20.0f, Mth.lerp((float)partialTicks, (float)i, (float)(i + 1)));
        return Mth.sin((float)(lerped * (float)Math.PI / 20.0f)) * 1.2f;
    }

    public static enum SpikeType {
        EARTH,
        ROOT;

    }
}

