/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ParticleMetaData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class StatusBallEntity
extends BaseDamageCloud {
    private static final EntityDataAccessor<Integer> TYPE_DATA = SynchedEntityData.defineId(StatusBallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Type type = Type.SLEEP;
    private int maxLivingTicks;

    public StatusBallEntity(EntityType<? extends StatusBallEntity> type, Level level) {
        super(type, level);
    }

    public StatusBallEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)RuneCraftoryEntities.STATUS_BALL.get()), level, shooter);
        this.setPos(shooter.getX(), shooter.getY(), shooter.getZ());
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE_DATA, (Object)0);
    }

    public void setType(Type type) {
        this.type = type;
        this.entityData.set(TYPE_DATA, (Object)this.type.ordinal());
        this.maxLivingTicks = this.type.maxLivingTicks;
    }

    public void setLivingTicksMax(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        int id;
        super.onSyncedDataUpdated(key);
        if (key == TYPE_DATA && (id = ((Integer)this.entityData.get(TYPE_DATA)).intValue()) >= 0 && id < Type.values().length) {
            this.type = Type.values()[id];
        }
    }

    public void shootAtPos(Vec3 targetPos, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(targetPos.x() - this.getX(), targetPos.y() - this.getY(), targetPos.z() - this.getZ());
        this.shoot(dir.x, dir.y, dir.z, velocity, inaccuracy);
    }

    public void shootFromRotation(Entity shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.sin((float)((pitch + pitchOffset) * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, g, h, velocity, inaccuracy);
        Vec3 vec3 = shooter.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3.x, shooter.onGround() ? 0.0 : vec3.y, vec3.z));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((Vec3)vector3d));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            switch (this.type.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    Vector3f color = this.type.particleColor;
                    AdvancedParticleContainer.make((ParticleOptions)((ParticleOptions)RuneCraftoryParticles.LIGHT.get())).addData((AdvancedParticleData)new ColorData(color.x(), color.y(), color.z(), 0.6f)).addData((AdvancedParticleData)new MotionData(this.random.nextGaussian() * 0.01, Math.abs(this.random.nextGaussian() * 0.03), this.random.nextGaussian() * 0.01)).addData((AdvancedParticleData)new ScaleData(0.4f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getRandomX(1.0), this.getY(this.getRandom().nextDouble() * 0.5) + (double)this.getBbHeight() * 0.4, this.getRandomZ(1.0));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Vector3f color = this.type.particleColor;
                    AdvancedParticleContainer.make((ParticleOptions)new DustParticleOptions(color, 1.0f)).addData((AdvancedParticleData)new ScaleData(0.2f)).addData((AdvancedParticleData)new ParticleMetaData(10, false, 0.0f)).add(this.level(), this.getRandomX(1.0), this.getY(this.getRandom().nextDouble() * 0.5) + (double)this.getBbHeight() * 0.4, this.getRandomZ(1.0));
                }
            }
        }
        Vec3 motion = this.getDeltaMovement();
        double newX = this.getX() + motion.x;
        double newY = this.getY() + motion.y;
        double newZ = this.getZ() + motion.z;
        this.setPos(newX, newY, newZ);
    }

    protected boolean damageEntity(LivingEntity target) {
        DynamicDamage.Builder builder = new DynamicDamage.Builder((Entity)this, this.getOwner()).noKnockback();
        this.type.damageMod.accept(builder);
        if (CombatUtils.damageWithFaintAndCrit(this.getOwner(), (Entity)target, builder, CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            this.discard();
            return true;
        }
        return false;
    }

    protected AABB damageBoundingBox() {
        return this.getBoundingBox().inflate(0.3, 0.45, 0.3);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("StatusType", this.type.ordinal());
        compound.putInt("MaxTicks", this.maxLivingTicks);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.type = Type.values()[compound.getInt("StatusType")];
        this.maxLivingTicks = compound.getInt("MaxTicks");
    }

    public static enum Type {
        SLEEP(b -> b.magic().element(ItemElement.EARTH).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.SLEEP.asHolder(), 100.0), new Vector3f(0.8117647f, 0.050980393f, 0.14901961f), 80),
        MUSHROOM_POISON(b -> b.magic().withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.POISON.asHolder(), 50.0), new Vector3f(0.4392157f, 0.7882353f, 0.37254903f), 40),
        PARALYSIS(b -> b.magic().withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.PARALYSIS.asHolder(), 50.0), new Vector3f(0.76862746f, 0.7294118f, 0.13725491f), 40),
        RAFFLESIA_SLEEP(b -> b.hurtResistant(2).magic().withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.SLEEP.asHolder(), 10.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.FATIGUE.asHolder(), 2.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.COLD.asHolder(), 2.0), new Vector3f(0.8117647f, 0.050980393f, 0.14901961f), 30),
        RAFFLESIA_PARALYSIS(b -> b.hurtResistant(2).magic().withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.PARALYSIS.asHolder(), 7.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.FATIGUE.asHolder(), 2.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.COLD.asHolder(), 2.0), new Vector3f(0.8f, 0.74509805f, 0.22352941f), 30),
        RAFFLESIA_POISON(b -> b.hurtResistant(2).magic().withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.POISON.asHolder(), 7.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.FATIGUE.asHolder(), 2.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.COLD.asHolder(), 2.0), new Vector3f(0.72156864f, 0.21960784f, 0.81960785f), 30),
        RAFFLESIA_ALL(b -> b.hurtResistant(2).magic().withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.SLEEP.asHolder(), 5.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.PARALYSIS.asHolder(), 5.0).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.POISON.asHolder(), 5.0), new Vector3f(0.5294118f, 0.09019608f, 0.11372549f), 30);

        public final Consumer<DynamicDamage.Builder> damageMod;
        public final Vector3f particleColor;
        public final int maxLivingTicks;

        private Type(Consumer<DynamicDamage.Builder> damageMod, Vector3f particleColor, int maxLivingTicks) {
            this.damageMod = damageMod;
            this.particleColor = particleColor;
            this.maxLivingTicks = maxLivingTicks;
        }
    }
}

