/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class WaterLaserEntity
extends BaseBeam {
    private static final EntityDataAccessor<Float> RANGE = SynchedEntityData.defineId(WaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> MAX_LIVING_TICK = SynchedEntityData.defineId(WaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> YAW_OFFSET = SynchedEntityData.defineId(WaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Vector3f> OFFSET = SynchedEntityData.defineId(WaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Boolean> ROTATION_FROM_OFFSET = SynchedEntityData.defineId(WaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final Object2IntMap<Entity> hitEntities = new Object2IntOpenHashMap();
    private float accumulatedRot;
    private UUID other;

    public WaterLaserEntity(EntityType<? extends WaterLaserEntity> type, Level level) {
        super(type, level);
    }

    public WaterLaserEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.WATER_LASER.get()), level, shooter);
    }

    public WaterLaserEntity(Level level, LivingEntity shooter, Vector3f offset) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.WATER_LASER.get()), level, shooter);
        this.entityData.set(OFFSET, (Object)offset);
        this.updateYawPitch();
    }

    public WaterLaserEntity setMaxTicks(int ticks) {
        this.entityData.set(MAX_LIVING_TICK, (Object)ticks);
        return this;
    }

    public void setYawOffset(float offset) {
        this.entityData.set(YAW_OFFSET, (Object)Float.valueOf(offset));
        this.updateYawPitch();
    }

    public void setTwinId(UUID other) {
        this.other = other;
    }

    public void setRange(float range) {
        this.entityData.set(RANGE, (Object)Float.valueOf(range));
    }

    public void setRotationFromOffset() {
        this.entityData.set(ROTATION_FROM_OFFSET, (Object)true);
        this.updateYawPitch();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAX_LIVING_TICK, (Object)20);
        builder.define(YAW_OFFSET, (Object)Float.valueOf(0.0f));
        builder.define(OFFSET, (Object)new Vector3f());
        builder.define(RANGE, (Object)Float.valueOf(10.0f));
        builder.define(ROTATION_FROM_OFFSET, (Object)false);
    }

    public float getRange() {
        return ((Float)this.entityData.get(RANGE)).floatValue();
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return (Integer)this.entityData.get(MAX_LIVING_TICK);
    }

    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.getOwner() != null) {
            this.setupRotationAndPosition(this.getOwner(), this.getOwner());
        }
    }

    public void setupRotationAndPosition(Entity positionEntity, Entity from) {
        float[] yxRot;
        float yRot = this.getYRot();
        float xRot = this.getXRot();
        Vector3f offset = ((Vector3f)this.entityData.get(OFFSET)).rotateY(-(from.getYRot() + ((Float)this.entityData.get(YAW_OFFSET)).floatValue()) * ((float)Math.PI / 180), new Vector3f());
        if (((Boolean)this.entityData.get(ROTATION_FROM_OFFSET)).booleanValue()) {
            float pitch = from.getXRot();
            Vec3 look = Vec3.directionFromRotation((float)pitch, (float)from.getYRot()).scale((double)offset.length());
            Vec3 up = Vec3.directionFromRotation((float)(pitch - 90.0f), (float)from.getYRot());
            offset = new Vector3f((float)look.x(), (float)look.y(), (float)look.z()).rotateAxis(((Float)this.entityData.get(YAW_OFFSET)).floatValue() * ((float)Math.PI / 180), (float)up.x(), (float)up.y(), (float)up.z(), new Vector3f());
            yxRot = MathsHelper.YXRotFrom(offset.x(), offset.y(), offset.z());
        } else {
            yxRot = new float[]{from.getYRot() + ((Float)this.entityData.get(YAW_OFFSET)).floatValue(), from.getXRot()};
        }
        this.setXRot(yxRot[1]);
        this.setYRot(yxRot[0]);
        this.setPos(positionEntity.getX() + (double)offset.x(), positionEntity.getY() + (double)positionEntity.getEyeHeight() - 0.1 + (double)offset.y(), positionEntity.getZ() + (double)offset.z());
        this.accumulatedRot += Math.abs(this.getYRot() - yRot) + Math.abs(this.getXRot() - xRot);
    }

    public boolean getHitVecFromShooter() {
        return this.getOwner() instanceof Player;
    }

    public void tick() {
        if (this.accumulatedRot > 15.0f) {
            this.hitEntities.clear();
            this.accumulatedRot = 0.0f;
        }
        super.tick();
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            boolean keep;
            ServerPlayer player = (ServerPlayer)entity;
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            AnimationState action = data.getWeaponHandler().getAnimation();
            boolean bl = keep = action != null && action.is(new String[]{PlayerModelAnimations.WATER_LASER_ONE, PlayerModelAnimations.WATER_LASER_TWO, PlayerModelAnimations.WATER_LASER_THREE});
            if (!keep && this.tickCount < this.livingTickMax() - 5) {
                this.entityData.set(MAX_LIVING_TICK, (Object)(this.tickCount + 5));
            }
        }
    }

    public void onImpact(EntityHitResult res) {
        LivingEntity living;
        Entity e = res.getEntity();
        int invul_time = 5;
        if (e instanceof LivingEntity && (living = (LivingEntity)e).getLastDamageSource() != null && living.getLastDamageSource().getDirectEntity() != null && living.getLastDamageSource().getDirectEntity().getUUID().equals(this.other)) {
            invul_time = 0;
        }
        CombatUtils.damageWithFaintAndCrit(this.getOwner(), e, new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(invul_time).magic().noKnockback().element(ItemElement.WATER), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.hitEntities.put((Object)e, this.tickCount);
    }

    @Override
    protected boolean check(Entity e, Predicate<AABB> intersects) {
        if (this.tickCount - this.hitEntities.getOrDefault((Object)e, this.tickCount - 20) <= 19) {
            return false;
        }
        return super.check(e, intersects);
    }

    public boolean canStartDamage() {
        return true;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(RANGE, (Object)Float.valueOf(compound.getFloat("Range")));
        this.entityData.set(MAX_LIVING_TICK, (Object)compound.getInt("MaxTicks"));
        this.entityData.set(YAW_OFFSET, (Object)Float.valueOf(compound.getFloat("YawOffset")));
        this.entityData.set(OFFSET, (Object)new Vector3f(compound.getFloat("OffsetX"), compound.getFloat("OffsetY"), compound.getFloat("OffsetZ")));
        this.entityData.set(ROTATION_FROM_OFFSET, (Object)compound.getBoolean("RotationFromOffset"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Range", ((Float)this.entityData.get(RANGE)).floatValue());
        compound.putInt("MaxTicks", ((Integer)this.entityData.get(MAX_LIVING_TICK)).intValue());
        compound.putFloat("YawOffset", ((Float)this.entityData.get(YAW_OFFSET)).floatValue());
        Vector3f offset = (Vector3f)this.entityData.get(OFFSET);
        compound.putFloat("OffsetX", offset.x());
        compound.putFloat("OffsetY", offset.y());
        compound.putFloat("OffsetZ", offset.z());
        compound.putBoolean("RotationFromOffset", ((Boolean)this.entityData.get(ROTATION_FROM_OFFSET)).booleanValue());
    }
}

