/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.MobArrowEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.Orc;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class OrcArcher
extends Orc {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder(Orc.BUILDER, new String[]{SLEEP});
    public static final String MELEE = BUILDER.add("kick", AnimationsBuilder.definition((double)0.92).marker("attack", new double[]{0.58}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String RANGED = BUILDER.add("bow", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.6}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<OrcArcher> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public OrcArcher(EntityType<? extends OrcArcher> type, Level level) {
        super((EntityType<? extends Orc>)type, level);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(MELEE)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{RANGED}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(e -> e.getMainHandItem().getItem() instanceof BowItem).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(1, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifFurtherThan(7.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.2;
        double length = (double)this.getBbWidth() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        if (anim.is(new String[]{RANGED})) {
            this.startUsingItem(InteractionHand.MAIN_HAND);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{RANGED})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                if (this.getTarget() != null && this.getSensing().hasLineOfSight((Entity)this.getTarget())) {
                    this.shootArrow(this.getTarget());
                } else if (this.getFirstPassenger() instanceof Player) {
                    this.shootArrowFromRotation((LivingEntity)this);
                }
                this.stopUsingItem();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<OrcArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(RANGED);
            }
        }
    }

    private void shootArrow(LivingEntity target) {
        MobArrowEntity arrow = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
        arrow.shootAtEntity((Entity)target, 1.3f, 7 - this.level().getDifficulty().getId() * 2);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    private void shootArrowFromRotation(LivingEntity shooter) {
        MobArrowEntity arrow = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
        arrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 1.3f, 7 - this.level().getDifficulty().getId() * 2);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }
}

