/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record FaceFeaturesType(IndexedColorSetting irisSetting, IndexedColorSetting scleraSetting, IndexedColorSetting eyebrowSetting, Map<String, ExpressionFeature> expressionMap) implements NPCFeature.NPCFeatureHolder<FaceFeatures>
{
    public static final MapCodec<FaceFeaturesType> TYPE_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IndexedColorSetting.CODEC.fieldOf("iris").forGetter(d -> d.irisSetting), (App)IndexedColorSetting.CODEC.fieldOf("sclera").forGetter(d -> d.scleraSetting), (App)IndexedColorSetting.CODEC.fieldOf("eyebrow").forGetter(d -> d.eyebrowSetting), (App)Codec.unboundedMap((Codec)Codec.STRING, ExpressionFeature.CODEC).fieldOf("expressions").forGetter(d -> d.expressionMap)).apply((Applicative)inst, FaceFeaturesType::new));
    public static final MapCodec<FaceFeatures> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IndexedColorSetting.ResolvedIndexColor.CODEC.fieldOf("iris").forGetter(FaceFeatures::iris), (App)IndexedColorSetting.ResolvedIndexColor.CODEC.fieldOf("sclera").forGetter(FaceFeatures::sclera), (App)IndexedColorSetting.ResolvedIndexColor.CODEC.fieldOf("eyebrow").forGetter(FaceFeatures::eyebrow), (App)Codec.unboundedMap((Codec)Codec.STRING, ExpressionFeature.CODEC).fieldOf("expressions").forGetter(FaceFeatures::expressionMap)).apply((Applicative)inst, FaceFeatures::new));
    public static final StreamCodec<ByteBuf, FaceFeatures> STREAM_CODEC = StreamCodec.composite(IndexedColorSetting.ResolvedIndexColor.STREAM_CODEC, FaceFeatures::iris, IndexedColorSetting.ResolvedIndexColor.STREAM_CODEC, FaceFeatures::sclera, IndexedColorSetting.ResolvedIndexColor.STREAM_CODEC, FaceFeatures::eyebrow, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, ExpressionFeature.STREAM_CODEC), FaceFeatures::expressionMap, FaceFeatures::new);
    public static final Map<String, ExpressionFeature> DEFAULT_EXPRESSIONS = Map.of("eyes_closed", new ExpressionFeature(new TextureType("closed", true), new TextureType("closed", true), "closed"), "angry", new ExpressionFeature(TextureType.NONE, TextureType.NONE, "angry"));

    @Override
    public FaceFeatures create(NPCEntity npc) {
        return new FaceFeatures(this.irisSetting.resolve(npc.getRandom()), this.scleraSetting.resolve(npc.getRandom()), this.eyebrowSetting.resolve(npc.getRandom()), this.expressionMap);
    }

    @Override
    public NPCFeatureType<FaceFeatures> getType() {
        return (NPCFeatureType)RuneCraftoryNPCLooks.FACE.get();
    }

    public record FaceFeatures(IndexedColorSetting.ResolvedIndexColor iris, IndexedColorSetting.ResolvedIndexColor sclera, IndexedColorSetting.ResolvedIndexColor eyebrow, Map<String, ExpressionFeature> expressionMap) implements NPCFeature
    {
        public FaceFeatures(IndexedColorSetting.ResolvedIndexColor iris, IndexedColorSetting.ResolvedIndexColor sclera, IndexedColorSetting.ResolvedIndexColor eyebrow, Map<String, ExpressionFeature> expressionMap) {
            this.iris = iris;
            this.sclera = sclera;
            this.eyebrow = eyebrow;
            this.expressionMap = Map.copyOf(expressionMap);
        }

        @Nullable
        public String expressionTexture(NPCFeatureContainer features, String expression, ExpressionType type) {
            FaceFeatures feat = (FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
            ExpressionFeature exp = feat.expressionMap.get(expression);
            if (exp != null) {
                return switch (type.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> exp.iris().suffix();
                    case 1 -> exp.sclera().suffix();
                    case 2 -> exp.eyebrow();
                };
            }
            return null;
        }

        public boolean useSkinColor(NPCFeatureContainer features, String expression, ExpressionType type) {
            if (type == ExpressionType.EYEBROWS) {
                return false;
            }
            FaceFeatures feat = (FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
            ExpressionFeature exp = feat.expressionMap.get(expression);
            if (exp != null) {
                if (type == ExpressionType.IRIS) {
                    return exp.iris().useSkinColor();
                }
                return exp.sclera().useSkinColor();
            }
            return false;
        }

        public NPCFeatureType<FaceFeatures> type() {
            return (NPCFeatureType)RuneCraftoryNPCLooks.FACE.get();
        }
    }

    public record ExpressionFeature(TextureType iris, TextureType sclera, String eyebrow) {
        public static final Codec<ExpressionFeature> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TextureType.CODEC.fieldOf("iris").forGetter(d -> d.iris), (App)TextureType.CODEC.fieldOf("sclera").forGetter(d -> d.sclera), (App)Codec.STRING.fieldOf("eyebrow").forGetter(d -> d.eyebrow)).apply((Applicative)inst, ExpressionFeature::new));
        public static final StreamCodec<ByteBuf, ExpressionFeature> STREAM_CODEC = StreamCodec.composite(TextureType.STREAM_CODEC, ExpressionFeature::iris, TextureType.STREAM_CODEC, ExpressionFeature::sclera, (StreamCodec)ByteBufCodecs.STRING_UTF8, ExpressionFeature::eyebrow, ExpressionFeature::new);
    }

    public record TextureType(String suffix, boolean useSkinColor) {
        public static TextureType NONE = new TextureType("", false);
        public static final Codec<TextureType> CODEC = Codec.either((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("suffix").forGetter(d -> d.suffix), (App)Codec.BOOL.fieldOf("use_skin_color").forGetter(d -> d.useSkinColor)).apply((Applicative)inst, TextureType::new))).xmap(e -> (TextureType)e.map(s -> new TextureType((String)s, false), t -> t), t -> !t.useSkinColor ? Either.left((Object)t.suffix()) : Either.right((Object)t));
        public static final StreamCodec<ByteBuf, TextureType> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TextureType::suffix, (StreamCodec)ByteBufCodecs.BOOL, TextureType::useSkinColor, TextureType::new);
    }

    public static enum ExpressionType {
        IRIS,
        SCLERA,
        EYEBROWS;

    }
}

