/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class IndexedColorSettingType
implements NPCFeature.NPCFeatureHolder<IndexedColorFeature> {
    public static final Function<Supplier<NPCFeatureType<IndexedColorFeature>>, MapCodec<IndexedColorSettingType>> TYPE_CODEC = type -> RecordCodecBuilder.mapCodec(arg_0 -> IndexedColorSettingType.lambda$static$3((Supplier)type, arg_0));
    public static final Function<Supplier<NPCFeatureType<IndexedColorFeature>>, MapCodec<IndexedColorFeature>> CODEC = type -> RecordCodecBuilder.mapCodec(arg_0 -> IndexedColorSettingType.lambda$static$6((Supplier)type, arg_0));
    public static final Function<Supplier<NPCFeatureType<IndexedColorFeature>>, StreamCodec<ByteBuf, IndexedColorFeature>> STREAM_CODEC = type -> StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, IndexedColorFeature::index, (StreamCodec)ByteBufCodecs.INT, IndexedColorFeature::color, (arg_0, arg_1) -> IndexedColorSettingType.lambda$static$8((Supplier)type, arg_0, arg_1));
    private final List<Integer> indices;
    private final ColorSetting color;
    private final Supplier<NPCFeatureType<IndexedColorFeature>> type;

    public IndexedColorSettingType(Supplier<NPCFeatureType<IndexedColorFeature>> type, List<Integer> indices, ColorSetting setting) {
        this.indices = indices;
        this.color = setting;
        this.type = type;
    }

    @Override
    public IndexedColorFeature create(NPCEntity npc) {
        int index = this.indices.isEmpty() ? 0 : this.indices.get(npc.getRandom().nextInt(this.indices.size()));
        return new IndexedColorFeature(this.type.get(), index, this.color.getRandom(npc.getRandom()));
    }

    @Override
    public NPCFeatureType<IndexedColorFeature> getType() {
        return this.type.get();
    }

    public static NPCFeatureType<IndexedColorFeature> createSimple(Supplier<NPCFeatureType<IndexedColorFeature>> type) {
        return new NPCFeatureType<IndexedColorFeature>(TYPE_CODEC.apply(type), CODEC.apply(type), STREAM_CODEC.apply(type));
    }

    private static /* synthetic */ IndexedColorFeature lambda$static$8(Supplier type, Integer idx, Integer color) {
        return new IndexedColorFeature((NPCFeatureType)type.get(), idx, color);
    }

    private static /* synthetic */ App lambda$static$6(Supplier type, RecordCodecBuilder.Instance inst) {
        return inst.group((App)Codec.INT.fieldOf("index").forGetter(IndexedColorFeature::index), (App)Codec.INT.fieldOf("color").forGetter(IndexedColorFeature::color)).apply((Applicative)inst, (arg_0, arg_1) -> IndexedColorSettingType.lambda$static$5((Supplier)type, arg_0, arg_1));
    }

    private static /* synthetic */ IndexedColorFeature lambda$static$5(Supplier type, Integer index, Integer color) {
        return new IndexedColorFeature((NPCFeatureType)type.get(), index, color);
    }

    private static /* synthetic */ App lambda$static$3(Supplier type, RecordCodecBuilder.Instance inst) {
        return inst.group((App)Codec.INT.listOf().fieldOf("indices").forGetter(d -> d.indices), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.color)).apply((Applicative)inst, (arg_0, arg_1) -> IndexedColorSettingType.lambda$static$2((Supplier)type, arg_0, arg_1));
    }

    private static /* synthetic */ IndexedColorSettingType lambda$static$2(Supplier type, List indices, ColorSetting color) {
        return new IndexedColorSettingType(type, indices, color);
    }

    public record IndexedColorFeature(NPCFeatureType<IndexedColorFeature> type, int index, int color) implements NPCFeature
    {
    }
}

